/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectSerializer;

public class ExternalProjectDataCache {
    private static final Logger LOG = Logger.getInstance(ExternalProjectDataCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Pair<ProjectSystemId, File>, ExternalProject> myExternalRootProjects;

    public static ExternalProjectDataCache getInstance(@NotNull Project project) {
        return (ExternalProjectDataCache)ServiceManager.getService((Project)project, ExternalProjectDataCache.class);
    }

    public ExternalProjectDataCache(@NotNull Project project) {
        this.myProject = project;
        this.myExternalRootProjects = new ConcurrentFactoryMap<Pair<ProjectSystemId, File>, ExternalProject>(){

            protected Map<Pair<ProjectSystemId, File>, ExternalProject> createMap() {
                return ContainerUtil.newConcurrentMap((TObjectHashingStrategy)ExternalSystemUtil.HASHING_STRATEGY);
            }

            @Nullable
            protected ExternalProject create(Pair<ProjectSystemId, File> key) {
                return new ExternalProjectSerializer().load((ProjectSystemId)key.first, (File)key.second);
            }

            public ExternalProject put(Pair<ProjectSystemId, File> key, ExternalProject value) {
                new ExternalProjectSerializer().save(value);
                return (ExternalProject)super.put(key, (Object)value);
            }
        };
    }

    @Nullable
    public ExternalProject getRootExternalProject(@NotNull ProjectSystemId systemId, @NotNull File projectRootDir) {
        ExternalProject externalProject = this.myExternalRootProjects.get(Pair.create((Object)systemId, (Object)projectRootDir));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Can not find data for project at: " + projectRootDir);
            LOG.debug("Existing imported projects paths: " + ContainerUtil.map(this.myExternalRootProjects.entrySet(), entry -> {
                if (!(entry.getValue() instanceof ExternalProject)) {
                    return null;
                }
                return Pair.create(entry.getKey(), (Object)((ExternalProject)entry.getValue()).getProjectDir());
            }));
        }
        return externalProject;
    }

    public void saveExternalProject(@NotNull ExternalProject externalProject) {
        this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)Pair.create((Object)new ProjectSystemId(externalProject.getExternalSystemId()), (Object)externalProject.getProjectDir()), (ExternalProject)new DefaultExternalProject(externalProject));
    }

    @NotNull
    public Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull Module module) {
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        return externalProjectId != null ? ExternalProjectDataCache.findExternalProject(parentProject, externalProjectId) : Collections.emptyMap();
    }

    @NotNull
    private static Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull String externalProjectId) {
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(parentProject);
        while (!queue.isEmpty()) {
            ExternalProject externalProject = (ExternalProject)queue.remove();
            String projectId = externalProject.getQName();
            boolean isRelatedProject = projectId.equals(externalProjectId);
            HashMap result = ContainerUtil.newHashMap();
            for (Map.Entry sourceSetEntry : externalProject.getSourceSets().entrySet()) {
                String sourceSetName = (String)sourceSetEntry.getKey();
                String sourceSetId = projectId + ":" + sourceSetName;
                if (!isRelatedProject && !externalProjectId.equals(sourceSetId)) continue;
                result.put(sourceSetName, sourceSetEntry.getValue());
            }
            if (!result.isEmpty() || isRelatedProject) {
                return result;
            }
            queue.addAll(externalProject.getChildProjects().values());
        }
        return Collections.emptyMap();
    }
}

