/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControl;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class ImportFromGradleControl
extends AbstractImportFromExternalSystemControl<GradleProjectSettings, GradleSettingsListener, GradleSettings> {
    public ImportFromGradleControl() {
        super(GradleConstants.SYSTEM_ID, (AbstractExternalSystemSettings)new GradleSettings(ProjectManager.getInstance().getDefaultProject()), (ExternalProjectSettings)ImportFromGradleControl.getInitialProjectSettings(), true);
    }

    @NotNull
    private static GradleProjectSettings getInitialProjectSettings() {
        GradleProjectSettings result = new GradleProjectSettings();
        String gradleHome = GradleUtil.getLastUsedGradleHome();
        if (!StringUtil.isEmpty((String)gradleHome)) {
            result.setGradleHome(gradleHome);
        }
        return result;
    }

    @NotNull
    protected ExternalSystemSettingsControl<GradleProjectSettings> createProjectSettingsControl(@NotNull GradleProjectSettings settings) {
        return new GradleProjectSettingsControl(settings);
    }

    @Nullable
    protected ExternalSystemSettingsControl<GradleSettings> createSystemSettingsControl(@NotNull GradleSettings settings) {
        return new GradleSystemSettingsControl(settings);
    }

    protected void onLinkedProjectPathChange(@NotNull String path) {
        ((GradleProjectSettingsControl)this.getProjectSettingsControl()).update(path, false);
    }

    public void setCurrentProject(@Nullable Project currentProject) {
        super.setCurrentProject(currentProject);
        ((GradleProjectSettingsControl)this.getProjectSettingsControl()).setCurrentProject(currentProject);
    }
}

