/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;

public class GradleExecutionWorkspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final List<GradleBuildParticipant> myBuildParticipants = ContainerUtil.newArrayList();
    private Map<String, Pair<DataNode<ModuleData>, IdeaModule>> myModuleMap;

    public void addBuildParticipant(GradleBuildParticipant participant) {
        this.myBuildParticipants.add(participant);
    }

    @NotNull
    public List<GradleBuildParticipant> getBuildParticipants() {
        return Collections.unmodifiableList(this.myBuildParticipants);
    }

    @Nullable
    public ModuleData findModuleDataByArtifacts(Collection<File> artifacts) {
        GradleBuildParticipant buildParticipant;
        ModuleData result = null;
        Iterator<GradleBuildParticipant> iterator = this.myBuildParticipants.iterator();
        while (iterator.hasNext() && (result = (buildParticipant = iterator.next()).findModuleDataByArtifacts(artifacts)) == null) {
        }
        return result;
    }

    public ModuleData findModuleDataByName(String moduleName) {
        GradleBuildParticipant buildParticipant;
        ModuleData result = null;
        Pair<DataNode<ModuleData>, IdeaModule> modulePair = this.myModuleMap.get(moduleName);
        if (modulePair == null) {
            modulePair = this.myModuleMap.get(":" + moduleName);
        }
        if (modulePair != null) {
            return (ModuleData)((DataNode)modulePair.first).getData();
        }
        Iterator<GradleBuildParticipant> iterator = this.myBuildParticipants.iterator();
        while (iterator.hasNext() && (result = (buildParticipant = iterator.next()).findModuleDataByName(moduleName)) == null) {
        }
        return result;
    }

    public void addModuleMap(Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap) {
        this.myModuleMap = moduleMap;
    }
}

