/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@State(name="GradleLocalSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GradleLocalSettings
extends AbstractExternalSystemLocalSettings
implements PersistentStateComponent<MyState> {
    private final AtomicReference<Map<String, String>> myGradleHomes = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
    private final AtomicReference<Map<String, String>> myGradleVersions = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());

    public GradleLocalSettings(@NotNull Project project) {
        super(GradleConstants.SYSTEM_ID, project);
    }

    @NotNull
    public static GradleLocalSettings getInstance(@NotNull Project project) {
        return (GradleLocalSettings)((Object)ServiceManager.getService((Project)project, GradleLocalSettings.class));
    }

    @Nullable
    public String getGradleHome(String linkedProjectPath) {
        return this.myGradleHomes.get().get(linkedProjectPath);
    }

    @Nullable
    public String getGradleVersion(String linkedProjectPath) {
        return this.myGradleVersions.get().get(linkedProjectPath);
    }

    public void setGradleHome(@NotNull String linkedProjectPath, @NotNull String gradleHome) {
        this.myGradleHomes.get().put(linkedProjectPath, gradleHome);
        this.myGradleVersions.get().put(linkedProjectPath, GradleInstallationManager.getGradleVersion(gradleHome));
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        super.forgetExternalProjects(linkedProjectPathsToForget);
        for (String path : linkedProjectPathsToForget) {
            this.myGradleHomes.get().remove(path);
            this.myGradleVersions.get().remove(path);
        }
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        this.fillState(state);
        state.myGradleHomes = this.myGradleHomes.get();
        state.myGradleVersions = this.myGradleVersions.get();
        return state;
    }

    public void loadState(@NotNull MyState state) {
        super.loadState((AbstractExternalSystemLocalSettings.State)state);
        GradleLocalSettings.setIfNotNull(this.myGradleHomes, state.myGradleHomes);
        GradleLocalSettings.setIfNotNull(this.myGradleVersions, state.myGradleVersions);
    }

    public static class MyState
    extends AbstractExternalSystemLocalSettings.State {
        public Map<String, String> myGradleHomes = ContainerUtilRt.newHashMap();
        public Map<String, String> myGradleVersions = ContainerUtilRt.newHashMap();
    }
}

