/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;

public class GradleProjectSettings
extends ExternalProjectSettings {
    @Nullable
    private String myGradleHome;
    @Nullable
    private String myGradleJvm = "#USE_PROJECT_JDK";
    @Nullable
    private DistributionType distributionType;
    private boolean disableWrapperSourceDistributionNotification;
    private boolean resolveModulePerSourceSet = true;
    @Nullable
    private CompositeBuild myCompositeBuild;

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    public void setGradleHome(@Nullable String gradleHome) {
        this.myGradleHome = gradleHome;
    }

    @Nullable
    public String getGradleJvm() {
        return this.myGradleJvm;
    }

    public void setGradleJvm(@Nullable String gradleJvm) {
        this.myGradleJvm = gradleJvm;
    }

    @Nullable
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(@Nullable DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public boolean isDisableWrapperSourceDistributionNotification() {
        return this.disableWrapperSourceDistributionNotification;
    }

    public void setDisableWrapperSourceDistributionNotification(boolean disableWrapperSourceDistributionNotification) {
        this.disableWrapperSourceDistributionNotification = disableWrapperSourceDistributionNotification;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean useIdeModulePerSourceSet) {
        this.resolveModulePerSourceSet = useIdeModulePerSourceSet;
    }

    @OptionTag(tag="compositeConfiguration", nameAttribute="")
    @Nullable
    public CompositeBuild getCompositeBuild() {
        return this.myCompositeBuild;
    }

    public void setCompositeBuild(@Nullable CompositeBuild compositeBuild) {
        this.myCompositeBuild = compositeBuild;
    }

    @NotNull
    public ExternalProjectSettings clone() {
        GradleProjectSettings result = new GradleProjectSettings();
        this.copyTo(result);
        result.myGradleHome = this.myGradleHome;
        result.myGradleJvm = this.myGradleJvm;
        result.distributionType = this.distributionType;
        result.disableWrapperSourceDistributionNotification = this.disableWrapperSourceDistributionNotification;
        result.resolveModulePerSourceSet = this.resolveModulePerSourceSet;
        result.myCompositeBuild = this.myCompositeBuild != null ? this.myCompositeBuild.copy() : null;
        return result;
    }

    @Tag(value="compositeBuild")
    public static class CompositeBuild {
        @Nullable
        private CompositeDefinitionSource myCompositeDefinitionSource;
        private List<BuildParticipant> myCompositeParticipants = new SmartList();

        @Attribute
        @Nullable
        public CompositeDefinitionSource getCompositeDefinitionSource() {
            return this.myCompositeDefinitionSource;
        }

        public void setCompositeDefinitionSource(@Nullable CompositeDefinitionSource compositeDefinitionSource) {
            this.myCompositeDefinitionSource = compositeDefinitionSource;
        }

        @AbstractCollection(surroundWithTag=false, elementTag="build")
        @OptionTag(tag="builds", nameAttribute="")
        @NotNull
        public List<BuildParticipant> getCompositeParticipants() {
            return this.myCompositeParticipants;
        }

        public void setCompositeParticipants(List<BuildParticipant> compositeParticipants) {
            this.myCompositeParticipants = compositeParticipants == null ? new SmartList() : ContainerUtil.newArrayList(compositeParticipants);
        }

        @NotNull
        public CompositeBuild copy() {
            CompositeBuild result = new CompositeBuild();
            result.myCompositeParticipants = ContainerUtil.newArrayList();
            for (BuildParticipant participant : this.myCompositeParticipants) {
                result.myCompositeParticipants.add(participant.copy());
            }
            result.myCompositeDefinitionSource = this.myCompositeDefinitionSource;
            return result;
        }
    }
}

