/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.google.common.base.Objects;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GradleSystemRunningSettings", storages={@Storage(value="gradle.run.settings.xml")})
public class GradleSystemRunningSettings
implements PersistentStateComponent<MyState> {
    private boolean myUseGradleAwareMake;
    @NotNull
    private PreferredTestRunner myPreferredTestRunner = PreferredTestRunner.PLATFORM_TEST_RUNNER;

    @NotNull
    public static GradleSystemRunningSettings getInstance() {
        return (GradleSystemRunningSettings)ServiceManager.getService(GradleSystemRunningSettings.class);
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        state.useGradleAwareMake = this.myUseGradleAwareMake;
        state.preferredTestRunner = this.myPreferredTestRunner;
        return state;
    }

    public void loadState(MyState state) {
        this.myUseGradleAwareMake = state.useGradleAwareMake;
        this.myPreferredTestRunner = state.preferredTestRunner;
    }

    @NotNull
    public PreferredTestRunner getPreferredTestRunner() {
        return this.myUseGradleAwareMake ? PreferredTestRunner.GRADLE_TEST_RUNNER : this.myPreferredTestRunner;
    }

    @NotNull
    PreferredTestRunner getLastPreferredTestRunner() {
        return this.myPreferredTestRunner;
    }

    public void setPreferredTestRunner(@NotNull PreferredTestRunner preferredTestRunner) {
        this.myPreferredTestRunner = preferredTestRunner;
    }

    public boolean isUseGradleAwareMake() {
        return this.myUseGradleAwareMake;
    }

    public void setUseGradleAwareMake(boolean useGradleAwareMake) {
        this.myUseGradleAwareMake = useGradleAwareMake;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleSystemRunningSettings settings = (GradleSystemRunningSettings)o;
        return this.myUseGradleAwareMake == settings.myUseGradleAwareMake && this.myPreferredTestRunner == settings.myPreferredTestRunner;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myPreferredTestRunner, this.myUseGradleAwareMake});
    }

    public static enum PreferredTestRunner {
        PLATFORM_TEST_RUNNER,
        GRADLE_TEST_RUNNER,
        CHOOSE_PER_TEST;

    }

    public static class MyState {
        public PreferredTestRunner preferredTestRunner = PreferredTestRunner.PLATFORM_TEST_RUNNER;
        public boolean useGradleAwareMake;
    }
}

