/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.MultiRowFlowPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.ui.RichTextActionProcessor;

public class RichTextControlBuilder {
    private static final String RICH_TEXT_TOKEN_START = "{@";
    private static final String RICH_TEXT_TOKEN_END = "}";
    private final Map<String, RichTextProcessor> myProcessors = new HashMap<String, RichTextProcessor>();
    private final JPanel myResult = new JPanel(new GridBagLayout());
    private final Collection<JComponent> myComponents = new ArrayList<JComponent>();
    private Color myForegroundColor = this.myResult.getForeground();
    private Color myBackgroundColor = this.myResult.getBackground();
    private Font myFont = this.myResult.getFont();

    public RichTextControlBuilder() {
        this.registerProcessor(new RichTextActionProcessor());
    }

    public void setText(@NotNull String text) throws IllegalArgumentException {
        this.myResult.removeAll();
        this.myComponents.clear();
        ArrayList<JComponent> rowComponents = new ArrayList<JComponent>();
        RichTextProcessor metaDataProcessor = null;
        StringBuilder metaTokenData = new StringBuilder();
        boolean ignoreNext = false;
        for (String s : StringUtil.tokenize((StringTokenizer)new StringTokenizer(text, " \n", true))) {
            int start;
            if (ignoreNext || s.isEmpty()) {
                ignoreNext = false;
                continue;
            }
            if (metaDataProcessor != null) {
                int i = s.indexOf(RICH_TEXT_TOKEN_END);
                if (i >= 0) {
                    metaTokenData.append(s.substring(0, i));
                    JComponent component = metaDataProcessor.process(metaTokenData.toString());
                    if (component != null) {
                        rowComponents.add(component);
                    }
                    metaTokenData.setLength(0);
                    metaDataProcessor = null;
                    if (i + RICH_TEXT_TOKEN_END.length() >= s.length()) continue;
                    s = s.substring(i + RICH_TEXT_TOKEN_END.length());
                } else {
                    metaTokenData.append(s);
                    continue;
                }
            }
            if ((start = s.indexOf(RICH_TEXT_TOKEN_START)) >= 0) {
                String metaKey;
                if (start + RICH_TEXT_TOKEN_START.length() >= s.length()) {
                    throw new IllegalArgumentException(String.format("Invalid rich text detected. Meta data key is assumed to directly follow '%s' (no white spaces between them). Given text: '%s'", RICH_TEXT_TOKEN_START, text));
                }
                int end = s.indexOf(RICH_TEXT_TOKEN_END);
                boolean metaDataComplete = true;
                if (end < start) {
                    end = s.length();
                    metaDataComplete = false;
                }
                if ((metaDataProcessor = this.myProcessors.get(metaKey = s.substring(start + RICH_TEXT_TOKEN_START.length(), end))) == null) {
                    throw new IllegalArgumentException(String.format("No processor is registered for the meta-key '%s' (processors are available only for these keys - %s). Rich text: '%s'", metaKey, this.myProcessors.keySet(), text));
                }
                if (metaDataComplete) {
                    JComponent component = metaDataProcessor.process("");
                    if (component != null) {
                        rowComponents.add(component);
                    }
                    metaDataProcessor = null;
                    if (end >= s.length()) continue;
                    s = s.substring(end);
                } else {
                    ignoreNext = true;
                    continue;
                }
            }
            if (s.contains("\n")) {
                this.addRow(rowComponents);
                rowComponents.clear();
                continue;
            }
            JLabel label = new JLabel(s);
            label.setForeground(this.myForegroundColor);
            label.setBackground(this.myBackgroundColor);
            label.setFont(this.myFont);
            rowComponents.add(label);
        }
        if (!rowComponents.isEmpty()) {
            this.addRow(rowComponents);
        }
    }

    public void setForegroundColor(@NotNull Color foregroundColor) {
        this.myForegroundColor = foregroundColor;
    }

    public void setBackgroundColor(@NotNull Color backgroundColor) {
        this.myBackgroundColor = backgroundColor;
    }

    public void setFont(@NotNull Font font) {
        this.myFont = font;
    }

    public void registerProcessor(@NotNull RichTextProcessor processor) {
        this.myProcessors.put(processor.getKey(), processor);
    }

    @NotNull
    public JComponent build() {
        for (JComponent component : this.myComponents) {
            component.setForeground(this.myForegroundColor);
            component.setBackground(this.myBackgroundColor);
            component.setFont(this.myFont);
        }
        this.myResult.setForeground(this.myForegroundColor);
        this.myResult.setBackground(this.myBackgroundColor);
        this.myResult.setFont(this.myFont);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weighty = 1.0;
        constraints.fill = 3;
        this.myResult.add(Box.createVerticalStrut(1), constraints);
        return this.myResult;
    }

    private void addRow(@NotNull Collection<JComponent> rowComponents) {
        MultiRowFlowPanel row = new MultiRowFlowPanel(1, RichTextControlBuilder.getGapToUse(0), RichTextControlBuilder.getGapToUse(3));
        row.setBackground(this.myBackgroundColor);
        this.myComponents.add((JComponent)row);
        if (rowComponents.isEmpty()) {
            row.add(new JLabel(" "));
        } else {
            for (JComponent component : rowComponents) {
                row.add(component);
            }
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets.top = 3;
        this.myResult.add((Component)row, constraints);
    }

    private static int getGapToUse(int gap) {
        return UIUtil.isUnderAlloyLookAndFeel() ? gap - 4 : gap;
    }

    public static interface RichTextProcessor {
        @NotNull
        public String getKey();

        @Nullable
        public JComponent process(@NotNull String var1);
    }
}

