/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.SwitchTaskAction;
import com.intellij.tasks.config.TaskSettings;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchTaskCombo
extends ComboBoxAction
implements DumbAware {
    public JComponent createCustomComponent(Presentation presentation) {
        ComboBoxAction.ComboBoxButton button = new ComboBoxAction.ComboBoxButton(presentation){

            protected JBPopup createPopup(Runnable onDispose) {
                return SwitchTaskAction.createPopup(DataManager.getInstance().getDataContext((Component)((Object)this)), onDispose, false);
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return button;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        return new DefaultActionGroup();
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ComboBoxAction.ComboBoxButton button = (ComboBoxAction.ComboBoxButton)presentation.getClientProperty("customComponent");
        if (project == null || project.isDefault() || project.isDisposed() || button == null) {
            presentation.setEnabled(false);
            presentation.setText("");
            presentation.setIcon(null);
        } else {
            TaskManager taskManager = TaskManager.getManager((Project)project);
            LocalTask activeTask = taskManager.getActiveTask();
            presentation.setVisible(true);
            presentation.setEnabled(true);
            if (SwitchTaskCombo.isImplicit(activeTask) && taskManager.getAllRepositories().length == 0 && !TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO) {
                presentation.setVisible(false);
            } else {
                String s = SwitchTaskCombo.getText(activeTask);
                presentation.setText(s);
                presentation.setIcon(activeTask.getIcon());
                presentation.setDescription(activeTask.getSummary());
            }
        }
    }

    private static boolean isImplicit(LocalTask activeTask) {
        return activeTask.isDefault() && Comparing.equal((Object)activeTask.getCreated(), (Object)activeTask.getUpdated());
    }

    private static String getText(LocalTask activeTask) {
        String text = activeTask.getPresentableName();
        return StringUtil.first((String)text, (int)50, (boolean)true);
    }
}

