/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions.vcs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.ui.TaskDialogPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsOpenTaskPanel
extends TaskDialogPanel {
    private JPanel myPanel;
    private JTextField myBranchName;
    private JTextField myChangelistName;
    private JBCheckBox myCreateBranch;
    private JBCheckBox myCreateChangelist;
    private ComboBox myBranchFrom;
    private JBLabel myFromLabel;
    private JBCheckBox myUseBranch;
    private ComboBox myUseBranchCombo;
    private VcsTaskHandler myVcsTaskHandler;
    private static final String START_FROM_BRANCH = "start.from.branch";
    private final TaskManagerImpl myTaskManager;
    private final LocalTask myPreviousTask;

    public VcsOpenTaskPanel(final Project project, Task task) {
        this.$$$setupUI$$$();
        this.myTaskManager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        this.myPreviousTask = this.myTaskManager.getActiveTask();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsOpenTaskPanel.this.updateFields(false);
            }
        };
        this.myCreateChangelist.addActionListener(listener);
        this.myCreateBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VcsOpenTaskPanel.this.myCreateBranch.isSelected()) {
                    VcsOpenTaskPanel.this.myUseBranch.setSelected(false);
                }
                VcsOpenTaskPanel.this.updateFields(false);
            }
        });
        this.myUseBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VcsOpenTaskPanel.this.myUseBranch.isSelected()) {
                    VcsOpenTaskPanel.this.myCreateBranch.setSelected(false);
                }
                VcsOpenTaskPanel.this.updateFields(false);
            }
        });
        this.myCreateChangelist.setSelected(this.myTaskManager.getState().createChangelist);
        VcsTaskHandler[] handlers = VcsTaskHandler.getAllHandlers((Project)project);
        if (handlers.length == 0) {
            this.myCreateBranch.setSelected(false);
            this.myCreateBranch.setVisible(false);
            this.myBranchName.setVisible(false);
            this.myFromLabel.setVisible(false);
            this.myBranchFrom.setVisible(false);
        } else {
            for (VcsTaskHandler handler : handlers) {
                Object[] tasks = handler.getAllExistingTasks();
                if (tasks.length <= 0) continue;
                this.myVcsTaskHandler = handler;
                Arrays.sort(tasks);
                this.myBranchFrom.setModel(new DefaultComboBoxModel<Object>(tasks));
                this.myBranchFrom.setEnabled(true);
                this.myUseBranchCombo.setModel(new DefaultComboBoxModel<Object>(tasks));
                String startFrom = PropertiesComponent.getInstance((Project)project).getValue(START_FROM_BRANCH);
                VcsTaskHandler.TaskInfo info = null;
                if (startFrom != null) {
                    info = (VcsTaskHandler.TaskInfo)ContainerUtil.find((Object[])tasks, taskInfo -> startFrom.equals(taskInfo.getName()));
                }
                if (info == null) {
                    VcsTaskHandler.TaskInfo[] current = handler.getCurrentTasks();
                    info = current.length > 0 ? current[0] : tasks[0];
                }
                this.myBranchFrom.setSelectedItem((Object)info);
                this.myBranchFrom.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VcsTaskHandler.TaskInfo item = (VcsTaskHandler.TaskInfo)VcsOpenTaskPanel.this.myBranchFrom.getSelectedItem();
                        if (item != null) {
                            PropertiesComponent.getInstance((Project)project).setValue(VcsOpenTaskPanel.START_FROM_BRANCH, item.getName());
                        }
                    }
                });
                break;
            }
            this.myCreateBranch.setSelected(this.myTaskManager.getState().createBranch && this.myBranchFrom.getItemCount() > 0);
            this.myUseBranch.setSelected(this.myTaskManager.getState().useBranch && this.myUseBranchCombo.getItemCount() > 0);
            this.myBranchFrom.setRenderer((ListCellRenderer)((Object)new TaskInfoCellRenderer(this.myBranchFrom)));
            this.myUseBranchCombo.setRenderer((ListCellRenderer)((Object)new TaskInfoCellRenderer(this.myUseBranchCombo)));
        }
        this.myBranchName.setText(this.myVcsTaskHandler != null ? this.myVcsTaskHandler.cleanUpBranchName(this.myTaskManager.constructDefaultBranchName(task)) : this.myTaskManager.suggestBranchName(task));
        this.myChangelistName.setText(this.myTaskManager.getChangelistName(task));
        this.updateFields(true);
    }

    private void updateFields(boolean initial) {
        if (!initial && this.myBranchFrom.getItemCount() == 0 && this.myCreateBranch.isSelected()) {
            Messages.showWarningDialog((Component)this.myPanel, (String)"Can't create branch if no commit exists.\nCreate a commit first.", (String)"Cannot Create Branch");
            this.myCreateBranch.setSelected(false);
        }
        this.myBranchName.setEnabled(this.myCreateBranch.isSelected());
        this.myFromLabel.setEnabled(this.myCreateBranch.isSelected());
        this.myBranchFrom.setEnabled(this.myCreateBranch.isSelected());
        this.myUseBranchCombo.setEnabled(this.myUseBranch.isSelected());
        this.myChangelistName.setEnabled(this.myCreateChangelist.isSelected());
    }

    @NotNull
    public JComponent getPanel() {
        return this.myPanel;
    }

    public void commit() {
        VcsTaskHandler.TaskInfo branch;
        this.myTaskManager.getState().createChangelist = this.myCreateChangelist.isSelected();
        this.myTaskManager.getState().createBranch = this.myCreateBranch.isSelected();
        this.myTaskManager.getState().useBranch = this.myUseBranch.isSelected();
        LocalTask localTask = this.myTaskManager.getActiveTask();
        if (this.myCreateChangelist.isSelected()) {
            this.myTaskManager.createChangeList(localTask, this.myChangelistName.getText());
        }
        if (this.myCreateBranch.isSelected()) {
            VcsTaskHandler.TaskInfo branchFrom = (VcsTaskHandler.TaskInfo)this.myBranchFrom.getSelectedItem();
            Runnable createBranch = () -> this.myTaskManager.createBranch(localTask, this.myPreviousTask, this.myBranchName.getText(), branchFrom);
            VcsTaskHandler.TaskInfo[] current = this.myVcsTaskHandler.getCurrentTasks();
            if (!(branchFrom == null || current.length != 0 && current[0].equals((Object)branchFrom))) {
                this.myVcsTaskHandler.switchToTask(branchFrom, createBranch);
            } else {
                createBranch.run();
            }
        }
        if (this.myUseBranch.isSelected() && (branch = (VcsTaskHandler.TaskInfo)this.myUseBranchCombo.getSelectedItem()) != null) {
            VcsTaskHandler.TaskInfo[] tasks = this.myVcsTaskHandler.getCurrentTasks();
            TaskManagerImpl.addBranches(this.myPreviousTask, tasks, true);
            this.myVcsTaskHandler.switchToTask(branch, () -> TaskManagerImpl.addBranches(localTask, new VcsTaskHandler.TaskInfo[]{branch}, false));
        }
    }

    @Nullable
    public ValidationInfo validate() {
        if (this.myCreateBranch.isSelected()) {
            String branchName = this.myBranchName.getText().trim();
            if (branchName.isEmpty()) {
                return new ValidationInfo("Branch name should not be empty", (JComponent)this.myBranchName);
            }
            if (this.myVcsTaskHandler != null) {
                return this.myVcsTaskHandler.isBranchNameValid(branchName) ? null : new ValidationInfo("Branch name is not valid; check your vcs branch name restrictions.", (JComponent)this.myBranchName);
            }
            if (branchName.contains(" ")) {
                return new ValidationInfo("Branch name should not contain spaces", (JComponent)this.myBranchName);
            }
            return null;
        }
        if (this.myCreateChangelist.isSelected() && this.myChangelistName.getText().trim().isEmpty()) {
            return new ValidationInfo("Changelist name should not be empty", (JComponent)this.myChangelistName);
        }
        return null;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myCreateBranch.isSelected()) {
            return this.myBranchName;
        }
        if (this.myUseBranch.isSelected()) {
            return this.myUseBranchCombo;
        }
        if (this.myCreateChangelist.isSelected()) {
            return this.myChangelistName;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        ComboBox comboBox2;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"VCS operations", (int)0, (int)0, null, null));
        this.myBranchName = jTextField2 = new JTextField();
        ((Component)jTextField2).setEnabled(false);
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myChangelistName = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCreateBranch = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Create branch");
        jBCheckBox3.setMnemonic('B');
        jBCheckBox3.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCreateChangelist = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Create changelist");
        jBCheckBox2.setMnemonic('L');
        jBCheckBox2.setDisplayedMnemonicIndex(13);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBranchFrom = comboBox2 = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox2.setModel(defaultComboBoxModel);
        jPanel.add((Component)comboBox2, new GridConstraints(0, 3, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myFromLabel = jBLabel = new JBLabel();
        jBLabel.setText("from");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUseBranch = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use branch");
        jBCheckBox.setMnemonic('S');
        jBCheckBox.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseBranchCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox2);
    }

    private static class TaskInfoCellRenderer
    extends ColoredListCellRenderer<VcsTaskHandler.TaskInfo> {
        public TaskInfoCellRenderer(ComboBox from) {
            super((JComboBox)from);
        }

        protected void customizeCellRenderer(@NotNull JList list, VcsTaskHandler.TaskInfo value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.append(value.getName());
            }
        }
    }
}

