/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.config;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.binding.BindControl;
import com.intellij.openapi.options.binding.BindableConfigurable;
import com.intellij.openapi.options.binding.ControlBinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.config.TaskRepositoriesConfigurable;
import com.intellij.tasks.config.TaskSettings;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TaskConfigurable
extends BindableConfigurable
implements SearchableConfigurable.Parent,
Configurable.NoScroll {
    private JPanel myPanel;
    @BindControl(value="updateEnabled")
    private JCheckBox myUpdateCheckBox;
    @BindControl(value="updateIssuesCount")
    private JTextField myUpdateCount;
    @BindControl(value="updateInterval")
    private JTextField myUpdateInterval;
    @BindControl(value="taskHistoryLength")
    private JTextField myHistoryLength;
    private JPanel myCacheSettings;
    @BindControl(value="saveContextOnCommit")
    private JCheckBox mySaveContextOnCommit;
    @BindControl(value="changelistNameFormat")
    private JTextField myChangelistNameFormat;
    private JBCheckBox myAlwaysDisplayTaskCombo;
    private JTextField myConnectionTimeout;
    @BindControl(value="branchNameFormat")
    private JTextField myBranchNameFormat;
    private final Project myProject;
    private Configurable[] myConfigurables;
    private final NotNullLazyValue<ControlBinder> myControlBinder;

    public TaskConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myControlBinder = new NotNullLazyValue<ControlBinder>(){

            @NotNull
            protected ControlBinder compute() {
                return new ControlBinder((Object)TaskConfigurable.this.getConfig());
            }
        };
        this.myProject = project;
        this.myUpdateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskConfigurable.this.enableCachePanel();
            }
        });
    }

    private TaskManagerImpl.Config getConfig() {
        return ((TaskManagerImpl)TaskManager.getManager((Project)this.myProject)).getState();
    }

    protected ControlBinder getBinder() {
        return (ControlBinder)this.myControlBinder.getValue();
    }

    private void enableCachePanel() {
        GuiUtils.enableChildren((Component)this.myCacheSettings, (boolean)this.myUpdateCheckBox.isSelected(), (JComponent[])new JComponent[0]);
    }

    public void reset() {
        super.reset();
        this.enableCachePanel();
        this.myAlwaysDisplayTaskCombo.setSelected(TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO);
        this.myConnectionTimeout.setText(Integer.toString(TaskSettings.getInstance().CONNECTION_TIMEOUT));
    }

    public void apply() throws ConfigurationException {
        boolean oldUpdateEnabled = this.getConfig().updateEnabled;
        super.apply();
        TaskManager manager = TaskManager.getManager((Project)this.myProject);
        if (this.getConfig().updateEnabled && !oldUpdateEnabled) {
            manager.updateIssues(null);
        }
        TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO = this.myAlwaysDisplayTaskCombo.isSelected();
        int oldConnectionTimeout = TaskSettings.getInstance().CONNECTION_TIMEOUT;
        Integer connectionTimeout = Integer.valueOf(this.myConnectionTimeout.getText());
        TaskSettings.getInstance().CONNECTION_TIMEOUT = connectionTimeout;
        if (manager instanceof TaskManagerImpl && connectionTimeout != oldConnectionTimeout) {
            ((TaskManagerImpl)manager).reconfigureRepositoryClients();
        }
    }

    public boolean isModified() {
        return super.isModified() || TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO != this.myAlwaysDisplayTaskCombo.isSelected() || TaskSettings.getInstance().CONNECTION_TIMEOUT != Integer.valueOf(this.myConnectionTimeout.getText());
    }

    @Nls
    public String getDisplayName() {
        return "Tasks";
    }

    public String getHelpTopic() {
        return "reference.settings.project.tasks";
    }

    public JComponent createComponent() {
        this.bindAnnotations();
        return this.myPanel;
    }

    public void disposeUIResources() {
    }

    @NotNull
    public String getId() {
        return "tasks";
    }

    public boolean hasOwnContent() {
        return true;
    }

    public Configurable[] getConfigurables() {
        if (this.myConfigurables == null) {
            this.myConfigurables = new Configurable[]{new TaskRepositoriesConfigurable(this.myProject)};
        }
        return this.myConfigurables;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField4;
        JBCheckBox jBCheckBox;
        JTextField jTextField5;
        JCheckBox jCheckBox2;
        JTextField jTextField6;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHistoryLength = jTextField6 = new JTextField();
        jTextField6.setText("11");
        jPanel2.add((Component)jTextField6, new GridConstraints(2, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Task history length:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(13);
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(7, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        this.mySaveContextOnCommit = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Save context on commit");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Changelist name format:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(16);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myChangelistNameFormat = jTextField5 = new JTextField();
        jPanel2.add((Component)jTextField5, new GridConstraints(0, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAlwaysDisplayTaskCombo = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Always display task combo in toolbar");
        jBCheckBox.setMnemonic('D');
        jBCheckBox.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Connection timeout:");
        jBLabel2.setDisplayedMnemonic('T');
        jBLabel2.setDisplayedMnemonicIndex(11);
        jPanel2.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConnectionTimeout = jTextField4 = new JTextField();
        jTextField4.setText("3000");
        jPanel2.add((Component)jTextField4, new GridConstraints(3, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("milliseconds");
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myUpdateCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable issue cache");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(13);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCacheSettings = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Cache settings", (int)0, (int)0, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Update");
        jLabel3.setDisplayedMnemonic('U');
        jLabel3.setDisplayedMnemonicIndex(0);
        jLabel3.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myUpdateCount = jTextField3 = new JTextField();
        jTextField3.setText("11");
        jPanel.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("issues every");
        jLabel4.setDisplayedMnemonic('V');
        jLabel4.setDisplayedMnemonicIndex(8);
        jLabel4.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel4, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myUpdateInterval = jTextField2 = new JTextField();
        jTextField2.setText("11");
        jPanel.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("minutes");
        jPanel.add((Component)jLabel5, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(6, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Feature branch name format:");
        jBLabel3.setDisplayedMnemonic('F');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchNameFormat = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField6);
        jBLabel.setLabelFor(jTextField5);
        jBLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jBLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

