/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.generic.SelectorBasedResponseHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.Tag;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="JsonResponseHandler")
public final class JsonPathResponseHandler
extends SelectorBasedResponseHandler {
    private static final Map<Class<?>, String> JSON_TYPES = ContainerUtil.newHashMap((Pair)new Pair(Map.class, (Object)"JSON object"), (Pair[])new Pair[]{new Pair(List.class, (Object)"JSON array"), new Pair(String.class, (Object)"JSON string"), new Pair(Integer.class, (Object)"JSON number"), new Pair(Double.class, (Object)"JSON number"), new Pair(Boolean.class, (Object)"JSON boolean")});
    private final Map<String, JsonPath> myCompiledCache = new HashMap();

    public JsonPathResponseHandler() {
    }

    public JsonPathResponseHandler(GenericRepository repository) {
        super(repository);
    }

    @Nullable
    private Object extractRawValue(@NotNull Selector selector, @NotNull String source) throws Exception {
        Object value;
        if (StringUtil.isEmpty((String)selector.getPath())) {
            return null;
        }
        JsonPath jsonPath = this.lazyCompile(selector.getPath());
        try {
            value = jsonPath.read(source);
        }
        catch (InvalidPathException e) {
            throw new Exception(String.format("JsonPath expression '%s' doesn't match", selector.getPath()), e);
        }
        if (value == null) {
            return null;
        }
        return value;
    }

    @Nullable
    private <T> T extractValueAndCheckType(@NotNull Selector selector, @NotNull String source, Class<T> cls) throws Exception {
        Object value = this.extractRawValue(selector, source);
        if (value == null) {
            return null;
        }
        if (!cls.isInstance(value)) {
            throw new Exception(String.format("JsonPath expression '%s' should match %s. Got '%s' instead", selector.getPath(), JSON_TYPES.get(cls), value));
        }
        Object casted = value;
        return (T)casted;
    }

    @Override
    @NotNull
    protected List<Object> selectTasksList(@NotNull String response, int max) throws Exception {
        List list = this.extractValueAndCheckType(this.getSelector("tasks"), response, List.class);
        if (list == null) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.map2List((Collection)list, o -> o.toString()).subList(0, Math.min(list.size(), max));
    }

    @Override
    @Nullable
    protected String selectString(@NotNull Selector selector, @NotNull Object context) throws Exception {
        Object value = this.extractRawValue(selector, (String)context);
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        throw new Exception(String.format("JsonPath expression '%s' should match string value. Got '%s' instead", selector.getPath(), value));
    }

    @Override
    @Nullable
    protected Boolean selectBoolean(@NotNull Selector selector, @NotNull Object context) throws Exception {
        return this.extractValueAndCheckType(selector, (String)context, Boolean.class);
    }

    @Nullable
    private Long selectLong(@NotNull Selector selector, @NotNull String source) throws Exception {
        return this.extractValueAndCheckType(selector, source, Long.class);
    }

    @NotNull
    private JsonPath lazyCompile(@NotNull String path) throws Exception {
        JsonPath jsonPath = this.myCompiledCache.get(path);
        if (jsonPath == null) {
            try {
                jsonPath = JsonPath.compile((String)path, (Filter[])new Filter[0]);
                this.myCompiledCache.put(path, jsonPath);
            }
            catch (InvalidPathException e) {
                throw new Exception(String.format("Malformed JsonPath expression '%s'", path));
            }
        }
        return jsonPath;
    }

    @Override
    @NotNull
    public ResponseType getResponseType() {
        return ResponseType.JSON;
    }
}

