/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl.httpclient;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public class TaskResponseUtil {
    public static final Logger LOG = Logger.getInstance(TaskResponseUtil.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private TaskResponseUtil() {
    }

    public static Reader getResponseContentAsReader(@NotNull HttpResponse response) throws IOException {
        org.apache.http.Header header = response.getEntity().getContentEncoding();
        Charset charset = header == null ? DEFAULT_CHARSET : Charset.forName(header.getValue());
        return new InputStreamReader(response.getEntity().getContent(), charset);
    }

    public static String getResponseContentAsString(@NotNull HttpResponse response) throws IOException {
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)DEFAULT_CHARSET);
    }

    public static String getResponseContentAsString(@NotNull HttpMethod response) throws IOException {
        Header header = response.getResponseHeader("Content-Type");
        if (header != null && header.getValue().contains("charset")) {
            return StringUtil.notNullize((String)response.getResponseBodyAsString());
        }
        InputStream stream = response.getResponseBodyAsStream();
        return stream == null ? "" : StreamUtil.readText((InputStream)stream, (Charset)DEFAULT_CHARSET);
    }

    public static Reader getResponseContentAsReader(@NotNull HttpMethod response) throws IOException {
        InputStream stream = response.getResponseBodyAsStream();
        String charsetName = null;
        Header header = response.getResponseHeader("Content-Type");
        if (header != null) {
            for (HeaderElement part : header.getElements()) {
                NameValuePair pair = part.getParameterByName("charset");
                if (pair == null) continue;
                charsetName = pair.getValue();
            }
        }
        return new InputStreamReader(stream, charsetName == null ? DEFAULT_CHARSET_NAME : charsetName);
    }

    public static boolean isSuccessful(int statusCode) {
        return statusCode / 100 == 2;
    }

    public static boolean isClientError(int statusCode) {
        return statusCode / 100 == 4;
    }

    public static boolean isServerError(int statusCode) {
        return statusCode / 100 == 5;
    }

    public static final class GsonMultipleObjectsDeserializer<T>
    implements ResponseHandler<List<T>> {
        private final Gson myGson;
        private final TypeToken<List<T>> myTypeToken;
        private final boolean myIgnoreNotFound;

        public GsonMultipleObjectsDeserializer(Gson gson, TypeToken<List<T>> typeToken) {
            this(gson, typeToken, false);
        }

        public GsonMultipleObjectsDeserializer(@NotNull Gson gson, @NotNull TypeToken<List<T>> token, boolean ignoreNotFound) {
            this.myGson = gson;
            this.myTypeToken = token;
            this.myIgnoreNotFound = ignoreNotFound;
        }

        public List<T> handleResponse(HttpResponse response) throws IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (!TaskResponseUtil.isSuccessful(statusCode)) {
                if (statusCode == 404 && this.myIgnoreNotFound) {
                    return Collections.emptyList();
                }
                throw RequestFailedException.forStatusCode(statusCode);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    String content = TaskResponseUtil.getResponseContentAsString(response);
                    TaskUtil.prettyFormatJsonToLog(LOG, content);
                    return (List)this.myGson.fromJson(content, this.myTypeToken.getType());
                }
                return (List)this.myGson.fromJson(TaskResponseUtil.getResponseContentAsReader(response), this.myTypeToken.getType());
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Malformed server response", (Throwable)e);
                return Collections.emptyList();
            }
            catch (NumberFormatException e) {
                LOG.error("NFE in response: " + TaskResponseUtil.getResponseContentAsString(response), (Throwable)e);
                throw new RequestFailedException("Malformed response");
            }
        }
    }

    public static final class GsonSingleObjectDeserializer<T>
    implements ResponseHandler<T> {
        private final Gson myGson;
        private final Class<T> myClass;
        private final boolean myIgnoreNotFound;

        public GsonSingleObjectDeserializer(@NotNull Gson gson, @NotNull Class<T> cls) {
            this(gson, cls, false);
        }

        public GsonSingleObjectDeserializer(@NotNull Gson gson, @NotNull Class<T> cls, boolean ignoreNotFound) {
            this.myGson = gson;
            this.myClass = cls;
            this.myIgnoreNotFound = ignoreNotFound;
        }

        public T handleResponse(HttpResponse response) throws IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (!TaskResponseUtil.isSuccessful(statusCode)) {
                if (statusCode == 404 && this.myIgnoreNotFound) {
                    return null;
                }
                throw RequestFailedException.forStatusCode(statusCode);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    String content = TaskResponseUtil.getResponseContentAsString(response);
                    TaskUtil.prettyFormatJsonToLog(LOG, content);
                    return (T)this.myGson.fromJson(content, this.myClass);
                }
                return (T)this.myGson.fromJson(TaskResponseUtil.getResponseContentAsReader(response), this.myClass);
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Malformed server response", (Throwable)e);
                return null;
            }
        }
    }
}

