/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.io;

import com.android.io.FolderWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.IAbstractResource;
import com.android.tools.io.BufferingFileWrapper;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BufferingFolderWrapper
implements IAbstractFolder {
    private final File myFile;
    private final IAbstractFolder myDelegate;

    public BufferingFolderWrapper(@NotNull File file) {
        this.myFile = file;
        this.myDelegate = new FolderWrapper(file);
    }

    public boolean hasFile(String name) {
        return this.myDelegate.hasFile(name);
    }

    public IAbstractFile getFile(String name) {
        return new BufferingFileWrapper(new File(this.myFile, name));
    }

    public IAbstractFolder getFolder(String name) {
        return new BufferingFolderWrapper(new File(this.myFile, name));
    }

    public IAbstractResource[] listMembers() {
        File[] files = this.myFile.listFiles();
        if (files == null) {
            return new IAbstractResource[0];
        }
        IAbstractResource[] result = new IAbstractResource[files.length];
        for (int i = 0; i < result.length; ++i) {
            File file = files[i];
            result[i] = file.isFile() ? new BufferingFileWrapper(file) : new BufferingFolderWrapper(file);
        }
        return result;
    }

    public String[] list(IAbstractFolder.FilenameFilter filter) {
        return this.myDelegate.list(filter);
    }

    public String getName() {
        return this.myFile.getName();
    }

    public String getOsLocation() {
        return this.myFile.getAbsolutePath();
    }

    public String getPath() {
        return this.myFile.getPath();
    }

    public boolean exists() {
        return this.myFile.isDirectory();
    }

    @Nullable
    public IAbstractFolder getParentFolder() {
        File parent = this.myFile.getParentFile();
        return parent != null ? new BufferingFolderWrapper(parent) : null;
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferingFolderWrapper wrapper = (BufferingFolderWrapper)o;
        return FileUtil.filesEqual((File)this.myFile, (File)wrapper.myFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myFile);
    }
}

