/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.builder.internal.utils.FileCache;
import com.android.builder.model.OptionalCompilationStep;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.gradle.api.Project;

public class AndroidGradleOptions {
    public static final boolean DEFAULT_USE_OLD_PACKAGING = false;
    private static final boolean DEFAULT_ENABLE_AAPT2 = false;
    private static final boolean DEFAULT_ENABLE_BUILD_CACHE = false;
    private static final String PROPERTY_TEST_RUNNER_ARGS = "android.testInstrumentationRunnerArguments.";
    private static final String PROPERTY_THREAD_POOL_SIZE = "android.threadPoolSize";
    private static final String PROPERTY_THREAD_POOL_SIZE_OLD = "com.android.build.threadPoolSize";
    public static final String USE_DEPRECATED_NDK = "android.useDeprecatedNdk";
    private static final String PROPERTY_DISABLE_RESOURCE_VALIDATION = "android.disableResourceValidation";
    private static final String PROPERTY_BENCHMARK_NAME = "com.android.benchmark.name";
    private static final String PROPERTY_BENCHMARK_MODE = "com.android.benchmark.mode";
    public static final String PROPERTY_INCREMENTAL_JAVA_COMPILE = "android.incrementalJavaCompile";
    public static final String PROPERTY_USE_OLD_PACKAGING = "android.useOldPackaging";
    private static final String PROPERTY_KEEP_TIMESTAMPS_IN_APK = "android.keepTimestampsInApk";
    private static final String PROPERTY_ENABLE_AAPT2 = "android.enableAapt2";
    private static final String ANDROID_ADDITIONAL_PLUGINS = "android.additional.plugins";
    public static final String PROPERTY_BUILD_ONLY_TARGET_ABI = "android.buildOnlyTargetAbi";
    private static final String PROPERTY_SHARD_TESTS_BETWEEN_DEVICES = "android.androidTest.shardBetweenDevices";
    private static final String PROPERTY_SHARD_COUNT = "android.androidTest.numShards";
    public static final String PROPERTY_USE_SDK_DOWNLOAD = "android.builder.sdkDownload";
    private static final String PROPERTY_ENABLE_BUILD_CACHE = "android.enableBuildCache";
    private static final String PROPERTY_BUILD_CACHE_DIR = "android.buildCacheDir";
    public static final String GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY = "android.overrideVersionCheck";
    private static final String OLD_GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY = "com.android.build.gradle.overrideVersionCheck";
    public static final String OVERRIDE_PATH_CHECK_PROPERTY = "android.overridePathCheck";
    private static final String OLD_OVERRIDE_PATH_CHECK_PROPERTY = "com.android.build.gradle.overridePathCheck";

    public static boolean getUseSdkDownload(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_USE_SDK_DOWNLOAD, true) && !AndroidGradleOptions.invokedFromIde(project);
    }

    public static Map<String, String> getExtraInstrumentationTestRunnerArgs(Project project) {
        HashMap argsMap = Maps.newHashMap();
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PROPERTY_TEST_RUNNER_ARGS)) continue;
            String argName = ((String)entry.getKey()).substring(PROPERTY_TEST_RUNNER_ARGS.length());
            String argValue = entry.getValue().toString();
            argsMap.put(argName, argValue);
        }
        return argsMap;
    }

    public static boolean getShardAndroidTestsBetweenDevices(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_SHARD_TESTS_BETWEEN_DEVICES, false);
    }

    public static Integer getInstrumentationShardCount(Project project) {
        return AndroidGradleOptions.getInteger(project, PROPERTY_SHARD_COUNT);
    }

    public static String getBenchmarkName(Project project) {
        return AndroidGradleOptions.getString(project, PROPERTY_BENCHMARK_NAME);
    }

    public static String getBenchmarkMode(Project project) {
        return AndroidGradleOptions.getString(project, PROPERTY_BENCHMARK_MODE);
    }

    public static boolean invokedFromIde(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.invoked.from.ide");
    }

    public static boolean buildModelOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only");
    }

    public static boolean refreshExternalNativeModel(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.refresh.external.native.model");
    }

    public static boolean buildModelOnlyAdvanced(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only.advanced");
    }

    public static boolean generateSourcesOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.generateSourcesOnly");
    }

    public static boolean useOldPackaging(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_USE_OLD_PACKAGING, false);
    }

    public static boolean keepTimestampsInApk(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_KEEP_TIMESTAMPS_IN_APK);
    }

    public static boolean isAapt2Enabled(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_ENABLE_AAPT2, false);
    }

    public static Integer buildModelOnlyVersion(Project project) {
        if (AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only.advanced")) {
            return 1;
        }
        if (AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only")) {
            return 0;
        }
        return null;
    }

    public static File getApkLocation(Project project) {
        String locString = AndroidGradleOptions.getString(project, "android.injected.apk.location");
        if (locString == null) {
            return null;
        }
        return project.file((Object)locString);
    }

    public static String getBuildTargetDensity(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.build.density");
    }

    public static String getBuildTargetAbi(Project project) {
        boolean enabled = AndroidGradleOptions.getBoolean(project, PROPERTY_BUILD_ONLY_TARGET_ABI);
        return enabled ? AndroidGradleOptions.getString(project, "android.injected.build.abi") : null;
    }

    public static int getTargetFeatureLevel(Project project) {
        String featureLevelString = AndroidGradleOptions.getString(project, "android.injected.build.api");
        if (featureLevelString == null) {
            return AndroidVersion.DEFAULT.getFeatureLevel();
        }
        try {
            return Integer.parseInt(featureLevelString);
        }
        catch (NumberFormatException ignore) {
            project.getLogger().warn("Wrong build target version passed ", (Throwable)ignore);
            return AndroidVersion.DEFAULT.getFeatureLevel();
        }
    }

    public static String getColdswapMode(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.coldswap.mode");
    }

    public static boolean useDeprecatedNdk(Project project) {
        return AndroidGradleOptions.getBoolean(project, USE_DEPRECATED_NDK);
    }

    public static Integer getThreadPoolSize(Project project) {
        Integer size = AndroidGradleOptions.getInteger(project, PROPERTY_THREAD_POOL_SIZE);
        if (size == null) {
            size = AndroidGradleOptions.getInteger(project, PROPERTY_THREAD_POOL_SIZE_OLD);
        }
        return size;
    }

    public static SigningOptions getSigningOptions(Project project) {
        String signingStoreFile = AndroidGradleOptions.getString(project, "android.injected.signing.store.file");
        String signingStorePassword = AndroidGradleOptions.getString(project, "android.injected.signing.store.password");
        String signingKeyAlias = AndroidGradleOptions.getString(project, "android.injected.signing.key.alias");
        String signingKeyPassword = AndroidGradleOptions.getString(project, "android.injected.signing.key.password");
        if (signingStoreFile != null && signingStorePassword != null && signingKeyAlias != null && signingKeyPassword != null) {
            String signingStoreType = AndroidGradleOptions.getString(project, "android.injected.signing.store.type");
            return new SigningOptions(signingStoreFile, signingStorePassword, signingKeyAlias, signingKeyPassword, signingStoreType);
        }
        return null;
    }

    public static EnumSet<OptionalCompilationStep> getOptionalCompilationSteps(Project project) {
        String values = AndroidGradleOptions.getString(project, "android.optional.compilation");
        if (values != null) {
            ArrayList<OptionalCompilationStep> optionalCompilationSteps = new ArrayList<OptionalCompilationStep>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                optionalCompilationSteps.add(OptionalCompilationStep.valueOf((String)st.nextToken()));
            }
            return EnumSet.copyOf(optionalCompilationSteps);
        }
        return EnumSet.noneOf(OptionalCompilationStep.class);
    }

    public static boolean isResourceValidationEnabled(Project project) {
        return !AndroidGradleOptions.getBoolean(project, PROPERTY_DISABLE_RESOURCE_VALIDATION);
    }

    public static Integer getVersionCodeOverride(Project project) {
        return AndroidGradleOptions.getInteger(project, "android.injected.version.code");
    }

    public static String getVersionNameOverride(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.version.name");
    }

    private static String getString(Project project, String propertyName) {
        return project.hasProperty(propertyName) ? (String)project.property(propertyName) : null;
    }

    private static Integer getInteger(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            try {
                return Integer.parseInt(project.property(propertyName).toString());
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Property " + propertyName + " needs to be an integer.");
            }
        }
        return null;
    }

    private static boolean getBoolean(Project project, String propertyName) {
        return AndroidGradleOptions.getBoolean(project, propertyName, false);
    }

    private static boolean getBoolean(Project project, String propertyName, boolean defaultValue) {
        if (project.hasProperty(propertyName)) {
            Object value = project.property(propertyName);
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
        }
        return defaultValue;
    }

    public static boolean isJavaCompileIncrementalPropertySet(Project project) {
        return project.hasProperty(PROPERTY_INCREMENTAL_JAVA_COMPILE);
    }

    public static String[] getAdditionalPlugins(Project project) {
        String string = AndroidGradleOptions.getString(project, ANDROID_ADDITIONAL_PLUGINS);
        return string == null ? new String[]{} : string.split(",");
    }

    public static String getRestrictVariantProject(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.restrict.variant.project");
    }

    public static String getRestrictVariantName(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.restrict.variant.name");
    }

    public static boolean isBuildCacheEnabled(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_ENABLE_BUILD_CACHE, false);
    }

    public static File getBuildCacheDir(Project project) {
        String buildCacheDir = AndroidGradleOptions.getString(project, PROPERTY_BUILD_CACHE_DIR);
        if (buildCacheDir != null) {
            return new File(buildCacheDir);
        }
        return new File(FileUtils.join((String[])new String[]{System.getProperty("user.home"), ".android", "build-cache"}));
    }

    public static FileCache getBuildCache(Project project) {
        return AndroidGradleOptions.isBuildCacheEnabled(project) ? FileCache.withInterProcessLocking((File)AndroidGradleOptions.getBuildCacheDir(project)) : FileCache.NO_CACHE;
    }

    public static boolean overrideGradleVersionCheck(Project project) {
        if (project.hasProperty(GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
        }
        return Boolean.getBoolean(OLD_GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
    }

    public static boolean overridePathCheck(Project project) {
        if (project.hasProperty(OVERRIDE_PATH_CHECK_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, OVERRIDE_PATH_CHECK_PROPERTY);
        }
        if (project.hasProperty(OLD_OVERRIDE_PATH_CHECK_PROPERTY)) {
            return AndroidGradleOptions.getBoolean(project, OLD_OVERRIDE_PATH_CHECK_PROPERTY);
        }
        return Boolean.getBoolean(OLD_OVERRIDE_PATH_CHECK_PROPERTY);
    }

    public static class SigningOptions {
        public final String storeFile;
        public final String storePassword;
        public final String keyAlias;
        public final String keyPassword;
        public final String storeType;

        SigningOptions(String storeFile, String storePassword, String keyAlias, String keyPassword, String storeType) {
            this.storeFile = storeFile;
            this.storeType = storeType;
            this.storePassword = storePassword;
            this.keyAlias = keyAlias;
            this.keyPassword = keyPassword;
        }
    }
}

