/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.LintGradleProject;
import com.android.build.gradle.tasks.Lint;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.sdklib.BuildToolInfo;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;

public class LintGradleClient
extends LintCliClient {
    private final AndroidProject mModelProject;
    private final Variant mVariant;
    private final Project mGradleProject;
    private List<File> mCustomRules = Lists.newArrayList();
    private File mSdkHome;
    private final BuildToolInfo mBuildToolInfo;

    public LintGradleClient(IssueRegistry registry, LintCliFlags flags, Project gradleProject, AndroidProject modelProject, File sdkHome, Variant variant, BuildToolInfo buildToolInfo) {
        super(flags, "gradle");
        this.mGradleProject = gradleProject;
        this.mModelProject = modelProject;
        this.mSdkHome = sdkHome;
        this.mRegistry = registry;
        this.mBuildToolInfo = buildToolInfo;
        this.mVariant = variant;
    }

    public void setCustomRules(List<File> customRules) {
        this.mCustomRules = customRules;
    }

    public List<File> findRuleJars(com.android.tools.lint.detector.api.Project project) {
        return this.mCustomRules;
    }

    protected com.android.tools.lint.detector.api.Project createProject(File dir, File referenceDir) {
        throw new IllegalStateException();
    }

    public File getSdkHome() {
        if (this.mSdkHome != null) {
            return this.mSdkHome;
        }
        return super.getSdkHome();
    }

    public File getCacheDir(boolean create) {
        File dir = new File(this.mGradleProject.getRootProject().getBuildDir(), "intermediates" + File.separator + "lint-cache");
        if (dir.exists() || create && dir.mkdirs()) {
            return dir;
        }
        return super.getCacheDir(create);
    }

    protected LintRequest createLintRequest(List<File> files) {
        LintRequest lintRequest = new LintRequest((LintClient)this, files);
        if (Lint.MODEL_LIBRARIES) {
            LintGradleProject.ProjectSearch search = new LintGradleProject.ProjectSearch();
            com.android.tools.lint.detector.api.Project project = search.getProject(this, this.mGradleProject, this.mVariant.getName());
            lintRequest.setProjects(Collections.singletonList(project));
            this.setCustomRules(search.customViewRuleJars);
        } else {
            Pair<LintGradleProject, List<File>> result = LintGradleProject.create(this, this.mModelProject, this.mVariant, this.mGradleProject);
            lintRequest.setProjects(Collections.singletonList(result.getFirst()));
            this.setCustomRules((List)result.getSecond());
        }
        return lintRequest;
    }

    public List<Warning> run(IssueRegistry registry) throws IOException {
        this.run(registry, Collections.emptyList());
        return this.mWarnings;
    }

    public static List<Warning> merge(Map<Variant, List<Warning>> warningMap, AndroidProject project) {
        if (warningMap.size() == 1) {
            return warningMap.values().iterator().next();
        }
        int maxCount = 0;
        for (List<Warning> warnings : warningMap.values()) {
            int size = warnings.size();
            maxCount = Math.max(size, maxCount);
        }
        if (maxCount == 0) {
            return Collections.emptyList();
        }
        int totalVariantCount = project.getVariants().size();
        ArrayList merged = Lists.newArrayListWithExpectedSize((int)(2 * maxCount));
        HashMap map = Maps.newHashMapWithExpectedSize((int)(2 * maxCount));
        for (Map.Entry<Variant, List<Warning>> entry : warningMap.entrySet()) {
            Variant variant = entry.getKey();
            List<Warning> warnings = entry.getValue();
            for (Warning warning : warnings) {
                String fileName;
                Warning canonical;
                Map fileMap;
                Map lineMap;
                Map messageMap = (Map)map.get(warning.issue);
                if (messageMap == null) {
                    messageMap = Maps.newHashMap();
                    map.put(warning.issue, messageMap);
                }
                if ((lineMap = (Map)messageMap.get(warning.message)) == null) {
                    lineMap = Maps.newHashMap();
                    messageMap.put(warning.message, lineMap);
                }
                if ((fileMap = (Map)lineMap.get(warning.line)) == null) {
                    fileMap = Maps.newHashMap();
                    lineMap.put(warning.line, fileMap);
                }
                if ((canonical = (Warning)fileMap.get(fileName = warning.file != null ? warning.file.getName() : "<unknown>")) == null) {
                    canonical = warning;
                    fileMap.put(fileName, canonical);
                    canonical.variants = Sets.newHashSet();
                    canonical.gradleProject = project;
                    merged.add(canonical);
                }
                canonical.variants.add(variant);
            }
        }
        for (Warning warning : merged) {
            if (warning.variants == null || warning.variants.size() != totalVariantCount) continue;
            warning.variants = null;
        }
        Collections.sort(merged);
        return merged;
    }

    protected void addProgressPrinter() {
    }

    public BuildToolInfo getBuildTools(com.android.tools.lint.detector.api.Project project) {
        return this.mBuildToolInfo;
    }

    public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format) {
        if (issue == IssueRegistry.LINT_ERROR && message.startsWith("No `.class` files were found in project")) {
            return;
        }
        super.report(context, issue, severity, location, message, format);
    }
}

