/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.LibraryRequest;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.sdk.DefaultSdkLoader;
import com.android.builder.sdk.PlatformLoader;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.repository.api.RepoManager;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public class SdkHandler {
    public static File sTestSdkFolder;
    private static final Object LOCK_FOR_SDK_HANDLER;
    private static SdkLoader sSdkLoader;
    private final ILogger logger;
    private SdkLoader sdkLoader;
    private File sdkFolder;
    private File ndkFolder;
    private SdkLibData sdkLibData = SdkLibData.dontDownload();
    private boolean isRegularSdk = true;
    private boolean resetCache = true;

    public static void setTestSdkFolder(File testSdkFolder) {
        sTestSdkFolder = testSdkFolder;
    }

    public static boolean useCachedSdk(Project project) {
        return AndroidGradleOptions.getOptionalCompilationSteps(project).contains(OptionalCompilationStep.INSTANT_DEV) && !AndroidGradleOptions.buildModelOnlyAdvanced(project);
    }

    public SdkHandler(Project project, ILogger logger) {
        this.logger = logger;
        this.findLocation(project);
    }

    public SdkInfo getSdkInfo() {
        SdkLoader sdkLoader = this.getSdkLoader();
        return sdkLoader.getSdkInfo(this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTarget(String targetHash, Revision buildToolRevision, Collection<LibraryRequest> usedLibraries, AndroidBuilder androidBuilder, boolean useCachedVersion) {
        Preconditions.checkNotNull((Object)targetHash, (Object)"android.compileSdkVersion is missing!");
        Preconditions.checkNotNull((Object)buildToolRevision, (Object)"android.buildToolsVersion is missing!");
        Object object = LOCK_FOR_SDK_HANDLER;
        synchronized (object) {
            if (useCachedVersion) {
                if (sSdkLoader == null) {
                    this.logger.info("Parsing the Sdk", new Object[0]);
                    sSdkLoader = this.getSdkLoader();
                } else {
                    this.logger.info("Reusing the SdkLoader", new Object[0]);
                }
            } else {
                this.logger.info("Parsing the SDK, no caching allowed", new Object[0]);
                sSdkLoader = this.getSdkLoader();
            }
            this.sdkLoader = sSdkLoader;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        SdkInfo sdkInfo = this.sdkLoader.getSdkInfo(this.logger);
        if (this.resetCache) {
            this.sdkLibData.setCacheExpirationPeriod(0L);
            this.resetCache = false;
        } else {
            this.sdkLibData.setCacheExpirationPeriod(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS);
        }
        TargetInfo targetInfo = this.sdkLoader.getTargetInfo(targetHash, buildToolRevision, this.logger, this.sdkLibData);
        androidBuilder.setSdkInfo(sdkInfo);
        androidBuilder.setTargetInfo(targetInfo);
        androidBuilder.setLibraryRequests(usedLibraries);
        this.logger.verbose("SDK initialized in %1$d ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
    }

    public File getSdkFolder() {
        return this.sdkFolder;
    }

    public File getAndCheckSdkFolder() {
        if (this.sdkFolder == null) {
            throw new RuntimeException("SDK location not found. Define location with sdk.dir in the local.properties file or with an ANDROID_HOME environment variable.");
        }
        return this.sdkFolder;
    }

    public synchronized SdkLoader getSdkLoader() {
        if (this.sdkLoader == null) {
            if (this.isRegularSdk) {
                this.getAndCheckSdkFolder();
                if (sTestSdkFolder == null && !this.sdkFolder.isDirectory()) {
                    throw new RuntimeException(String.format("The SDK directory '%1$s' does not exist.", this.sdkFolder));
                }
                this.sdkLoader = DefaultSdkLoader.getLoader((File)this.sdkFolder);
            } else {
                this.sdkLoader = PlatformLoader.getLoader((File)this.sdkFolder);
            }
        }
        return this.sdkLoader;
    }

    public synchronized void unload() {
        if (this.sdkLoader != null) {
            if (this.isRegularSdk) {
                DefaultSdkLoader.unload();
            } else {
                PlatformLoader.unload();
            }
            this.sdkLoader = null;
        }
    }

    public File getNdkFolder() {
        return this.ndkFolder;
    }

    private void findSdkLocation(Properties properties, File rootDir) {
        String sdkDirProp = properties.getProperty("sdk.dir");
        if (sdkDirProp != null) {
            this.sdkFolder = new File(sdkDirProp);
            if (!this.sdkFolder.isAbsolute()) {
                this.sdkFolder = new File(rootDir, sdkDirProp);
            }
            return;
        }
        sdkDirProp = properties.getProperty("android.dir");
        if (sdkDirProp != null) {
            this.sdkFolder = new File(rootDir, sdkDirProp);
            this.isRegularSdk = false;
            return;
        }
        String envVar = System.getenv("ANDROID_HOME");
        if (envVar != null) {
            this.sdkFolder = new File(envVar);
            return;
        }
        String property = System.getProperty("android.home");
        if (property != null) {
            this.sdkFolder = new File(property);
        }
    }

    private void findNdkLocation(Properties properties) {
        String ndkDirProp = properties.getProperty("ndk.dir");
        if (ndkDirProp != null) {
            this.ndkFolder = new File(ndkDirProp);
            return;
        }
        String envVar = System.getenv("ANDROID_NDK_HOME");
        if (envVar != null) {
            this.ndkFolder = new File(envVar);
        }
    }

    /*
     * Loose catch block
     */
    private void findLocation(Project project) {
        Properties properties;
        File rootDir;
        block14: {
            if (sTestSdkFolder != null) {
                this.sdkFolder = sTestSdkFolder;
                return;
            }
            rootDir = project.getRootDir();
            File localProperties = new File(rootDir, "local.properties");
            properties = new Properties();
            if (localProperties.isFile()) {
                InputStreamReader reader = null;
                FileInputStream fis2232322322 = new FileInputStream(localProperties);
                reader = new InputStreamReader((InputStream)fis2232322322, Charsets.UTF_8);
                properties.load(reader);
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException fis2232322322) {}
                break block14;
                catch (FileNotFoundException fis2232322322) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException fis2232322322) {}
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Unable to read %1$s.", localProperties.getAbsolutePath()), e);
                    {
                        catch (Throwable throwable) {
                            try {
                                Closeables.close(reader, (boolean)true);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        this.findSdkLocation(properties, rootDir);
        this.findNdkLocation(properties);
    }

    public void setSdkLibData(SdkLibData sdkLibData) {
        this.sdkLibData = sdkLibData;
    }

    public boolean shouldResetCache() {
        return this.resetCache;
    }

    public void setResetCache(boolean resetCache) {
        this.resetCache = resetCache;
    }

    public void addLocalRepositories(Project project) {
        for (File repository : this.getSdkLoader().getRepositories()) {
            MavenArtifactRepository mavenRepository = project.getRepositories().maven(newRepository -> {
                newRepository.setName(repository.getPath());
                newRepository.setUrl((Object)repository);
            });
            project.getRepositories().remove((Object)mavenRepository);
            project.getRepositories().addFirst((ArtifactRepository)mavenRepository);
        }
    }

    static {
        LOCK_FOR_SDK_HANDLER = new Object();
    }
}

