/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.OutputFile;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.VariantDimensionData;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreJackOptions;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.InstantRunAnchorTaskConfigAction;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunWrapperTask;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.ApkPublishArtifact;
import com.android.build.gradle.internal.publishing.ManifestPublishArtifact;
import com.android.build.gradle.internal.publishing.MappingPublishArtifact;
import com.android.build.gradle.internal.publishing.MetadataPublishArtifact;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.DefaultGradlePackagingScope;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.SupplierTask;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ExtractProguardFiles;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.InstallVariantTask;
import com.android.build.gradle.internal.tasks.JackJacocoReportTask;
import com.android.build.gradle.internal.tasks.LintCompile;
import com.android.build.gradle.internal.tasks.MockableAndroidJarTask;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.SourceSetsTask;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.UninstallTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingProcessLayoutsTask;
import com.android.build.gradle.internal.tasks.multidex.CreateManifestKeepList;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.transforms.ExtractJarsTransform;
import com.android.build.gradle.internal.transforms.JackTransform;
import com.android.build.gradle.internal.transforms.JacocoTransform;
import com.android.build.gradle.internal.transforms.JarMergingTransform;
import com.android.build.gradle.internal.transforms.MergeJavaResourcesTransform;
import com.android.build.gradle.internal.transforms.MultiDexTransform;
import com.android.build.gradle.internal.transforms.NewShrinkerTransform;
import com.android.build.gradle.internal.transforms.ProGuardTransform;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.build.gradle.internal.transforms.ShrinkResourcesTransform;
import com.android.build.gradle.internal.transforms.StripDebugSymbolTransform;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.ExternalNativeBuildJsonTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeCleanTask;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.GenerateSplitAbiRes;
import com.android.build.gradle.tasks.JackPreDexTransform;
import com.android.build.gradle.tasks.Lint;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.build.gradle.tasks.SplitZipAlign;
import com.android.build.gradle.tasks.ZipAlign;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.android.build.gradle.tasks.factory.IncrementalSafeguard;
import com.android.build.gradle.tasks.factory.JacocoAgentConfigAction;
import com.android.build.gradle.tasks.factory.JavaCompileConfigAction;
import com.android.build.gradle.tasks.factory.PackageJarArtifactConfigAction;
import com.android.build.gradle.tasks.factory.ProcessJavaResConfigAction;
import com.android.build.gradle.tasks.factory.TestServerTaskConfigAction;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.DexOptions;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.model.DataBindingOptions;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.manifmerger.ManifestMerger2;
import com.android.repository.Revision;
import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class TaskManager {
    public static final String DEFAULT_PROGUARD_CONFIG_FILE = "proguard-android.txt";
    public static final String DIR_BUNDLES = "bundles";
    public static final String INSTALL_GROUP = "Install";
    public static final String BUILD_GROUP = "build";
    public static final String ANDROID_GROUP = "Android";
    protected Project project;
    protected AndroidBuilder androidBuilder;
    protected DataBindingBuilder dataBindingBuilder;
    private DependencyManager dependencyManager;
    protected SdkHandler sdkHandler;
    protected AndroidConfig extension;
    protected ToolingModelBuilderRegistry toolingRegistry;
    private final GlobalScope globalScope;
    private final AndroidTaskRegistry androidTasks = new AndroidTaskRegistry();
    private Logger logger;
    protected boolean isComponentModelPlugin = false;
    private static final String MAIN_PREBUILD = "preBuild";
    private static final String UNINSTALL_ALL = "uninstallAll";
    private static final String DEVICE_CHECK = "deviceCheck";
    private static final String DEVICE_ANDROID_TEST = "device" + VariantType.ANDROID_TEST.getSuffix();
    protected static final String CONNECTED_CHECK = "connectedCheck";
    private static final String CONNECTED_ANDROID_TEST = "connected" + VariantType.ANDROID_TEST.getSuffix();
    private static final String ASSEMBLE_ANDROID_TEST = "assembleAndroidTest";
    private static final String SOURCE_SETS = "sourceSets";
    public static final String LINT = "lint";
    protected static final String LINT_COMPILE = "compileLint";
    private static final String EXTRACT_PROGUARD_FILES = "extractProguardFiles";
    private static final Revision MIN_REVISION_RS_COMPAT_64 = Revision.parseRevision((String)"23.0.3");
    private AndroidTask<Copy> jacocoAgentTask;
    public AndroidTask<MockableAndroidJarTask> createMockableJar;

    public TaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        this.project = project;
        this.androidBuilder = androidBuilder;
        this.dataBindingBuilder = dataBindingBuilder;
        this.sdkHandler = sdkHandler;
        this.extension = extension;
        this.toolingRegistry = toolingRegistry;
        this.dependencyManager = dependencyManager;
        this.logger = Logging.getLogger(this.getClass());
        this.globalScope = new GlobalScope(project, androidBuilder, extension, sdkHandler, ndkHandler, toolingRegistry);
    }

    private boolean isDebugLog() {
        return this.project.getLogger().isEnabled(LogLevel.DEBUG);
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public abstract void createTasksForVariantData(TaskFactory var1, BaseVariantData<? extends BaseVariantOutputData> var2);

    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    protected Collection<Object> getNdkBuildable(BaseVariantData variantData) {
        if (variantData.ndkCompileTask == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(variantData.ndkCompileTask);
    }

    public void configureScopeForNdk(VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setNdkSoFolder(Collections.singleton(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/lib")));
        File objFolder = new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj");
        scope.setNdkObjFolder(objFolder);
        for (Abi abi : NdkHandler.getAbiList()) {
            scope.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getName()));
        }
    }

    protected AndroidConfig getExtension() {
        return this.extension;
    }

    public void resolveDependencies(VariantDependencies variantDeps, VariantDependencies testedVariantDeps, String testedProjectPath) {
        this.dependencyManager.resolveDependencies(variantDeps, testedVariantDeps, testedProjectPath);
    }

    public void createTasksBeforeEvaluate(TaskFactory tasks) {
        this.androidTasks.create(tasks, UNINSTALL_ALL, (Action<Task>)((Action)uninstallAllTask -> {
            uninstallAllTask.setDescription("Uninstall all applications.");
            uninstallAllTask.setGroup(INSTALL_GROUP);
        }));
        this.androidTasks.create(tasks, DEVICE_CHECK, (Action<Task>)((Action)deviceCheckTask -> {
            deviceCheckTask.setDescription("Runs all device checks using Device Providers and Test Servers.");
            deviceCheckTask.setGroup("verification");
        }));
        this.androidTasks.create(tasks, CONNECTED_CHECK, (Action<Task>)((Action)connectedCheckTask -> {
            connectedCheckTask.setDescription("Runs all device checks on currently connected devices.");
            connectedCheckTask.setGroup("verification");
        }));
        this.androidTasks.create(tasks, MAIN_PREBUILD, (Action<Task>)((Action)task -> {}));
        AndroidTask<ExtractProguardFiles> extractProguardFiles = this.androidTasks.create(tasks, EXTRACT_PROGUARD_FILES, ExtractProguardFiles.class, task -> {});
        extractProguardFiles.dependsOn(tasks, MAIN_PREBUILD);
        this.androidTasks.create(tasks, new SourceSetsTask.ConfigAction(this.extension));
        this.androidTasks.create(tasks, ASSEMBLE_ANDROID_TEST, (Action<Task>)((Action)assembleAndroidTestTask -> {
            assembleAndroidTestTask.setGroup(BUILD_GROUP);
            assembleAndroidTestTask.setDescription("Assembles all the Test applications.");
        }));
        AndroidTask<Lint> globalLintTask = this.androidTasks.create(tasks, new Lint.GlobalConfigAction(this.globalScope));
        tasks.named("check", (Action<? super Task>)((Action)it -> it.dependsOn(new Object[]{LINT})));
        this.androidTasks.create(tasks, new LintCompile.ConfigAction(this.globalScope));
    }

    public void createMockableJarTask(TaskFactory tasks) {
        this.createMockableJar = this.androidTasks.create(tasks, new MockableAndroidJarTask.ConfigAction(this.globalScope));
    }

    protected void createDependencyStreams(TaskFactory tasks, VariantScope variantScope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = variantScope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        TransformManager transformManager = variantScope.getTransformManager();
        ImmutableSet fullJar = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES, (Object)QualifiedContent.DefaultContentType.RESOURCES, (Object)((Object)ExtendedContentType.NATIVE_LIBS));
        transformManager.addStream(OriginalStream.builder().addContentTypes((Set<QualifiedContent.ContentType>)fullJar).addScope(QualifiedContent.Scope.PROJECT_LOCAL_DEPS).setJars((Supplier<Collection<File>>)((Supplier)() -> ((GradleVariantConfiguration)config).getLocalPackagedJars())).build());
        IncrementalMode incrementalMode = this.getIncrementalMode(config);
        boolean skipDependency = incrementalMode == IncrementalMode.LOCAL_JAVA_ONLY || incrementalMode == IncrementalMode.LOCAL_RES_ONLY;
        ImmutableList dependencies = skipDependency ? ImmutableList.of() : ImmutableList.of((Object)variantScope.getPrepareDependenciesTask().getName(), (Object)variantData.getVariantDependency().getPackageConfiguration().getBuildDependencies());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_JARS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJars((Supplier<Collection<File>>)((Supplier)() -> Stream.concat(config.getExternalPackagedJars().stream(), variantScope.getGlobalScope().getAndroidBuilder().getAdditionalPackagedJars((VariantConfiguration)config).stream()).collect(Collectors.toSet()))).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJars((Supplier<Collection<File>>)((Supplier)() -> Stream.concat(config.getExternalPackagedJniJars().stream(), variantScope.getGlobalScope().getAndroidBuilder().getAdditionalPackagedJars((VariantConfiguration)config).stream()).collect(Collectors.toSet()))).setFolders((Supplier<Collection<File>>)((Supplier)() -> ((GradleVariantConfiguration)config).getExternalAarJniLibFolders())).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_JARS).addScope(QualifiedContent.Scope.SUB_PROJECTS).setJars((Supplier<Collection<File>>)((Supplier)() -> ((GradleVariantConfiguration)config).getSubProjectPackagedJars())).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_CLASS).addScope(QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS).setJars((Supplier<Collection<File>>)((Supplier)() -> ((GradleVariantConfiguration)config).getSubProjectLocalPackagedJars())).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope(QualifiedContent.Scope.SUB_PROJECTS).setFolders((Supplier<Collection<File>>)((Supplier)() -> ((GradleVariantConfiguration)config).getSubProjectJniLibFolders())).setJars((Supplier<Collection<File>>)((Supplier)() -> ((GradleVariantConfiguration)config).getSubProjectPackagedJniJars())).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes((Set<QualifiedContent.ContentType>)fullJar).addScope(QualifiedContent.Scope.PROVIDED_ONLY).setJars((Supplier<Collection<File>>)((Supplier)() -> ((GradleVariantConfiguration)config).getProvidedOnlyJars())).build());
        if (variantScope.getTestedVariantData() != null) {
            BaseVariantData testedVariantData = variantScope.getTestedVariantData();
            VariantScope testedVariantScope = testedVariantData.getScope();
            transformManager.addStream(OriginalStream.builder().addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope(QualifiedContent.Scope.TESTED_CODE).setFolders((Supplier<Collection<File>>)Suppliers.ofInstance((Object)ImmutableList.of((Object)testedVariantScope.getJavaOutputDir()))).setDependency(testedVariantScope.getJavacTask().getName()).build());
            transformManager.addStream(OriginalStream.builder().addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope(QualifiedContent.Scope.TESTED_CODE).setJars((Supplier<Collection<File>>)((Supplier)() -> variantScope.getGlobalScope().getAndroidBuilder().getAllPackagedJars((VariantConfiguration)testedVariantData.getVariantConfiguration()))).setDependency(ImmutableList.of((Object)testedVariantScope.getPrepareDependenciesTask().getName(), (Object)testedVariantData.getVariantDependency().getPackageConfiguration().getBuildDependencies())).build());
        }
        this.handleJacocoDependencies(tasks, variantScope);
    }

    public void createMergeAppManifestsTask(TaskFactory tasks, VariantScope variantScope) {
        ApplicationVariantData appVariantData = (ApplicationVariantData)variantScope.getVariantData();
        Set<String> screenSizes = appVariantData.getCompatibleScreens();
        for (BaseVariantOutputData vod : appVariantData.getOutputs()) {
            VariantOutputScope scope = vod.getScope();
            AndroidTask<CompatibleScreensManifest> csmTask = null;
            if (vod.getMainOutputFile().getFilter(OutputFile.DENSITY) != null) {
                csmTask = this.androidTasks.create(tasks, new CompatibleScreensManifest.ConfigAction(scope, screenSizes));
                scope.setCompatibleScreensManifestTask(csmTask);
            }
            ImmutableList optionalFeatures = this.getIncrementalMode(variantScope.getVariantConfiguration()) != IncrementalMode.NONE ? ImmutableList.of((Object)ManifestMerger2.Invoker.Feature.INSTANT_RUN_REPLACEMENT) : ImmutableList.of();
            AndroidTask<? extends ManifestProcessorTask> processManifestTask = this.androidTasks.create(tasks, this.getMergeManifestConfig(scope, (List<ManifestMerger2.Invoker.Feature>)optionalFeatures));
            scope.setManifestProcessorTask(processManifestTask);
            processManifestTask.dependsOn(tasks, variantScope.getPrepareDependenciesTask());
            if (variantScope.getMicroApkTask() != null) {
                processManifestTask.dependsOn(tasks, variantScope.getMicroApkTask());
            }
            if (csmTask != null) {
                processManifestTask.dependsOn(tasks, csmTask);
            }
            this.addManifestArtifact(tasks, scope.getVariantScope().getVariantData());
        }
    }

    protected TaskConfigAction<? extends ManifestProcessorTask> getMergeManifestConfig(VariantOutputScope scope, List<ManifestMerger2.Invoker.Feature> optionalFeatures) {
        return new MergeManifests.ConfigAction(scope, optionalFeatures);
    }

    private void addManifestArtifact(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        if (variantData.getVariantDependency().getManifestConfiguration() != null) {
            final ManifestProcessorTask mergeManifestsTask = variantData.getOutputs().get(0).getScope().getManifestProcessorTask().get(tasks);
            this.project.getArtifacts().add(variantData.getVariantDependency().getManifestConfiguration().getName(), (Object)new ManifestPublishArtifact(this.globalScope.getProjectBaseName(), new FileSupplier(){

                @Override
                public Task getTask() {
                    return mergeManifestsTask;
                }

                public File get() {
                    return mergeManifestsTask.getManifestOutputFile();
                }
            }));
        }
    }

    public void createMergeLibManifestsTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<ProcessManifest> processManifest = this.androidTasks.create(tasks, new ProcessManifest.ConfigAction(scope));
        processManifest.dependsOn(tasks, scope.getPrepareDependenciesTask());
        BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
        variantOutputData.getScope().setManifestProcessorTask(processManifest);
    }

    protected void createProcessTestManifestTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<ProcessTestManifest> processTestManifestTask = this.androidTasks.create(tasks, new ProcessTestManifest.ConfigAction(scope));
        processTestManifestTask.dependsOn(tasks, scope.getPrepareDependenciesTask());
        BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
        variantOutputData.getScope().setManifestProcessorTask(processTestManifestTask);
    }

    public void createRenderscriptTask(TaskFactory tasks, VariantScope scope) {
        Revision rev;
        scope.setRenderscriptCompileTask(this.androidTasks.create(tasks, new RenderscriptCompile.ConfigAction(scope)));
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        if (config.getRenderscriptSupportModeEnabled() && config.getRenderscriptTarget() >= 21 && (rev = this.androidBuilder.getTargetInfo().getBuildTools().getRevision()).compareTo(MIN_REVISION_RS_COMPAT_64) < 0) {
            this.androidBuilder.getErrorReporter().handleSyncError(rev.toString(), 13, "Renderscript support mode is not supported with renderscript target 21+ in BuildTools " + rev.toString() + '\n' + "Please update to BuildTools " + MIN_REVISION_RS_COMPAT_64.toString() + " or above.");
        }
        BaseVariantOutputData variantOutputData = variantData.getOutputs().get(0);
        scope.getRenderscriptCompileTask().dependsOn(tasks, scope.getPrepareDependenciesTask());
        if (config.getType().isForTesting()) {
            scope.getRenderscriptCompileTask().dependsOn(tasks, variantOutputData.getScope().getManifestProcessorTask());
        } else {
            scope.getRenderscriptCompileTask().dependsOn(tasks, scope.getCheckManifestTask());
        }
        scope.getResourceGenTask().dependsOn(tasks, scope.getRenderscriptCompileTask());
        if (!config.getRenderscriptNdkModeEnabled()) {
            scope.getSourceGenTask().dependsOn(tasks, scope.getRenderscriptCompileTask());
        }
    }

    public AndroidTask<MergeResources> createMergeResourcesTask(TaskFactory tasks, VariantScope scope) {
        return this.createMergeResourcesTask(tasks, scope, true);
    }

    public AndroidTask<MergeResources> createMergeResourcesTask(TaskFactory tasks, VariantScope scope, boolean process9patch) {
        return this.basicCreateMergeResourcesTask(tasks, scope, "merge", null, true, process9patch);
    }

    public AndroidTask<MergeResources> basicCreateMergeResourcesTask(TaskFactory tasks, VariantScope scope, String taskNamePrefix, File outputLocation, boolean includeDependencies, boolean process9Patch) {
        AndroidTask<MergeResources> mergeResourcesTask = this.androidTasks.create(tasks, new MergeResources.ConfigAction(scope, taskNamePrefix, outputLocation, includeDependencies, process9Patch));
        if (this.getIncrementalMode(scope.getVariantConfiguration()) != IncrementalMode.LOCAL_RES_ONLY) {
            mergeResourcesTask.dependsOn(tasks, scope.getPrepareDependenciesTask(), scope.getResourceGenTask());
        }
        scope.setMergeResourcesTask(mergeResourcesTask);
        scope.setResourceOutputDir((File)Objects.firstNonNull((Object)outputLocation, (Object)scope.getDefaultMergeResourcesOutputDir()));
        scope.setMergeResourceOutputDir(outputLocation);
        return scope.getMergeResourcesTask();
    }

    public void createMergeAssetsTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<MergeSourceSetFolders> mergeAssetsTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeAssetConfigAction(scope));
        mergeAssetsTask.dependsOn(tasks, scope.getPrepareDependenciesTask().getName(), scope.getAssetGenTask());
        scope.setMergeAssetsTask(mergeAssetsTask);
    }

    public void createMergeJniLibFoldersTasks(TaskFactory tasks, VariantScope variantScope) {
        AndroidTask<MergeSourceSetFolders> mergeJniLibFoldersTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeJniLibFoldersConfigAction(variantScope));
        mergeJniLibFoldersTask.dependsOn(tasks, variantScope.getPrepareDependenciesTask().getName(), variantScope.getAssetGenTask());
        variantScope.setMergeJniLibFoldersTask(mergeJniLibFoldersTask);
        variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType(ExtendedContentType.NATIVE_LIBS).addScope(QualifiedContent.Scope.PROJECT).setFolder(variantScope.getMergeNativeLibsOutputDir()).setDependency(mergeJniLibFoldersTask.getName()).build());
        variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType(ExtendedContentType.NATIVE_LIBS).addScope(QualifiedContent.Scope.PROJECT).setFolders((Supplier<Collection<File>>)Suppliers.ofInstance(variantScope.getNdkSoFolder())).setDependency(this.getNdkBuildable(variantScope.getVariantData())).build());
        if (variantScope.getExternalNativeJsonGenerator() != null) {
            variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType(ExtendedContentType.NATIVE_LIBS).addScope(QualifiedContent.Scope.PROJECT).setFolder(variantScope.getExternalNativeJsonGenerator().getObjFolder()).setDependency(variantScope.getExternalNativeBuildTask().getName()).build());
        }
        if (variantScope.getVariantConfiguration().getRenderscriptSupportModeEnabled()) {
            variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType(ExtendedContentType.NATIVE_LIBS).addScope(QualifiedContent.Scope.PROJECT).setFolders((Supplier<Collection<File>>)((Supplier)() -> {
                File rsLibs;
                ImmutableList.Builder builder = ImmutableList.builder();
                if (variantScope.getRenderscriptLibOutputDir().isDirectory()) {
                    builder.add((Object)variantScope.getRenderscriptLibOutputDir());
                }
                if ((rsLibs = variantScope.getGlobalScope().getAndroidBuilder().getSupportNativeLibFolder()) != null && rsLibs.isDirectory()) {
                    builder.add((Object)rsLibs);
                }
                if (variantScope.getVariantConfiguration().getRenderscriptSupportModeBlasEnabled()) {
                    File rsBlasLib = variantScope.getGlobalScope().getAndroidBuilder().getSupportBlasLibFolder();
                    if (rsBlasLib != null && rsBlasLib.isDirectory()) {
                        builder.add((Object)rsBlasLib);
                    } else {
                        Revision rev = this.androidBuilder.getTargetInfo().getBuildTools().getRevision();
                        this.androidBuilder.getErrorReporter().handleSyncError(rev.toString(), 13, "Renderscript BLAS support mode is not supported in BuildTools " + rev.toString() + '\n' + "Please update to BuildTools 24.0.0" + " or above.");
                    }
                }
                return builder.build();
            })).setDependency(variantScope.getRenderscriptCompileTask().getName()).build());
        }
        Set<QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, ExtendedContentType.NATIVE_LIBS, "mergeJniLibs");
        variantScope.getTransformManager().addTransform(tasks, variantScope, mergeTransform);
    }

    public void createBuildConfigTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<GenerateBuildConfig> generateBuildConfigTask = this.androidTasks.create(tasks, new GenerateBuildConfig.ConfigAction(scope));
        scope.setGenerateBuildConfigTask(generateBuildConfigTask);
        scope.getSourceGenTask().dependsOn(tasks, generateBuildConfigTask.getName());
        if (scope.getVariantConfiguration().getType().isForTesting()) {
            BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
            generateBuildConfigTask.dependsOn(tasks, variantOutputData.getScope().getManifestProcessorTask());
        } else {
            generateBuildConfigTask.dependsOn(tasks, scope.getCheckManifestTask());
        }
    }

    public void createGenerateResValuesTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<GenerateResValues> generateResValuesTask = this.androidTasks.create(tasks, new GenerateResValues.ConfigAction(scope));
        scope.getResourceGenTask().dependsOn(tasks, generateResValuesTask);
    }

    public void createApkProcessResTask(TaskFactory tasks, VariantScope scope) {
        this.createProcessResTask(tasks, scope, new File(this.globalScope.getIntermediatesDir(), "symbols/" + scope.getVariantData().getVariantConfiguration().getDirName()), true);
    }

    public void createProcessResTask(TaskFactory tasks, VariantScope scope, File symbolLocation, boolean generateResourcePackage) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        variantData.calculateFilters(scope.getGlobalScope().getExtension().getSplits());
        boolean useAaptToGenerateLegacyMultidexMainDexProguardRules = this.useAaptToGenerateLegacyMultidexMainDexProguardRules(scope);
        for (BaseVariantOutputData baseVariantOutputData : variantData.getOutputs()) {
            VariantOutputScope variantOutputScope = baseVariantOutputData.getScope();
            variantOutputScope.setProcessResourcesTask(this.androidTasks.create(tasks, new ProcessAndroidResources.ConfigAction(variantOutputScope, symbolLocation, generateResourcePackage, useAaptToGenerateLegacyMultidexMainDexProguardRules)));
            variantOutputScope.getProcessResourcesTask().dependsOn(tasks, scope.getMergeResourcesTask());
            if (scope.getDataBindingProcessLayoutsTask() != null) {
                variantOutputScope.getProcessResourcesTask().dependsOn(tasks, scope.getDataBindingProcessLayoutsTask().getName());
            }
            if (this.getIncrementalMode(scope.getVariantConfiguration()) != IncrementalMode.LOCAL_RES_ONLY) {
                variantOutputScope.getProcessResourcesTask().dependsOn(tasks, variantOutputScope.getManifestProcessorTask());
            }
            if (baseVariantOutputData.getMainOutputFile().getFilter(OutputFile.DENSITY) != null) continue;
            scope.setGenerateRClassTask(variantOutputScope.getProcessResourcesTask());
            scope.getSourceGenTask().optionalDependsOn(tasks, variantOutputScope.getProcessResourcesTask());
        }
    }

    private boolean useAaptToGenerateLegacyMultidexMainDexProguardRules(VariantScope scope) {
        return this.isLegacyMultidexMode(scope) && this.androidBuilder.getTargetInfo().getBuildTools().getRevision().compareTo(Aapt.VERSION_FOR_MAIN_DEX_LIST) >= 0;
    }

    public AndroidTask<PackageSplitRes> createSplitResourcesTasks(TaskFactory tasks, VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getSplitHandlingPolicy().equals((Object)SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY), (Object)"Can only create split resources tasks for pure splits.");
        List<? extends BaseVariantOutputData> outputs = variantData.getOutputs();
        BaseVariantOutputData variantOutputData = outputs.get(0);
        if (outputs.size() != 1) {
            throw new RuntimeException("In release 21 and later, there can be only one main APK, found " + outputs.size());
        }
        VariantOutputScope variantOutputScope = variantOutputData.getScope();
        AndroidTask<PackageSplitRes> packageSplitRes = this.androidTasks.create(tasks, new PackageSplitRes.ConfigAction(scope));
        packageSplitRes.dependsOn(tasks, variantOutputScope.getProcessResourcesTask().getName());
        return packageSplitRes;
    }

    public AndroidTask<PackageSplitAbi> createSplitAbiTasks(TaskFactory tasks, VariantScope scope) {
        ApplicationVariantData variantData = (ApplicationVariantData)scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getSplitHandlingPolicy().equals((Object)SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY), (Object)"split ABI tasks are only compatible with pure splits.");
        ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.getExtension().getSplits().getAbiFilters());
        if (filters.isEmpty()) {
            return null;
        }
        List outputs = variantData.getOutputs();
        if (outputs.size() != 1) {
            throw new RuntimeException("In release 21 and later, there can be only one main APK, found " + outputs.size());
        }
        BaseVariantOutputData variantOutputData = (BaseVariantOutputData)outputs.get(0);
        AndroidTask<GenerateSplitAbiRes> generateSplitAbiRes = this.androidTasks.create(tasks, new GenerateSplitAbiRes.ConfigAction(scope));
        generateSplitAbiRes.dependsOn(tasks, variantOutputData.getScope().getProcessResourcesTask().getName());
        AndroidTask<PackageSplitAbi> packageSplitAbiTask = this.androidTasks.create(tasks, new PackageSplitAbi.ConfigAction(scope));
        packageSplitAbiTask.dependsOn(tasks, generateSplitAbiRes);
        packageSplitAbiTask.dependsOn(tasks, scope.getNdkBuildable());
        if (scope.getExternalNativeBuildTask() != null) {
            packageSplitAbiTask.dependsOn(tasks, scope.getExternalNativeBuildTask());
        }
        for (TransformStream stream : scope.getTransformManager().getStreams(StreamFilter.NATIVE_LIBS)) {
            packageSplitAbiTask.dependsOn(tasks, stream.getDependencies());
        }
        return packageSplitAbiTask;
    }

    public void createSplitTasks(TaskFactory tasks, VariantScope scope) {
        AndroidTask<PackageSplitRes> packageSplitResourcesTask = this.createSplitResourcesTasks(tasks, scope);
        AndroidTask<PackageSplitAbi> packageSplitAbiTask = this.createSplitAbiTasks(tasks, scope);
        AndroidTask<SplitZipAlign> zipAlign = this.androidTasks.create(tasks, new SplitZipAlign.ConfigAction(scope));
        if (packageSplitAbiTask != null) {
            zipAlign.configure(tasks, (Action<SplitZipAlign>)((Action)task -> task.getAbiInputFiles().addAll(scope.getPackageSplitAbiOutputFiles())));
        }
        zipAlign.dependsOn(tasks, packageSplitResourcesTask);
        zipAlign.optionalDependsOn(tasks, packageSplitAbiTask);
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        VariantOutputScope outputScope = variantData.getOutputs().get(0).getScope();
        outputScope.setSplitZipAlignTask(zipAlign);
    }

    protected abstract Set<QualifiedContent.Scope> getResMergingScopes(VariantScope var1);

    public void createProcessJavaResTasks(TaskFactory tasks, VariantScope variantScope) {
        TransformManager transformManager = variantScope.getTransformManager();
        AndroidTask<Sync> processJavaResourcesTask = this.androidTasks.create(tasks, new ProcessJavaResConfigAction(variantScope));
        variantScope.setProcessJavaResourcesTask(processJavaResourcesTask);
        variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope(QualifiedContent.Scope.PROJECT).setFolder(variantScope.getSourceFoldersJavaResDestinationDir()).setDependency(processJavaResourcesTask.getName()).build());
        Set<QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES, "mergeJavaRes");
        variantScope.setMergeJavaResourcesTask(transformManager.addTransform(tasks, variantScope, mergeTransform));
    }

    public void createAidlTask(TaskFactory tasks, VariantScope scope) {
        scope.setAidlCompileTask(this.androidTasks.create(tasks, new AidlCompile.ConfigAction(scope)));
        scope.getSourceGenTask().dependsOn(tasks, scope.getAidlCompileTask());
        scope.getAidlCompileTask().dependsOn(tasks, scope.getPrepareDependenciesTask());
    }

    public void createShaderTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<MergeSourceSetFolders> mergeShadersTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeShaderSourceFoldersConfigAction(scope));
        AndroidTask<ShaderCompile> shaderCompileTask = this.androidTasks.create(tasks, new ShaderCompile.ConfigAction(scope));
        scope.setShaderCompileTask(shaderCompileTask);
        shaderCompileTask.dependsOn(tasks, mergeShadersTask);
        scope.getAssetGenTask().dependsOn(tasks, shaderCompileTask);
    }

    public AndroidTask<? extends JavaCompile> createJavacTask(TaskFactory tasks, VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        AndroidTask<IncrementalSafeguard> javacIncrementalSafeguard = this.androidTasks.create(tasks, new IncrementalSafeguard.ConfigAction(scope));
        AndroidTask<AndroidJavaCompile> javacTask = this.androidTasks.create(tasks, new JavaCompileConfigAction(scope));
        scope.setJavacTask(javacTask);
        javacTask.dependsOn(tasks, javacIncrementalSafeguard);
        this.setupCompileTaskDependencies(tasks, scope, javacTask);
        if (variantData.getVariantDependency().getClassesConfiguration() != null) {
            AndroidTask<Jar> packageJarArtifact = this.androidTasks.create(tasks, new PackageJarArtifactConfigAction(scope));
            packageJarArtifact.dependsOn(tasks, javacTask);
        }
        return javacTask;
    }

    public static void addJavacClassesStream(VariantScope scope) {
        Preconditions.checkNotNull(scope.getJavacTask());
        scope.getTransformManager().addStream(OriginalStream.builder().addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES).addScope(QualifiedContent.Scope.PROJECT).setFolder(scope.getJavaOutputDir()).setDependency(scope.getJavacTask().getName()).build());
    }

    private void setupCompileTaskDependencies(TaskFactory tasks, VariantScope scope, AndroidTask<?> compileTask) {
        IncrementalMode incrementalMode = this.getIncrementalMode(scope.getVariantConfiguration());
        if (incrementalMode == IncrementalMode.LOCAL_RES_ONLY) {
            compileTask.optionalDependsOn(tasks, scope.getGenerateRClassTask());
        } else if (incrementalMode != IncrementalMode.LOCAL_JAVA_ONLY) {
            compileTask.optionalDependsOn(tasks, scope.getSourceGenTask());
            compileTask.dependsOn(tasks, scope.getPrepareDependenciesTask());
            compileTask.dependsOn(tasks, scope.getVariantData().getVariantDependency().getCompileConfiguration().getBuildDependencies());
            compileTask.dependsOn(tasks, scope.getVariantData().getVariantDependency().getAnnotationProcessorConfiguration().getBuildDependencies());
        }
    }

    public static void setJavaCompilerTask(AndroidTask<? extends Task> javaCompilerTask, TaskFactory tasks, VariantScope scope) {
        scope.getCompileTask().dependsOn(tasks, javaCompilerTask);
        scope.setJavaCompilerTask(javaCompilerTask);
        if (scope.getVariantData().javacTask != null) {
            scope.getVariantData().javaCompilerTask = tasks.named(javaCompilerTask.getName());
        }
    }

    public void createGenerateMicroApkDataTask(TaskFactory tasks, VariantScope scope, Configuration config) {
        AndroidTask<GenerateApkDataTask> generateMicroApkTask = this.androidTasks.create(tasks, new GenerateApkDataTask.ConfigAction(scope, config));
        scope.setMicroApkTask(generateMicroApkTask);
        generateMicroApkTask.optionalDependsOn(tasks, config);
        scope.getResourceGenTask().dependsOn(tasks, generateMicroApkTask);
    }

    public void createExternalNativeBuildJsonGenerators(VariantScope scope) {
        CoreExternalNativeBuild externalNativeBuild = this.extension.getExternalNativeBuild();
        ExternalNativeBuildTaskUtils.ExternalNativeBuildProjectPathResolution pathResolution = ExternalNativeBuildTaskUtils.getProjectPath(externalNativeBuild);
        if (pathResolution.errorText != null) {
            this.androidBuilder.getErrorReporter().handleSyncError(scope.getVariantConfiguration().getFullName(), 16, pathResolution.errorText);
            return;
        }
        if (pathResolution.makeFile == null) {
            return;
        }
        scope.getVariantConfiguration().setInstantRunSupportStatusOverride(4);
        scope.setExternalNativeJsonGenerator(ExternalNativeJsonGenerator.create(this.project.getProjectDir(), pathResolution.buildSystem, pathResolution.makeFile, this.androidBuilder, this.sdkHandler, scope));
    }

    public void createExternalNativeBuildTasks(TaskFactory tasks, VariantScope scope) {
        ExternalNativeJsonGenerator generator = scope.getExternalNativeJsonGenerator();
        if (generator == null) {
            return;
        }
        AndroidTask<ExternalNativeBuildJsonTask> generateTask = this.androidTasks.create(tasks, ExternalNativeBuildJsonTask.createTaskConfigAction(generator, scope));
        generateTask.dependsOn(tasks, scope.getPreBuildTask());
        AndroidTask<ExternalNativeBuildTask> buildTask = this.androidTasks.create(tasks, new ExternalNativeBuildTask.ConfigAction(AndroidGradleOptions.getBuildTargetAbi(this.project), generator, scope, this.androidBuilder));
        buildTask.dependsOn(tasks, generateTask);
        scope.setExternalNativeBuildTask(buildTask);
        scope.getCompileTask().dependsOn(tasks, buildTask);
        Task cleanTask = (Task)Preconditions.checkNotNull((Object)tasks.named("clean"));
        cleanTask.dependsOn(new Object[]{this.androidTasks.create(tasks, new ExternalNativeCleanTask.ConfigAction(generator, scope, this.androidBuilder)).getName()});
    }

    public void createNdkTasks(VariantScope scope) {
        if (ExternalNativeBuildTaskUtils.isExternalNativeBuildEnabled(this.extension.getExternalNativeBuild())) {
            return;
        }
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        NdkCompile ndkCompile = (NdkCompile)this.project.getTasks().create(scope.getTaskName("compile", "Ndk"), NdkCompile.class);
        ndkCompile.dependsOn(new Object[]{scope.getPreBuildTask().getName()});
        ndkCompile.setAndroidBuilder(this.androidBuilder);
        ndkCompile.setVariantName(variantData.getName());
        ndkCompile.setNdkDirectory(this.sdkHandler.getNdkFolder());
        ndkCompile.setForTesting(variantData.getType().isForTesting());
        variantData.ndkCompileTask = ndkCompile;
        variantData.compileTask.dependsOn(new Object[]{variantData.ndkCompileTask});
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        if (Boolean.TRUE.equals(variantConfig.getMergedFlavor().getRenderscriptNdkModeEnabled())) {
            ndkCompile.setNdkRenderScriptMode(true);
            ndkCompile.dependsOn(new Object[]{variantData.renderscriptCompileTask});
        } else {
            ndkCompile.setNdkRenderScriptMode(false);
        }
        ConventionMappingHelper.map((Task)ndkCompile, "sourceFolders", () -> {
            List sourceList = variantConfig.getJniSourceList();
            if (Boolean.TRUE.equals(variantConfig.getMergedFlavor().getRenderscriptNdkModeEnabled())) {
                sourceList.add(variantData.renderscriptCompileTask.getSourceOutputDir());
            }
            return sourceList;
        });
        ndkCompile.setGeneratedMakefile(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/Android.mk"));
        ConventionMappingHelper.map((Task)ndkCompile, "ndkConfig", variantConfig::getNdkConfig);
        ConventionMappingHelper.map((Task)ndkCompile, "debuggable", () -> ((CoreBuildType)variantConfig.getBuildType()).isJniDebuggable());
        ndkCompile.setObjFolder(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj"));
        Collection<File> ndkSoFolder = scope.getNdkSoFolder();
        if (ndkSoFolder != null && !ndkSoFolder.isEmpty()) {
            ndkCompile.setSoFolder(ndkSoFolder.iterator().next());
        }
    }

    public static void createStripNativeLibraryTask(TaskFactory tasks, VariantScope scope) {
        if (!scope.getGlobalScope().getNdkHandler().isConfigured()) {
            return;
        }
        TransformManager transformManager = scope.getTransformManager();
        transformManager.addTransform(tasks, scope, new StripDebugSymbolTransform(scope.getGlobalScope().getProject(), scope.getGlobalScope().getNdkHandler()));
    }

    public void createUnitTestVariantTasks(TaskFactory tasks, TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        Preconditions.checkState((testedVariantData != null ? 1 : 0) != 0);
        this.createPreBuildTasks(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        this.createProcessJavaResTasks(tasks, variantScope);
        this.createCompileAnchorTask(tasks, variantScope);
        variantScope.getCompileTask().dependsOn(tasks, variantScope.getProcessJavaResourcesTask(), testedVariantData.getScope().getProcessJavaResourcesTask());
        AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
        TaskManager.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
        javacTask.dependsOn(tasks, testedVariantData.getScope().getJavacTask());
        this.createRunUnitTestTask(tasks, variantScope);
        variantScope.getAssembleTask().dependsOn(tasks, this.createMockableJar);
        variantScope.getAssembleTask().configure(tasks, (Action<DefaultTask>)((Action)task -> task.setGroup(null)));
    }

    public void createAndroidTestVariantTasks(TaskFactory tasks, TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        BaseVariantOutputData variantOutputData = (BaseVariantOutputData)variantData.getOutputs().get(0);
        BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
        BaseVariantOutputData testedVariantOutputData = (BaseVariantOutputData)testedVariantData.getOutputs().get(0);
        this.createAnchorTasks(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        this.createProcessTestManifestTask(tasks, variantScope);
        this.createGenerateResValuesTask(tasks, variantScope);
        this.createRenderscriptTask(tasks, variantScope);
        this.createMergeResourcesTask(tasks, variantScope);
        this.createMergeAssetsTask(tasks, variantScope);
        if (variantData.getTestedVariantData().getVariantConfiguration().getType().equals((Object)VariantType.LIBRARY) && testedVariantOutputData.getScope().getAssembleTask() != null) {
            String bundle = testedVariantOutputData.getScope().getVariantScope().getTaskName("bundle");
            variantOutputData.getScope().getManifestProcessorTask().dependsOn(tasks, bundle);
            variantScope.getMergeResourcesTask().dependsOn(tasks, bundle);
        }
        this.createBuildConfigTask(tasks, variantScope);
        this.createApkProcessResTask(tasks, variantScope);
        this.createProcessJavaResTasks(tasks, variantScope);
        this.createAidlTask(tasks, variantScope);
        this.createShaderTask(tasks, variantScope);
        if (!this.isComponentModelPlugin) {
            this.createNdkTasks(variantScope);
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.createMergeJniLibFoldersTasks(tasks, variantScope);
        CoreJackOptions jackOptions = variantData.getVariantConfiguration().getJackOptions();
        if (jackOptions.isEnabled().booleanValue()) {
            AndroidTask<TransformTask> jackTask = this.createJackTask(tasks, variantScope, true);
            TaskManager.setJavaCompilerTask(jackTask, tasks, variantScope);
        } else {
            AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
            TaskManager.addJavacClassesStream(variantScope);
            TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
            this.createPostCompilationTasks(tasks, variantScope);
        }
        Preconditions.checkNotNull(variantScope.getJavaCompilerTask());
        variantScope.getJavaCompilerTask().dependsOn(tasks, testedVariantData.getScope().getJavaCompilerTask());
        if (this.extension.getDataBinding().isEnabled()) {
            this.createDataBindingTasks(tasks, variantScope);
        }
        this.createPackagingTask(tasks, variantScope, false, null);
        tasks.named(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)((Action)assembleTest -> assembleTest.dependsOn(new Object[]{variantOutputData.getScope().getAssembleTask().getName()})));
        this.createConnectedTestForVariant(tasks, variantScope);
    }

    protected IncrementalMode getIncrementalMode(GradleVariantConfiguration config) {
        if (config.isInstantRunSupported() && TaskManager.targetDeviceSupportsInstantRun(config, this.project) && this.globalScope.isActive(OptionalCompilationStep.INSTANT_DEV)) {
            if (this.isComponentModelPlugin) {
                return IncrementalMode.FULL;
            }
            if (this.globalScope.isActive(OptionalCompilationStep.LOCAL_RES_ONLY)) {
                return IncrementalMode.LOCAL_RES_ONLY;
            }
            if (this.globalScope.isActive(OptionalCompilationStep.LOCAL_JAVA_ONLY)) {
                return IncrementalMode.LOCAL_JAVA_ONLY;
            }
            return IncrementalMode.FULL;
        }
        return IncrementalMode.NONE;
    }

    private static boolean targetDeviceSupportsInstantRun(GradleVariantConfiguration config, Project project) {
        if (config.isLegacyMultiDexMode()) {
            return AndroidGradleOptions.getTargetFeatureLevel(project) >= AndroidVersion.ART_RUNTIME.getFeatureLevel();
        }
        return true;
    }

    private static boolean isLintVariant(BaseVariantData<? extends BaseVariantOutputData> baseVariantData) {
        GradleVariantConfiguration config = baseVariantData.getVariantConfiguration();
        return !config.getType().isForTesting();
    }

    public void createLintTasks(TaskFactory tasks, VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> baseVariantData = scope.getVariantData();
        if (!TaskManager.isLintVariant(baseVariantData)) {
            return;
        }
        tasks.named(LINT, (Action<? super Task>)((Action)lint -> lint.dependsOn(new Object[]{scope.getJavacTask().getName()})));
        AndroidTask<Lint> variantLintCheck = this.androidTasks.create(tasks, new Lint.ConfigAction(scope));
        variantLintCheck.dependsOn(tasks, LINT_COMPILE, scope.getJavacTask());
    }

    private void createLintVitalTask(TaskFactory tasks, ApkVariantData variantData) {
        Preconditions.checkState((boolean)this.getExtension().getLintOptions().isCheckReleaseBuilds());
        if (!((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isDebuggable() && !variantData.getVariantConfiguration().getJackOptions().isEnabled().booleanValue()) {
            final AndroidTask<Lint> lintReleaseCheck = this.androidTasks.create(tasks, new Lint.VitalConfigAction(variantData.getScope()));
            lintReleaseCheck.optionalDependsOn(tasks, variantData.javacTask);
            variantData.getScope().getAssembleTask().dependsOn(tasks, lintReleaseCheck);
            this.project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Void>((Object)this, (Object)this){

                public void doCall(TaskExecutionGraph taskGraph) {
                    if (taskGraph.hasTask(TaskManager.LINT)) {
                        TaskManager.this.project.getTasks().getByName(lintReleaseCheck.getName()).setEnabled(false);
                    }
                }
            });
        }
    }

    private void createRunUnitTestTask(TaskFactory tasks, VariantScope variantScope) {
        AndroidTask<AndroidUnitTest> runTestsTask = this.androidTasks.create(tasks, new AndroidUnitTest.ConfigAction(variantScope));
        runTestsTask.dependsOn(tasks, variantScope.getAssembleTask());
        tasks.named("test", (Action<? super Task>)((Action)test -> test.dependsOn(new Object[]{runTestsTask.getName()})));
    }

    public void createTopLevelTestTasks(final TaskFactory tasks, boolean hasFlavors) {
        AndroidTask<DefaultTask> deviceAndroidTestTask;
        AndroidTask<DefaultTask> connectedAndroidTestTask;
        this.createMockableJarTask(tasks);
        final ArrayList reportTasks = Lists.newArrayListWithExpectedSize((int)2);
        List<DeviceProvider> providers = this.getExtension().getDeviceProviders();
        if (hasFlavors) {
            connectedAndroidTestTask = this.androidTasks.create(tasks, new AndroidReportTask.ConfigAction(this.globalScope, AndroidReportTask.ConfigAction.TaskKind.CONNECTED));
            reportTasks.add(connectedAndroidTestTask.getName());
        } else {
            connectedAndroidTestTask = this.androidTasks.create(tasks, CONNECTED_ANDROID_TEST, (Action<Task>)((Action)connectedTask -> {
                connectedTask.setGroup("verification");
                connectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
            }));
        }
        tasks.named(CONNECTED_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{connectedAndroidTestTask.getName()})));
        if (providers.size() > 1 || hasFlavors) {
            deviceAndroidTestTask = this.androidTasks.create(tasks, new AndroidReportTask.ConfigAction(this.globalScope, AndroidReportTask.ConfigAction.TaskKind.DEVICE_PROVIDER));
            reportTasks.add(deviceAndroidTestTask.getName());
        } else {
            deviceAndroidTestTask = this.androidTasks.create(tasks, DEVICE_ANDROID_TEST, (Action<Task>)((Action)providerTask -> {
                providerTask.setGroup("verification");
                providerTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
            }));
        }
        tasks.named(DEVICE_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{deviceAndroidTestTask.getName()})));
        this.androidTasks.create(tasks, "test", (Action<Task>)((Action)unitTestTask -> {
            unitTestTask.setGroup("verification");
            unitTestTask.setDescription("Run unit tests for all variants.");
        }));
        tasks.named("check", (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{"test"})));
        if (!reportTasks.isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Void>((Object)this, (Object)this){

                public void doCall(TaskExecutionGraph taskGraph) {
                    for (String reportTask : reportTasks) {
                        if (!taskGraph.hasTask(reportTask)) continue;
                        tasks.named(reportTask, (Action<? super Task>)new Action<Task>(){

                            public void execute(Task task) {
                                ((AndroidReportTask)task).setWillRun();
                            }
                        });
                    }
                }
            });
        }
    }

    protected void createConnectedTestForVariant(TaskFactory tasks, VariantScope variantScope) {
        BaseVariantData baseVariantData = variantScope.getTestedVariantData();
        TestVariantData testVariantData = (TestVariantData)variantScope.getVariantData();
        BaseVariantOutputData variantOutputData = (BaseVariantOutputData)baseVariantData.getOutputs().get(0);
        BaseVariantOutputData testVariantOutputData = (BaseVariantOutputData)testVariantData.getOutputs().get(0);
        TestDataImpl testData = new TestDataImpl(testVariantData);
        testData.setExtraInstrumentationTestRunnerArgs(AndroidGradleOptions.getExtraInstrumentationTestRunnerArgs(this.project));
        ImmutableList artifactsTasks = ImmutableList.of(((ApkVariantOutputData)testVariantData.getOutputs().get(0)).getScope().getAssembleTask(), baseVariantData.getScope().getAssembleTask());
        AndroidTask<DeviceProviderInstrumentTestTask> connectedTask = this.androidTasks.create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.globalScope.getExtension().getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.logger)), testData));
        connectedTask.dependsOn(tasks, artifactsTasks.toArray());
        tasks.named(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{connectedTask.getName()})));
        if (((CoreBuildType)baseVariantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            AndroidTask<DefaultTask> reportTask = baseVariantData.getVariantConfiguration().getJackOptions().isEnabled() != false ? this.androidTasks.create(tasks, new JackJacocoReportTask.ConfigAction(variantScope)) : this.androidTasks.create(tasks, new JacocoReportTask.ConfigAction(variantScope));
            reportTask.dependsOn(tasks, connectedTask.getName());
            variantScope.setCoverageReportTask(reportTask);
            baseVariantData.getScope().getCoverageReportTask().dependsOn(tasks, reportTask);
            tasks.named(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{reportTask.getName()})));
        }
        List<DeviceProvider> providers = this.getExtension().getDeviceProviders();
        boolean hasFlavors = baseVariantData.getVariantConfiguration().hasFlavors();
        for (DeviceProvider deviceProvider : providers) {
            AndroidTask<DeviceProviderInstrumentTestTask> providerTask = this.androidTasks.create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), deviceProvider, testData));
            providerTask.dependsOn(tasks, artifactsTasks.toArray());
            tasks.named(DEVICE_ANDROID_TEST, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{providerTask.getName()})));
        }
        List<TestServer> servers = this.getExtension().getTestServers();
        for (TestServer testServer : servers) {
            AndroidTask<TestServerTask> serverTask = this.androidTasks.create(tasks, new TestServerTaskConfigAction(variantScope, testServer));
            serverTask.dependsOn(tasks, testVariantOutputData.getScope().getAssembleTask(), variantOutputData.getScope().getAssembleTask());
            tasks.named(DEVICE_CHECK, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{serverTask.getName()})));
        }
    }

    public void createPostCompilationTasks(TaskFactory tasks, VariantScope variantScope) {
        boolean isTestCoverageEnabled;
        Preconditions.checkNotNull(variantScope.getJavacTask());
        variantScope.getInstantRunBuildContext().setInstantRunMode(this.getIncrementalMode(variantScope.getVariantConfiguration()) != IncrementalMode.NONE);
        BaseVariantData<? extends BaseVariantOutputData> variantData = variantScope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        TransformManager transformManager = variantScope.getTransformManager();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && !config.getType().isForTesting() && this.getIncrementalMode(variantScope.getVariantConfiguration()) == IncrementalMode.NONE;
        if (isTestCoverageEnabled) {
            this.createJacocoTransform(tasks, variantScope);
        }
        boolean isMinifyEnabled = this.isMinifyEnabled(variantScope);
        boolean isMultiDexEnabled = config.isMultiDexEnabled();
        boolean isLegacyMultiDexMode = this.isLegacyMultidexMode(variantScope);
        AndroidConfig extension = variantScope.getGlobalScope().getExtension();
        List<Transform> customTransforms = extension.getTransforms();
        List<List<Object>> customTransformsDependencies = extension.getTransformsDependencies();
        int count = customTransforms.size();
        for (int i = 0; i < count; ++i) {
            Transform transform = customTransforms.get(i);
            AndroidTask<TransformTask> task = transformManager.addTransform(tasks, variantScope, transform);
            if (task == null) continue;
            List<Object> deps = customTransformsDependencies.get(i);
            if (!deps.isEmpty()) {
                task.dependsOn(tasks, deps);
            }
            if (!transform.getScopes().isEmpty()) continue;
            variantScope.getAssembleTask().dependsOn(tasks, task);
        }
        if (isMinifyEnabled) {
            boolean outputToJarFile = isMultiDexEnabled && isLegacyMultiDexMode;
            this.createMinifyTransform(tasks, variantScope, outputToJarFile);
        }
        AndroidTask<PreColdSwapTask> preColdSwapTask = null;
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            AndroidTask<DefaultTask> allActionsAnchorTask = this.createInstantRunAllActionsTasks(tasks, variantScope);
            assert (variantScope.getInstantRunTaskManager() != null);
            preColdSwapTask = variantScope.getInstantRunTaskManager().createPreColdswapTask(this.project);
            preColdSwapTask.dependsOn(tasks, allActionsAnchorTask);
            if (InstantRunPatchingPolicy.PRE_LOLLIPOP != variantScope.getInstantRunBuildContext().getPatchingPolicy()) {
                isMultiDexEnabled = true;
                extension.getDexOptions().setPreDexLibraries(true);
                variantScope.getInstantRunTaskManager().createSlicerTask();
            }
            extension.getDexOptions().setJumboMode(true);
        }
        AndroidTask<TransformTask> multiDexClassListTask = null;
        if (isMultiDexEnabled && isLegacyMultiDexMode) {
            if (!((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isUseProguard()) {
                throw new IllegalStateException("Build-in class shrinker and multidex are not supported yet.");
            }
            if (!isMinifyEnabled) {
                JarMergingTransform jarMergingTransform = new JarMergingTransform(TransformManager.SCOPE_FULL_PROJECT);
                variantScope.addColdSwapBuildTask(transformManager.addTransform(tasks, variantScope, jarMergingTransform));
            }
            AndroidTask<CreateManifestKeepList> manifestKeepListTask = null;
            if (!this.useAaptToGenerateLegacyMultidexMainDexProguardRules(variantScope)) {
                manifestKeepListTask = this.androidTasks.create(tasks, new CreateManifestKeepList.ConfigAction(variantScope));
                manifestKeepListTask.dependsOn(tasks, variantData.getOutputs().get(0).getScope().getManifestProcessorTask());
                variantScope.addColdSwapBuildTask(manifestKeepListTask);
            }
            MultiDexTransform multiDexTransform = new MultiDexTransform(variantScope, extension.getDexOptions(), null);
            multiDexClassListTask = transformManager.addTransform(tasks, variantScope, multiDexTransform);
            multiDexClassListTask.optionalDependsOn(tasks, manifestKeepListTask);
            variantScope.addColdSwapBuildTask(multiDexClassListTask);
        }
        DefaultDexOptions dexOptions = DefaultDexOptions.copyOf((DexOptions)extension.getDexOptions());
        if (variantData.getType().isForTesting()) {
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        }
        DexTransform dexTransform = new DexTransform((DexOptions)dexOptions, ((CoreBuildType)config.getBuildType()).isDebuggable(), isMultiDexEnabled, isMultiDexEnabled && isLegacyMultiDexMode ? variantScope.getMainDexListFile() : null, variantScope.getPreDexOutputDir(), variantScope.getGlobalScope().getAndroidBuilder(), this.getLogger(), variantScope.getInstantRunBuildContext(), AndroidGradleOptions.getBuildCache(variantScope.getGlobalScope().getProject()));
        AndroidTask<TransformTask> dexTask = transformManager.addTransform(tasks, variantScope, dexTransform);
        dexTask.optionalDependsOn(tasks, multiDexClassListTask);
        variantScope.addColdSwapBuildTask(dexTask);
        if (preColdSwapTask != null) {
            for (AndroidTask<? extends DefaultTask> task : variantScope.getColdSwapBuildTasks()) {
                task.dependsOn(tasks, preColdSwapTask);
            }
        }
    }

    private boolean isLegacyMultidexMode(VariantScope variantScope) {
        return variantScope.getVariantData().getVariantConfiguration().isLegacyMultiDexMode() && (this.getIncrementalMode(variantScope.getVariantConfiguration()) == IncrementalMode.NONE || variantScope.getInstantRunBuildContext().getPatchingPolicy() == InstantRunPatchingPolicy.PRE_LOLLIPOP);
    }

    private boolean isMinifyEnabled(VariantScope variantScope) {
        return variantScope.getVariantConfiguration().isMinifyEnabled() || this.isTestedAppMinified(variantScope);
    }

    protected boolean isTestedAppMinified(VariantScope variantScope) {
        return false;
    }

    private AndroidTask<DefaultTask> createInstantRunAllActionsTasks(TaskFactory tasks, final VariantScope variantScope) {
        AndroidTask<DefaultTask> allActionAnchorTask = this.getAndroidTasks().create(tasks, new InstantRunAnchorTaskConfigAction(variantScope));
        TransformManager transformManager = variantScope.getTransformManager();
        ExtractJarsTransform extractJarsTransform = new ExtractJarsTransform((Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.SUB_PROJECTS));
        AndroidTask<TransformTask> extractJarsTask = transformManager.addTransform(tasks, variantScope, extractJarsTransform);
        InstantRunTaskManager instantRunTaskManager = new InstantRunTaskManager(this.getLogger(), variantScope, variantScope.getTransformManager(), this.androidTasks, tasks);
        variantScope.setInstantRunTaskManager(instantRunTaskManager);
        AndroidTask<BuildInfoLoaderTask> buildInfoLoaderTask = instantRunTaskManager.createInstantRunAllTasks((DexOptions)variantScope.getGlobalScope().getExtension().getDexOptions(), () -> ((AndroidBuilder)this.androidBuilder).getDexByteCodeConverter(), extractJarsTask, allActionAnchorTask, this.getResMergingScopes(variantScope), new SupplierTask<File>(){
            private final VariantOutputScope variantOutputScope;
            {
                this.variantOutputScope = variantScope.getVariantData().getOutputs().get(0).getScope();
            }

            @Override
            public AndroidTask<?> getBuilderTask() {
                return this.variantOutputScope.getManifestProcessorTask();
            }

            @Override
            public File get() {
                return this.variantOutputScope.getVariantScope().getInstantRunManifestOutputFile();
            }
        }, new SupplierTask<File>(){
            private final VariantOutputScope variantOutputScope;
            {
                this.variantOutputScope = variantScope.getVariantData().getOutputs().get(0).getScope();
            }

            @Override
            public AndroidTask<?> getBuilderTask() {
                return this.variantOutputScope.getProcessResourcesTask();
            }

            @Override
            public File get() {
                return this.variantOutputScope.getProcessResourcePackageOutputFile();
            }
        }, true);
        if (variantScope.getSourceGenTask() != null) {
            variantScope.getSourceGenTask().dependsOn(tasks, buildInfoLoaderTask);
        }
        return allActionAnchorTask;
    }

    protected void handleJacocoDependencies(TaskFactory tasks, VariantScope variantScope) {
        boolean isTestCoverageEnabled;
        GradleVariantConfiguration config = variantScope.getVariantConfiguration();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && this.getIncrementalMode(variantScope.getVariantConfiguration()) == IncrementalMode.NONE && (!config.getType().isForTesting() || config.getTestedConfig() != null && config.getTestedConfig().getType() == VariantType.LIBRARY);
        if (isTestCoverageEnabled) {
            AndroidTask<Copy> agentTask = this.getJacocoAgentTask(tasks);
            variantScope.getTransformManager().addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_JARS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJar(this.globalScope.getJacocoAgent()).setDependency(agentTask.getName()).build());
        }
    }

    public void createJacocoTransform(TaskFactory taskFactory, VariantScope variantScope) {
        AndroidTask<TransformTask> task = variantScope.getTransformManager().addTransform(taskFactory, variantScope, new JacocoTransform(this.project.getConfigurations()));
        AndroidTask<Copy> agentTask = this.getJacocoAgentTask(taskFactory);
        task.dependsOn(taskFactory, agentTask);
    }

    public AndroidTask<TransformTask> createJackTask(TaskFactory tasks, VariantScope scope, boolean compileJavaSources) {
        JackTransform jackTransform;
        if (scope.getTestedVariantData() != null) {
            scope.getTransformManager().addStream(OriginalStream.builder().addContentType(ExtendedContentType.JACK).addScope(QualifiedContent.Scope.TESTED_CODE).setJar(scope.getTestedVariantData().getScope().getJackClassesZip()).setDependency(scope.getTestedVariantData().getScope().getJavaCompilerTask().getName()).build());
        }
        JackPreDexTransform preDexPackagedTransform = new JackPreDexTransform(this.androidBuilder, this.globalScope.getExtension().getDexOptions().getJavaMaxHeapSize(), scope.getVariantConfiguration().getJackOptions(), true);
        AndroidTask<TransformTask> packageTask = scope.getTransformManager().addTransform(tasks, scope, preDexPackagedTransform);
        AndroidTask<Copy> jacocoTask = this.getJacocoAgentTask(tasks);
        if (jacocoTask != null) {
            packageTask.dependsOn(tasks, scope.getVariantData().getVariantDependency().getPackageConfiguration().getBuildDependencies(), jacocoTask);
        }
        JackPreDexTransform preDexRuntimeTransform = new JackPreDexTransform(this.androidBuilder, this.globalScope.getExtension().getDexOptions().getJavaMaxHeapSize(), scope.getVariantConfiguration().getJackOptions(), false);
        scope.getTransformManager().addTransform(tasks, scope, preDexRuntimeTransform);
        scope.getVariantData().jackTransform = jackTransform = new JackTransform(scope, this.isDebugLog(), compileJavaSources);
        AndroidTask<TransformTask> jackTask = scope.getTransformManager().addTransform(tasks, scope, jackTransform, (transform, task) -> {
            scope.getVariantData().javaCompilerTask = task;
            scope.getVariantData().mappingFileProviderTask = new FileSupplier((JackTransform)transform){
                final /* synthetic */ JackTransform val$transform;
                {
                    this.val$transform = jackTransform;
                }

                @Override
                public Task getTask() {
                    return task;
                }

                public File get() {
                    return this.val$transform.getMappingFile();
                }
            };
        });
        if (jackTask == null) {
            this.getLogger().error("Could not create jack transform.", new Throwable());
            return null;
        }
        TaskManager.setJavaCompilerTask(jackTask, tasks, scope);
        this.setupCompileTaskDependencies(tasks, scope, jackTask);
        jackTask.optionalDependsOn(tasks, scope.getMergeJavaResourcesTask());
        jackTask.dependsOn(tasks, scope.getSourceGenTask());
        return jackTask;
    }

    protected void createDataBindingTasks(TaskFactory tasks, VariantScope scope) {
        if (scope.getVariantConfiguration().getJackOptions().isEnabled().booleanValue()) {
            this.androidBuilder.getErrorReporter().handleSyncError(scope.getVariantConfiguration().getFullName(), 11, "Data Binding does not support Jack builds yet");
        }
        this.dataBindingBuilder.setDebugLogEnabled(this.getLogger().isDebugEnabled());
        AndroidTask<DataBindingProcessLayoutsTask> processLayoutsTask = this.androidTasks.create(tasks, new DataBindingProcessLayoutsTask.ConfigAction(scope));
        scope.setDataBindingProcessLayoutsTask(processLayoutsTask);
        scope.getGenerateRClassTask().dependsOn(tasks, processLayoutsTask);
        processLayoutsTask.dependsOn(tasks, scope.getMergeResourcesTask());
        AndroidTask<DataBindingExportBuildInfoTask> exportBuildInfo = this.androidTasks.create(tasks, new DataBindingExportBuildInfoTask.ConfigAction(scope, this.dataBindingBuilder.getPrintMachineReadableOutput()));
        scope.setDataBindingExportInfoTask(exportBuildInfo);
        exportBuildInfo.dependsOn(tasks, processLayoutsTask);
        AndroidTask<? extends Task> javaCompilerTask = scope.getJavaCompilerTask();
        if (javaCompilerTask != null) {
            javaCompilerTask.dependsOn(tasks, exportBuildInfo);
        }
        this.setupCompileTaskDependencies(tasks, scope, exportBuildInfo);
        for (BaseVariantOutputData baseVariantOutputData : scope.getVariantData().getOutputs()) {
            ProcessAndroidResources processResTask = baseVariantOutputData.processResourcesTask;
            if (processResTask == null) continue;
            processResTask.dependsOn(new Object[]{processLayoutsTask.getName()});
        }
    }

    public void createPackagingTask(TaskFactory tasks, VariantScope variantScope, boolean publishApk, AndroidTask<InstantRunWrapperTask> fullBuildInfoGeneratorTask) {
        GlobalScope globalScope = variantScope.getGlobalScope();
        ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
        boolean signedApk = variantData.isSigned();
        boolean multiOutput = variantData.getOutputs().size() > 1;
        GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
        IncrementalMode incrementalMode = this.getIncrementalMode(variantConfiguration);
        List outputDataList = variantData.getOutputs();
        String abiList = Strings.nullToEmpty((String)AndroidGradleOptions.getBuildTargetAbi(this.project));
        String density = Strings.nullToEmpty((String)AndroidGradleOptions.getBuildTargetDensity(this.project));
        if (outputDataList.size() > 1 && !abiList.isEmpty()) {
            List<String> abis = Arrays.asList(abiList.split(","));
            Density densityEnum = Density.getEnum((String)density);
            List outputFiles = SplitOutputMatcher.computeBestOutput(outputDataList, variantConfiguration.getSupportedAbis(), (int)(densityEnum == null ? -1 : densityEnum.getDpiValue()), (Collection)abis);
            ImmutableList bestMatch = null;
            if (!outputFiles.isEmpty()) {
                for (ApkVariantOutputData apkVariantOutputData : outputDataList) {
                    if (apkVariantOutputData.getMainOutputFile() != outputFiles.get(0)) continue;
                    bestMatch = ImmutableList.of((Object)apkVariantOutputData);
                    break;
                }
                Preconditions.checkNotNull(bestMatch, (Object)"There should always be an VariantOutputData containing the OutputFile.");
            }
            if (bestMatch == null) {
                throw new RuntimeException(String.format("The currently selected variant \"%s\" uses split APKs, but none of the %s split apks are compatible with the current device with density \"%s\" and ABIs \"%s\".", variantConfiguration.getFullName(), outputDataList.size(), density, abiList));
            }
            outputDataList = bestMatch;
        }
        for (ApkVariantOutputData variantOutputData : outputDataList) {
            CoreSigningConfig signingConfig;
            VariantOutputScope variantOutputScope = variantOutputData.getScope();
            String outputName = variantOutputData.getFullName();
            InstantRunPatchingPolicy patchingPolicy = variantScope.getInstantRunBuildContext().getPatchingPolicy();
            DefaultGradlePackagingScope packagingScope = new DefaultGradlePackagingScope(variantOutputScope);
            AndroidTask<PackageApplication> packageApp = this.androidTasks.create(tasks, new PackageApplication.StandardConfigAction(packagingScope, patchingPolicy));
            AndroidTask<PackageApplication> packageInstantRunResources = null;
            if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
                packageInstantRunResources = this.androidTasks.create(tasks, new PackageApplication.InstantRunResourcesConfigAction(variantScope.getInstantRunResourcesFile(), packagingScope, patchingPolicy));
                packageApp.dependsOn(tasks, packageInstantRunResources);
            }
            packageApp.configure(tasks, (Action<PackageApplication>)((Action)task -> {
                variantOutputData.packageAndroidArtifactTask = task;
            }));
            TransformManager transformManager = variantScope.getTransformManager();
            Consumer<AndroidTask> configureResourcesAndAssetsDependencies = task -> {
                task.dependsOn(tasks, variantScope.getMergeAssetsTask());
                task.dependsOn(tasks, variantOutputScope.getProcessResourcesTask());
                transformManager.getStreams(StreamFilter.RESOURCES).forEach(stream -> task.dependsOn(tasks, stream.getDependencies()));
            };
            configureResourcesAndAssetsDependencies.accept(packageApp);
            if (packageInstantRunResources != null) {
                configureResourcesAndAssetsDependencies.accept(packageInstantRunResources);
            }
            if ((signingConfig = packagingScope.getSigningConfig()) != null) {
                ValidateSigningTask.ConfigAction configAction = new ValidateSigningTask.ConfigAction(packagingScope);
                AndroidTask<Object> validateSigningTask = this.androidTasks.get(configAction.getName());
                if (validateSigningTask == null) {
                    validateSigningTask = this.androidTasks.create(tasks, configAction);
                }
                packageApp.dependsOn(tasks, validateSigningTask);
            }
            packageApp.optionalDependsOn(tasks, new Object[]{variantOutputScope.getShrinkResourcesTask(), variantOutputScope.getVariantScope().getJavaCompilerTask(), variantData.javaCompilerTask, variantOutputData.packageSplitResourcesTask, variantOutputData.packageSplitAbiTask});
            for (TransformStream stream : transformManager.getStreams(StreamFilter.DEX)) {
                packageApp.dependsOn(tasks, stream.getDependencies());
            }
            for (TransformStream stream : transformManager.getStreams(StreamFilter.NATIVE_LIBS)) {
                packageApp.dependsOn(tasks, stream.getDependencies());
            }
            variantScope.setPackageApplicationTask(packageApp);
            AndroidTask<DefaultTask> appTask = packageApp;
            if (signedApk) {
                if (AndroidGradleOptions.useOldPackaging(globalScope.getProject()) && variantData.getZipAlignEnabled()) {
                    AndroidTask<ZipAlign> zipAlignTask = this.androidTasks.create(tasks, new ZipAlign.ConfigAction(variantOutputScope));
                    zipAlignTask.dependsOn(tasks, packageApp);
                    appTask = zipAlignTask;
                }
                if (variantData.getZipAlignEnabled() && variantOutputScope.getSplitZipAlignTask() != null) {
                    appTask.dependsOn(tasks, variantOutputScope.getSplitZipAlignTask());
                }
            }
            Preconditions.checkState((variantScope.getAssembleTask() != null ? 1 : 0) != 0);
            if (fullBuildInfoGeneratorTask != null) {
                fullBuildInfoGeneratorTask.optionalDependsOn(tasks, appTask, packageInstantRunResources);
                variantScope.getAssembleTask().dependsOn(tasks, fullBuildInfoGeneratorTask.getName());
            }
            if (multiOutput) {
                variantOutputScope.setAssembleTask(this.createAssembleTask(tasks, variantOutputData));
                variantScope.getAssembleTask().dependsOn(tasks, variantOutputScope.getAssembleTask());
            } else {
                variantOutputScope.setAssembleTask(variantScope.getAssembleTask());
                variantOutputData.assembleTask = variantData.assembleVariantTask;
            }
            if (!signedApk && variantOutputData.packageSplitResourcesTask != null) {
                String appTaskName = appTask.getName();
                AndroidTask<Copy> copySplitTask = this.androidTasks.create(tasks, variantOutputScope.getTaskName("copySplit"), Copy.class, copyTask -> {
                    copyTask.setDestinationDir(this.getGlobalScope().getApkLocation());
                    copyTask.from(new Object[]{variantOutputData.packageSplitResourcesTask.getOutputDirectory()});
                    copyTask.mustRunAfter(new Object[]{appTaskName});
                });
                variantOutputScope.getAssembleTask().dependsOn(tasks, copySplitTask);
            }
            variantOutputScope.getAssembleTask().dependsOn(tasks, appTask);
            if (!publishApk) continue;
            String projectBaseName = globalScope.getProjectBaseName();
            if (this.getExtension().getDefaultPublishConfig().equals(outputName)) {
                appTask.configure(tasks, (Action<DefaultTask>)((Action)packageTask -> this.project.getArtifacts().add("default", (Object)new ApkPublishArtifact(projectBaseName, null, (FileSupplier)packageTask))));
                for (FileSupplier outputFileProvider : variantOutputData.getSplitOutputFileSuppliers()) {
                    this.project.getArtifacts().add("default", (Object)new ApkPublishArtifact(projectBaseName, null, outputFileProvider));
                }
                try {
                    if (variantOutputData.getMetadataFile() != null) {
                        this.project.getArtifacts().add("default-metadata", (Object)new MetadataPublishArtifact(projectBaseName, null, variantOutputData.getMetadataFile()));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (variantData.getMappingFileProvider() != null) {
                    this.project.getArtifacts().add("default-mapping", (Object)new MappingPublishArtifact(projectBaseName, null, variantData.getMappingFileProvider()));
                }
            }
            if (!this.getExtension().getPublishNonDefault()) continue;
            appTask.configure(tasks, (Action<DefaultTask>)((Action)packageTask -> this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)new ApkPublishArtifact(projectBaseName, null, (FileSupplier)packageTask))));
            for (FileSupplier outputFileProvider : variantOutputData.getSplitOutputFileSuppliers()) {
                this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)new ApkPublishArtifact(projectBaseName, null, outputFileProvider));
            }
            try {
                if (variantOutputData.getMetadataFile() != null) {
                    this.project.getArtifacts().add(variantData.getVariantDependency().getMetadataConfiguration().getName(), (Object)new MetadataPublishArtifact(projectBaseName, null, variantOutputData.getMetadataFile()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (variantData.getMappingFileProvider() != null) {
                this.project.getArtifacts().add(variantData.getVariantDependency().getMappingConfiguration().getName(), (Object)new MappingPublishArtifact(projectBaseName, null, variantData.getMappingFileProvider()));
            }
            if (variantData.classesJarTask == null) continue;
            this.project.getArtifacts().add(variantData.getVariantDependency().getClassesConfiguration().getName(), (Object)variantData.classesJarTask);
        }
        if (signedApk) {
            AndroidTask<InstallVariantTask> installTask = this.androidTasks.create(tasks, new InstallVariantTask.ConfigAction(variantScope));
            installTask.dependsOn(tasks, variantScope.getAssembleTask());
        }
        if (this.getExtension().getLintOptions().isCheckReleaseBuilds() && incrementalMode == IncrementalMode.NONE) {
            this.createLintVitalTask(tasks, variantData);
        }
        AndroidTask<UninstallTask> uninstallTask = this.androidTasks.create(tasks, new UninstallTask.ConfigAction(variantScope));
        tasks.named(UNINSTALL_ALL, (Action<? super Task>)((Action)uninstallAll -> uninstallAll.dependsOn(new Object[]{uninstallTask.getName()})));
    }

    public AndroidTask<DefaultTask> createAssembleTask(TaskFactory tasks, BaseVariantOutputData variantOutputData) {
        return this.androidTasks.create(tasks, variantOutputData.getScope().getTaskName("assemble"), (Action<Task>)((Action)task -> {
            variantOutputData.assembleTask = task;
        }));
    }

    public AndroidTask<DefaultTask> createAssembleTask(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        return this.androidTasks.create(tasks, variantData.getScope().getTaskName("assemble"), (Action<Task>)((Action)task -> {
            variantData.assembleVariantTask = task;
        }));
    }

    public AndroidTask<DefaultTask> createAssembleTask(TaskFactory tasks, VariantDimensionData dimensionData) {
        String sourceSetName = StringHelper.capitalize((String)dimensionData.getSourceSet().getName());
        return this.androidTasks.create(tasks, "assemble" + sourceSetName, (Action<Task>)((Action)assembleTask -> {
            assembleTask.setDescription("Assembles all " + sourceSetName + " builds.");
            assembleTask.setGroup(BUILD_GROUP);
        }));
    }

    public AndroidTask<Copy> getJacocoAgentTask(TaskFactory tasks) {
        if (this.jacocoAgentTask == null) {
            this.jacocoAgentTask = this.androidTasks.create(tasks, new JacocoAgentConfigAction(this.globalScope));
        }
        return this.jacocoAgentTask;
    }

    public ZipAlign createZipAlignTask(String name, File inputFile, File outputFile, VariantOutputScope variantOutputScope) {
        ZipAlign zipAlignTask = (ZipAlign)this.project.getTasks().create(name, ZipAlign.class, (Action)new ZipAlign.ConfigAction(variantOutputScope));
        ConventionMappingHelper.map((Task)zipAlignTask, "inputFile", () -> inputFile);
        ConventionMappingHelper.map((Task)zipAlignTask, "outputFile", () -> outputFile);
        zipAlignTask.dependsOn(new Object[]{variantOutputScope.getVariantScope().getPackageApplicationTask().getName()});
        return zipAlignTask;
    }

    protected void createMinifyTransform(TaskFactory taskFactory, VariantScope variantScope, boolean createJarFile) {
        this.doCreateMinifyTransform(taskFactory, variantScope, null, createJarFile);
    }

    protected final void doCreateMinifyTransform(TaskFactory taskFactory, VariantScope variantScope, Configuration mappingConfiguration, boolean createJarFile) {
        if (((CoreBuildType)variantScope.getVariantData().getVariantConfiguration().getBuildType()).isUseProguard()) {
            this.createProguardTransform(taskFactory, variantScope, mappingConfiguration, createJarFile);
            this.createShrinkResourcesTransform(taskFactory, variantScope);
        } else if (variantScope.getTestedVariantData() == null) {
            this.createNewShrinkerTransform(variantScope, taskFactory);
            this.createShrinkResourcesTransform(taskFactory, variantScope);
        }
    }

    private void createNewShrinkerTransform(VariantScope scope, TaskFactory taskFactory) {
        NewShrinkerTransform transform = new NewShrinkerTransform(scope);
        this.applyProguardConfig(transform, scope.getVariantData());
        if (this.getIncrementalMode(scope.getVariantConfiguration()) != IncrementalMode.NONE) {
            transform.keep("class ** extends android.app.Application {*;}");
            transform.keep("class com.android.tools.fd.** {*;}");
        }
        scope.getTransformManager().addTransform(taskFactory, scope, transform);
    }

    private void createProguardTransform(TaskFactory taskFactory, VariantScope variantScope, Configuration mappingConfiguration, boolean createJarFile) {
        if (this.getIncrementalMode(variantScope.getVariantConfiguration()) != IncrementalMode.NONE) {
            this.logger.warn("Instant Run: Proguard is not compatible with instant run. It has been disabled for {}", (Object)variantScope.getVariantConfiguration().getFullName());
            return;
        }
        BaseVariantData<? extends BaseVariantOutputData> variantData = variantScope.getVariantData();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        ProGuardTransform transform = new ProGuardTransform(variantScope, createJarFile);
        if (testedVariantData != null) {
            TaskManager.applyProguardDefaultsForTest(transform);
            transform.setConfigurationFiles(() -> ((GradleVariantConfiguration)testedVariantData.getVariantConfiguration()).getTestProguardFiles());
            transform.applyTestedMapping(testedVariantData.getMappingFile());
        } else if (this.isTestedAppMinified(variantScope)) {
            TaskManager.applyProguardDefaultsForTest(transform);
            transform.setConfigurationFiles(() -> ((GradleVariantConfiguration)variantConfig).getTestProguardFiles());
            transform.applyTestedMapping(mappingConfiguration);
        } else {
            this.applyProguardConfig(transform, variantData);
            if (mappingConfiguration != null) {
                transform.applyTestedMapping(mappingConfiguration);
            }
        }
        AndroidTask<TransformTask> task = variantScope.getTransformManager().addTransform(taskFactory, variantScope, transform, (proGuardTransform, proGuardTask) -> {
            variantData.mappingFileProviderTask = new FileSupplier((ProGuardTransform)proGuardTransform){
                final /* synthetic */ ProGuardTransform val$proGuardTransform;
                {
                    this.val$proGuardTransform = proGuardTransform;
                }

                @Override
                public Task getTask() {
                    return proGuardTask;
                }

                public File get() {
                    return this.val$proGuardTransform.getMappingFile();
                }
            };
        });
        if (mappingConfiguration != null) {
            Verify.verifyNotNull(task);
            task.dependsOn(taskFactory, mappingConfiguration);
        }
    }

    private static void applyProguardDefaultsForTest(ProGuardTransform transform) {
        transform.dontshrink();
        transform.dontoptimize();
        transform.keep("class * {*;}");
        transform.keep("interface * {*;}");
        transform.keep("enum * {*;}");
        transform.keepattributes();
    }

    private void createShrinkResourcesTransform(TaskFactory taskFactory, VariantScope scope) {
        CoreBuildType buildType = (CoreBuildType)scope.getVariantConfiguration().getBuildType();
        if (!buildType.isShrinkResources()) {
            return;
        }
        if (!scope.useResourceShrinker()) {
            if (this.getIncrementalMode(scope.getVariantConfiguration()) != IncrementalMode.NONE) {
                this.logger.warn("Instant Run: Resource shrinker automatically disabled for {}", (Object)scope.getVariantConfiguration().getFullName());
                return;
            }
            if (buildType.isMinifyEnabled() && !buildType.isUseProguard()) {
                this.androidBuilder.getErrorReporter().handleSyncError(null, 0, "Built-in class shrinker and resource shrinking are not supported yet.");
                return;
            }
            return;
        }
        for (BaseVariantOutputData baseVariantOutputData : scope.getVariantData().getOutputs()) {
            VariantOutputScope variantOutputScope = baseVariantOutputData.getScope();
            ShrinkResourcesTransform shrinkResTransform = new ShrinkResourcesTransform(baseVariantOutputData, variantOutputScope.getProcessResourcePackageOutputFile(), variantOutputScope.getShrinkedResourcesFile(), this.androidBuilder, this.logger);
            AndroidTask<TransformTask> shrinkTask = scope.getTransformManager().addTransform(taskFactory, variantOutputScope, shrinkResTransform);
            variantOutputScope.setShrinkResourcesTask(shrinkTask);
        }
    }

    private void applyProguardConfig(ProguardConfigurable transform, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        transform.setConfigurationFiles(() -> {
            Set proguardFiles = variantConfig.getProguardFiles(true, Collections.singletonList(ProguardFiles.getDefaultProguardFile(DEFAULT_PROGUARD_CONFIG_FILE, this.project)));
            BaseVariantOutputData outputData = (BaseVariantOutputData)variantData.getOutputs().get(0);
            proguardFiles.add(outputData.processResourcesTask.getProguardOutputFile());
            return proguardFiles;
        });
        if (variantData.getType() == VariantType.LIBRARY) {
            transform.keep("class **.R");
            transform.keep("class **.R$*");
        }
        if (variantData.getVariantConfiguration().isTestCoverageEnabled()) {
            transform.keep("class com.vladium.** {*;}");
            transform.keep("class org.jacoco.** {*;}");
            transform.keep("interface org.jacoco.** {*;}");
            transform.dontwarn("org.jacoco.**");
        }
    }

    public void createReportTasks(TaskFactory tasks, List<BaseVariantData<? extends BaseVariantOutputData>> variantDataList) {
        this.androidTasks.create(tasks, "androidDependencies", DependencyReportTask.class, task -> {
            task.setDescription("Displays the Android dependencies of the project.");
            task.setVariants(variantDataList);
            task.setGroup(ANDROID_GROUP);
        });
        this.androidTasks.create(tasks, "signingReport", SigningReportTask.class, task -> {
            task.setDescription("Displays the signing info for each variant.");
            task.setVariants(variantDataList);
            task.setGroup(ANDROID_GROUP);
        });
    }

    public void createAnchorTasks(TaskFactory tasks, VariantScope scope) {
        this.createPreBuildTasks(tasks, scope);
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setSourceGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Sources"), Task.class, task -> {
            variantData.sourceGenTask = task;
        }));
        scope.setResourceGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Resources"), Task.class, task -> {
            variantData.resourceGenTask = task;
        }));
        scope.setAssetGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Assets"), Task.class, task -> {
            variantData.assetGenTask = task;
        }));
        if (!variantData.getType().isForTesting() && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            scope.setCoverageReportTask(this.androidTasks.create(tasks, scope.getTaskName("create", "CoverageReport"), Task.class, task -> {
                task.setGroup("verification");
                task.setDescription(String.format("Creates test coverage reports for the %s variant.", variantData.getName()));
            }));
        }
        this.createCompileAnchorTask(tasks, scope);
    }

    private void createPreBuildTasks(TaskFactory tasks, VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setPreBuildTask(this.androidTasks.create(tasks, scope.getTaskName("pre", "Build"), (Action<Task>)((Action)task -> {
            variantData.preBuildTask = task;
        })));
        scope.getPreBuildTask().dependsOn(tasks, MAIN_PREBUILD);
        if (this.isMinifyEnabled(scope)) {
            scope.getPreBuildTask().dependsOn(tasks, EXTRACT_PROGUARD_FILES);
        }
        VariantDependencies configurationDependencies = variantData.getVariantDependency();
        AndroidTask<PrepareDependenciesTask> prepareDependenciesTask = this.androidTasks.create(tasks, new PrepareDependenciesTask.ConfigAction(scope, configurationDependencies));
        scope.setPrepareDependenciesTask(prepareDependenciesTask);
        prepareDependenciesTask.dependsOn(tasks, scope.getPreBuildTask());
        this.dependencyManager.addDependenciesToPrepareTask(tasks, variantData, prepareDependenciesTask);
    }

    private void createCompileAnchorTask(TaskFactory tasks, final VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setCompileTask(this.androidTasks.create(tasks, new TaskConfigAction<Task>(){

            @Override
            public String getName() {
                return scope.getTaskName("compile", "Sources");
            }

            @Override
            public Class<Task> getType() {
                return Task.class;
            }

            @Override
            public void execute(Task task) {
                variantData.compileTask = task;
                variantData.compileTask.setGroup(TaskManager.BUILD_GROUP);
            }
        }));
        scope.getAssembleTask().dependsOn(tasks, scope.getCompileTask());
    }

    public void createCheckManifestTask(TaskFactory tasks, VariantScope scope) {
        scope.setCheckManifestTask(this.androidTasks.create(tasks, this.getCheckManifestConfig(scope)));
        scope.getCheckManifestTask().dependsOn(tasks, scope.getPreBuildTask());
        scope.getPrepareDependenciesTask().dependsOn(tasks, scope.getCheckManifestTask());
    }

    protected CheckManifest.ConfigAction getCheckManifestConfig(VariantScope scope) {
        return new CheckManifest.ConfigAction(scope, false);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public AndroidTaskRegistry getAndroidTasks() {
        return this.androidTasks;
    }

    public void addDataBindingDependenciesIfNecessary(DataBindingOptions options) {
        if (!options.isEnabled()) {
            return;
        }
        String version = (String)Objects.firstNonNull((Object)options.getVersion(), (Object)this.dataBindingBuilder.getCompilerVersion());
        this.project.getDependencies().add("compile", (Object)("com.android.databinding:library:" + this.dataBindingBuilder.getLibraryVersion(version)));
        this.project.getDependencies().add("compile", (Object)("com.android.databinding:baseLibrary:" + this.dataBindingBuilder.getBaseLibraryVersion(version)));
        this.project.getDependencies().add("provided", (Object)("com.android.databinding:compiler:" + version));
        if (options.getAddDefaultAdapters()) {
            this.project.getDependencies().add("compile", (Object)("com.android.databinding:adapters:" + this.dataBindingBuilder.getBaseAdaptersVersion(version)));
        }
    }

    protected static enum IncrementalMode {
        NONE,
        FULL,
        LOCAL_JAVA_ONLY,
        LOCAL_RES_ONLY;

    }
}

