/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.builder.core.SyncIssueHandler;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.SkippableLibrary;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.SyncIssue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionIdentifier;

public class DependencyChecker
implements SyncIssueHandler {
    private final String projectName;
    private final String variantName;
    private SyncIssueHandler syncIssueHandler;
    private VariantType variantType;
    private final VariantType testedVariantType;
    private final List<SyncIssue> syncIssues = Lists.newArrayList();
    private final Map<ModuleVersionIdentifier, Integer> legacyApiLevels = Maps.newHashMap();

    public DependencyChecker(String projectName, String variantName, SyncIssueHandler syncIssueHandler, VariantType variantType, VariantType testedVariantType) {
        this.projectName = projectName;
        this.variantName = variantName;
        this.syncIssueHandler = syncIssueHandler;
        this.variantType = variantType;
        this.testedVariantType = testedVariantType;
    }

    public Map<ModuleVersionIdentifier, Integer> getLegacyApiLevels() {
        return this.legacyApiLevels;
    }

    public List<SyncIssue> getSyncIssues() {
        return this.syncIssues;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public void validate(DependencyContainer compileDependencies, DependencyContainer packagedDependencies, VariantDependencies testedVariantDeps) {
        Map<String, String> testedMap = DependencyChecker.computeTestedDependencyMap(testedVariantDeps);
        this.compareAndroidDependencies((List<AndroidLibrary>)compileDependencies.getAndroidDependencies(), (List<AndroidLibrary>)packagedDependencies.getAndroidDependencies(), testedMap);
        this.compareJavaDependencies((List<JavaLibrary>)compileDependencies.getJarDependencies(), (List<JavaLibrary>)packagedDependencies.getJarDependencies(), (List<AndroidLibrary>)compileDependencies.getAndroidDependencies(), (List<AndroidLibrary>)packagedDependencies.getAndroidDependencies(), testedMap);
    }

    public boolean checkForExclusion(ModuleVersionIdentifier id) {
        String group = id.getGroup();
        String name = id.getName();
        String version = id.getVersion();
        if ("com.google.android".equals(group) && "android".equals(name)) {
            int moduleLevel = DependencyChecker.getApiLevelFromMavenArtifact(version);
            this.legacyApiLevels.put(id, moduleLevel);
            this.handleIssue(id.toString(), 14, 1, String.format("Ignoring Android API artifact %s for %s", id, this.variantName));
            return true;
        }
        if (this.variantType == VariantType.UNIT_TEST) {
            return false;
        }
        if ("org.apache.httpcomponents".equals(group) && "httpclient".equals(name) || "xpp3".equals(group) && name.equals("xpp3") || "commons-logging".equals(group) && "commons-logging".equals(name) || "xerces".equals(group) && "xmlParserAPIs".equals(name) || "org.json".equals(group) && "json".equals(name) || "org.khronos".equals(group) && "opengl-api".equals(name)) {
            this.handleIssue(id.toString(), 15, 1, String.format("WARNING: Dependency %s is ignored for %s as it may be conflicting with the internal version provided by Android.\n         In case of problem, please repackage it with jarjar to change the class packages", id, this.variantName));
            return true;
        }
        return false;
    }

    private static int getApiLevelFromMavenArtifact(String version) {
        switch (version) {
            case "1.5_r3": 
            case "1.5_r4": {
                return 3;
            }
            case "1.6_r2": {
                return 4;
            }
            case "2.1_r1": 
            case "2.1.2": {
                return 7;
            }
            case "2.2.1": {
                return 8;
            }
            case "2.3.1": {
                return 9;
            }
            case "2.3.3": {
                return 10;
            }
            case "4.0.1.2": {
                return 14;
            }
            case "4.1.1.4": {
                return 15;
            }
        }
        return -1;
    }

    private void compareAndroidDependencies(List<AndroidLibrary> compileLibs, List<AndroidLibrary> packageLibs, Map<String, String> testedMap) {
        Map<String, SkippableLibrary> compileMap = DependencyChecker.computeAndroidDependencyMap(compileLibs);
        Map<String, SkippableLibrary> packageMap = DependencyChecker.computeAndroidDependencyMap(packageLibs);
        for (String coordinateKey : compileMap.keySet()) {
            SkippableLibrary compileLib = compileMap.get(coordinateKey);
            SkippableLibrary packageMatch = packageMap.get(coordinateKey);
            MavenCoordinates resolvedCoordinates = compileLib.getResolvedCoordinates();
            if (packageMatch != null) {
                this.skipTestDependency(packageMatch, testedMap);
                packageMap.remove(coordinateKey);
                if (resolvedCoordinates.getVersion().equals(packageMatch.getResolvedCoordinates().getVersion())) continue;
                this.handleIssue(coordinateKey, 9, 2, String.format("Conflict with dependency '%s'. Resolved versions for compilation (%s) and packaging (%s) differ. This can generate runtime errors due to mismatched resources.", coordinateKey, resolvedCoordinates.getVersion(), packageMatch.getResolvedCoordinates().getVersion()));
                continue;
            }
            if (compileLib.isSkipped() || this.variantType == VariantType.LIBRARY || this.testedVariantType == VariantType.LIBRARY && this.variantType.isForTesting()) continue;
            this.handleIssue(resolvedCoordinates.toString(), 7, 2, String.format("Project %s: Provided dependencies can only be jars. %s is an Android Library.", this.projectName, resolvedCoordinates.toString()));
        }
        for (SkippableLibrary packageOnlyLib : packageMap.values()) {
            MavenCoordinates packagedCoords = packageOnlyLib.getResolvedCoordinates();
            this.handleIssue(packagedCoords.toString(), 6, 2, String.format("Project %s: apk-only dependencies can only be jars. %s is an Android Library.", this.projectName, packagedCoords));
        }
    }

    private void compareJavaDependencies(List<JavaLibrary> compileJars, List<JavaLibrary> packageJars, List<AndroidLibrary> compileLibs, List<AndroidLibrary> packageLibs, Map<String, String> testedMap) {
        Map<String, SkippableLibrary> compileMap = DependencyChecker.computeJavaDependencyMap(compileJars, compileLibs);
        Map<String, SkippableLibrary> packageMap = DependencyChecker.computeJavaDependencyMap(packageJars, packageLibs);
        for (String coordinateKey : compileMap.keySet()) {
            SkippableLibrary packageMatch = packageMap.get(coordinateKey);
            if (packageMatch == null) continue;
            this.skipTestDependency(packageMatch, testedMap);
            packageMap.remove(coordinateKey);
        }
    }

    private void skipTestDependency(SkippableLibrary library, Map<String, String> testedMap) {
        if (testedMap.isEmpty()) {
            return;
        }
        MavenCoordinates coordinates = library.getResolvedCoordinates();
        String testedVersion = testedMap.get(DependencyChecker.computeVersionLessCoordinateKey(coordinates));
        if (testedVersion == null) {
            return;
        }
        library.skip();
        if (!testedVersion.equals(coordinates.getVersion())) {
            String artifactInfo = coordinates.getGroupId() + ":" + coordinates.getArtifactId();
            this.handleIssue(artifactInfo, 9, 2, String.format("Conflict with dependency '%s'. Resolved versions for app (%s) and test app (%s) differ. See http://g.co/androidstudio/app-test-app-conflict for details.", artifactInfo, testedVersion, coordinates.getVersion()));
        }
    }

    private static Map<String, String> computeTestedDependencyMap(VariantDependencies testedVariantDeps) {
        if (testedVariantDeps == null) {
            return ImmutableMap.of();
        }
        DependencyContainer packageDependencies = testedVariantDeps.getPackageDependencies();
        ImmutableList testedJars = packageDependencies.getJarDependencies();
        ImmutableList testedLibs = packageDependencies.getAndroidDependencies();
        HashMap map = Maps.newHashMapWithExpectedSize((int)(testedJars.size() + testedLibs.size()));
        DependencyChecker.fillTestedDependencyMapWithJars((Collection<? extends JavaLibrary>)testedJars, map);
        DependencyChecker.fillTestedDependencyMapWithAars((List<? extends AndroidLibrary>)testedLibs, map);
        return map;
    }

    private static void fillTestedDependencyMapWithJars(Collection<? extends JavaLibrary> dependencies, Map<String, String> map) {
        for (JavaLibrary javaLibrary : dependencies) {
            if (javaLibrary.getProject() == null) {
                MavenCoordinates coordinates = javaLibrary.getResolvedCoordinates();
                map.put(DependencyChecker.computeVersionLessCoordinateKey(coordinates), coordinates.getVersion());
            }
            DependencyChecker.fillTestedDependencyMapWithJars(javaLibrary.getDependencies(), map);
        }
    }

    private static void fillTestedDependencyMapWithAars(List<? extends AndroidLibrary> dependencies, Map<String, String> map) {
        for (AndroidLibrary androidLibrary : dependencies) {
            if (androidLibrary.getProject() == null) {
                MavenCoordinates coordinates = androidLibrary.getResolvedCoordinates();
                map.put(DependencyChecker.computeVersionLessCoordinateKey(coordinates), coordinates.getVersion());
            }
            DependencyChecker.fillTestedDependencyMapWithAars(androidLibrary.getLibraryDependencies(), map);
            DependencyChecker.fillTestedDependencyMapWithJars(androidLibrary.getJavaDependencies(), map);
        }
    }

    private static Map<String, SkippableLibrary> computeAndroidDependencyMap(List<AndroidLibrary> androidDependencies) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)androidDependencies.size());
        DependencyChecker.fillDependencyMapWithAars(androidDependencies, map, true, false);
        return map;
    }

    private static Map<String, SkippableLibrary> computeJavaDependencyMap(List<JavaLibrary> javaDependencies, List<AndroidLibrary> androidDependencies) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)(javaDependencies.size() + androidDependencies.size()));
        DependencyChecker.fillDependencyMapWithJars(javaDependencies, map);
        DependencyChecker.fillDependencyMapWithAars(androidDependencies, map, false, true);
        return map;
    }

    private static void fillDependencyMapWithJars(Collection<? extends JavaLibrary> dependencies, Map<String, SkippableLibrary> map) {
        for (JavaLibrary javaLibrary : dependencies) {
            if (javaLibrary.getProject() != null) {
                map.put(javaLibrary.getProject(), (SkippableLibrary)javaLibrary);
            } else {
                MavenCoordinates coordinates = javaLibrary.getResolvedCoordinates();
                map.put(DependencyChecker.computeVersionLessCoordinateKey(coordinates), (SkippableLibrary)javaLibrary);
            }
            DependencyChecker.fillDependencyMapWithJars(javaLibrary.getDependencies(), map);
        }
    }

    private static void fillDependencyMapWithAars(List<? extends AndroidLibrary> dependencies, Map<String, SkippableLibrary> map, boolean includeAars, boolean includeJars) {
        for (AndroidLibrary androidLibrary : dependencies) {
            if (includeAars) {
                if (androidLibrary.getProject() != null) {
                    map.put(androidLibrary.getProject(), (SkippableLibrary)androidLibrary);
                } else {
                    MavenCoordinates coordinates = androidLibrary.getResolvedCoordinates();
                    map.put(DependencyChecker.computeVersionLessCoordinateKey(coordinates), (SkippableLibrary)androidLibrary);
                }
            }
            if (includeAars) {
                DependencyChecker.fillDependencyMapWithAars(androidLibrary.getLibraryDependencies(), map, true, includeJars);
            }
            if (!includeJars) continue;
            DependencyChecker.fillDependencyMapWithJars(androidLibrary.getJavaDependencies(), map);
        }
    }

    public static String computeVersionLessCoordinateKey(MavenCoordinates coordinates) {
        StringBuilder sb = new StringBuilder(coordinates.getGroupId());
        sb.append(':').append(coordinates.getArtifactId());
        if (coordinates.getClassifier() != null) {
            sb.append(':').append(coordinates.getClassifier());
        }
        return sb.toString();
    }

    public SyncIssue handleIssue(String data, int type, int severity, String msg) {
        SyncIssue issue = this.syncIssueHandler.handleIssue(data, type, severity, msg);
        this.syncIssues.add(issue);
        return issue;
    }
}

