/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.build.gradle.internal.incremental.InstantRunMethodVerifier;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.google.common.base.Objects;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class InstantRunVerifier {
    private static final Comparator<MethodNode> METHOD_COMPARATOR = new MethodNodeComparator();
    static final Comparator<AnnotationNode> ANNOTATION_COMPARATOR = new AnnotationNodeComparator();
    private static final Comparator<Object> OBJECT_COMPARATOR = Objects::equal;
    private static final Comparator<String> STRING_COMPARATOR = Objects::equal;
    private static final Comparator<Object> OBJECT_OR_ANNOTATION_NODE_COMPARATOR = (first, second) -> {
        if (first instanceof AnnotationNode && second instanceof AnnotationNode) {
            return ANNOTATION_COMPARATOR.areEqual((AnnotationNode)first, (AnnotationNode)second);
        }
        return OBJECT_COMPARATOR.areEqual(first, second);
    };

    private InstantRunVerifier() {
    }

    public static InstantRunVerifierStatus run(File original, File updated) throws IOException {
        return InstantRunVerifier.run(new ClassBytesFileProvider(original), new ClassBytesFileProvider(updated));
    }

    public static InstantRunVerifierStatus run(ClassBytesProvider original, ClassBytesProvider updated) throws IOException {
        InstantRunVerifierStatus fieldChange;
        ClassNode originalClass = InstantRunVerifier.loadClass(original);
        ClassNode updatedClass = InstantRunVerifier.loadClass(updated);
        if (!originalClass.superName.equals(updatedClass.superName)) {
            return InstantRunVerifierStatus.PARENT_CLASS_CHANGED;
        }
        if (InstantRunVerifier.diffList(originalClass.interfaces, updatedClass.interfaces, STRING_COMPARATOR) != Diff.NONE) {
            return InstantRunVerifierStatus.IMPLEMENTED_INTERFACES_CHANGE;
        }
        if (InstantRunVerifier.diffList(originalClass.visibleAnnotations, updatedClass.visibleAnnotations, ANNOTATION_COMPARATOR) != Diff.NONE) {
            return InstantRunVerifierStatus.CLASS_ANNOTATION_CHANGE;
        }
        List invisibleAnnotations = originalClass.invisibleAnnotations;
        if (invisibleAnnotations != null) {
            for (AnnotationNode annotationNode : invisibleAnnotations) {
                if (!annotationNode.desc.equals(IncrementalVisitor.DISABLE_ANNOTATION_TYPE.getDescriptor())) continue;
                return InstantRunVerifierStatus.INSTANT_RUN_DISABLED;
            }
        }
        if ((fieldChange = InstantRunVerifier.verifyFields(originalClass, updatedClass)) != InstantRunVerifierStatus.COMPATIBLE) {
            return fieldChange;
        }
        return InstantRunVerifier.verifyMethods(originalClass, updatedClass);
    }

    private static InstantRunVerifierStatus verifyFields(ClassNode originalClass, ClassNode updatedClass) {
        String name;
        int index;
        Diff diff = InstantRunVerifier.diffList(originalClass.fields, updatedClass.fields, new Comparator<FieldNode>(){

            @Override
            public boolean areEqual(FieldNode first, FieldNode second) {
                if (first == null && second == null) {
                    return true;
                }
                if (first == null || second == null) {
                    return true;
                }
                return first.name.equals(second.name) && first.desc.equals(second.desc) && first.access == second.access && Objects.equal((Object)first.value, (Object)second.value);
            }
        });
        if (diff != Diff.NONE && (index = (name = originalClass.name).lastIndexOf(47)) != -1 && name.startsWith("R$", index + 1) && (originalClass.access & 1) != 0 && (originalClass.access & 0x10) != 0 && originalClass.outerClass == null && originalClass.interfaces.isEmpty() && originalClass.superName.equals("java/lang/Object") && name.length() > 3 && Character.isLowerCase(name.charAt(2))) {
            return InstantRunVerifierStatus.R_CLASS_CHANGE;
        }
        switch (diff) {
            case NONE: {
                return InstantRunVerifierStatus.COMPATIBLE;
            }
            case ADDITION: {
                return InstantRunVerifierStatus.FIELD_ADDED;
            }
            case REMOVAL: {
                return InstantRunVerifierStatus.FIELD_REMOVED;
            }
            case CHANGE: {
                return InstantRunVerifierStatus.FIELD_TYPE_CHANGE;
            }
        }
        throw new RuntimeException("Unhandled action : " + (Object)((Object)diff));
    }

    private static InstantRunVerifierStatus verifyMethods(ClassNode originalClass, ClassNode updatedClass) {
        ArrayList nonVisitedMethodsOnUpdatedClass = new ArrayList(updatedClass.methods);
        for (MethodNode methodNode : originalClass.methods) {
            MethodNode updatedMethod = InstantRunVerifier.findMethod(updatedClass, methodNode.name, methodNode.desc);
            if (updatedMethod == null) {
                return methodNode.name.equals("<clinit>") ? InstantRunVerifierStatus.COMPATIBLE : InstantRunVerifierStatus.METHOD_DELETED;
            }
            nonVisitedMethodsOnUpdatedClass.remove(updatedMethod);
            InstantRunVerifierStatus change = methodNode.name.equals("<clinit>") ? InstantRunVerifier.visitClassInitializer(methodNode, updatedMethod) : InstantRunVerifier.verifyMethod(methodNode, updatedMethod);
            if (change == InstantRunVerifierStatus.COMPATIBLE) continue;
            return change;
        }
        if (!nonVisitedMethodsOnUpdatedClass.isEmpty()) {
            return InstantRunVerifierStatus.METHOD_ADDED;
        }
        return InstantRunVerifierStatus.COMPATIBLE;
    }

    private static InstantRunVerifierStatus visitClassInitializer(MethodNode originalClassInitializer, MethodNode updateClassInitializer) {
        return METHOD_COMPARATOR.areEqual(originalClassInitializer, updateClassInitializer) ? InstantRunVerifierStatus.COMPATIBLE : InstantRunVerifierStatus.STATIC_INITIALIZER_CHANGE;
    }

    private static InstantRunVerifierStatus verifyMethod(MethodNode methodNode, MethodNode updatedMethod) {
        boolean usingBlackListedAPIs;
        if (InstantRunVerifier.diffList(methodNode.visibleAnnotations, updatedMethod.visibleAnnotations, new AnnotationNodeComparator()) != Diff.NONE) {
            return InstantRunVerifierStatus.METHOD_ANNOTATION_CHANGE;
        }
        boolean disabledMethod = false;
        List invisibleAnnotations = methodNode.invisibleAnnotations;
        if (invisibleAnnotations != null) {
            for (AnnotationNode originalMethodAnnotation : invisibleAnnotations) {
                if (!originalMethodAnnotation.desc.equals(IncrementalVisitor.DISABLE_ANNOTATION_TYPE.getDescriptor())) continue;
                disabledMethod = true;
            }
        }
        boolean bl = usingBlackListedAPIs = InstantRunMethodVerifier.verifyMethod(updatedMethod) != InstantRunVerifierStatus.COMPATIBLE;
        if ((disabledMethod || usingBlackListedAPIs) && !METHOD_COMPARATOR.areEqual(methodNode, updatedMethod)) {
            return disabledMethod ? InstantRunVerifierStatus.INSTANT_RUN_DISABLED : InstantRunVerifierStatus.REFLECTION_USED;
        }
        return InstantRunVerifierStatus.COMPATIBLE;
    }

    private static MethodNode findMethod(ClassNode classNode, String name, String desc) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(name) || (desc != null || methodNode.desc != null) && !methodNode.desc.equals(desc)) continue;
            return methodNode;
        }
        return null;
    }

    static <T> Diff diffList(List<T> one, List<T> two, Comparator<T> comparator) {
        T commonElement;
        if (one == null && two == null) {
            return Diff.NONE;
        }
        if (one == null) {
            return Diff.ADDITION;
        }
        if (two == null) {
            return Diff.REMOVAL;
        }
        ArrayList<T> copyOfOne = new ArrayList<T>(one);
        ArrayList<T> copyOfTwo = new ArrayList<T>(two);
        for (T elementOfTwo : two) {
            commonElement = InstantRunVerifier.getElementOf(copyOfOne, elementOfTwo, comparator);
            if (commonElement == null) continue;
            copyOfOne.remove(commonElement);
        }
        for (T elementOfOne : one) {
            commonElement = InstantRunVerifier.getElementOf(copyOfTwo, elementOfOne, comparator);
            if (commonElement == null) continue;
            copyOfTwo.remove(commonElement);
        }
        if (!copyOfOne.isEmpty() && copyOfOne.size() == copyOfTwo.size()) {
            return Diff.CHANGE;
        }
        if (!copyOfOne.isEmpty()) {
            return Diff.REMOVAL;
        }
        return copyOfTwo.isEmpty() ? Diff.NONE : Diff.ADDITION;
    }

    public static <T> T getElementOf(List<T> list, T element, Comparator<T> comparator) {
        for (T elementOfList : list) {
            if (!comparator.areEqual(elementOfList, element)) continue;
            return elementOfList;
        }
        return null;
    }

    static ClassNode loadClass(ClassBytesProvider classFile) throws IOException {
        byte[] classBytes = classFile.load();
        ClassReader classReader = new ClassReader(classBytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        return classNode;
    }

    private static List<AnnotationEntryAndValue> splitToEntries(List values) {
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationEntryAndValue> result = new ArrayList<AnnotationEntryAndValue>();
        for (int i = 0; i < values.size(); i += 2) {
            String name = (String)values.get(i);
            Object value = values.get(i + 1);
            result.add(new AnnotationEntryAndValue(name, value));
        }
        return result;
    }

    static class AnnotationEntryAndValue {
        private final String name;
        private final Object value;

        AnnotationEntryAndValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AnnotationEntryAndValue)) {
                return false;
            }
            AnnotationEntryAndValue other = (AnnotationEntryAndValue)obj;
            if (!STRING_COMPARATOR.areEqual(this.name, other.name)) {
                return false;
            }
            Object otherValue = other.value;
            if (this.value instanceof byte[] && otherValue instanceof byte[]) {
                return Arrays.equals((byte[])this.value, (byte[])otherValue);
            }
            if (this.value instanceof boolean[] && otherValue instanceof boolean[]) {
                return Arrays.equals((boolean[])this.value, (boolean[])otherValue);
            }
            if (this.value instanceof short[] && otherValue instanceof short[]) {
                return Arrays.equals((short[])this.value, (short[])otherValue);
            }
            if (this.value instanceof char[] && otherValue instanceof char[]) {
                return Arrays.equals((char[])this.value, (char[])otherValue);
            }
            if (this.value instanceof int[] && otherValue instanceof int[]) {
                return Arrays.equals((int[])this.value, (int[])otherValue);
            }
            if (this.value instanceof long[] && otherValue instanceof long[]) {
                return Arrays.equals((long[])this.value, (long[])otherValue);
            }
            if (this.value instanceof float[] && otherValue instanceof float[]) {
                return Arrays.equals((float[])this.value, (float[])otherValue);
            }
            if (this.value instanceof double[] && otherValue instanceof double[]) {
                return Arrays.equals((double[])this.value, (double[])otherValue);
            }
            if (this.value instanceof String[] && otherValue instanceof String[]) {
                return Arrays.equals((String[])this.value, (String[])otherValue);
            }
            if (this.value instanceof List && otherValue instanceof List) {
                List list = (List)this.value;
                List otherList = (List)otherValue;
                if (list.size() != otherList.size()) {
                    return false;
                }
                Iterator iterator = list.iterator();
                Iterator otherIterator = otherList.iterator();
                while (iterator.hasNext() && otherIterator.hasNext()) {
                    if (OBJECT_OR_ANNOTATION_NODE_COMPARATOR.areEqual(iterator.next(), otherIterator.next())) continue;
                    return false;
                }
                return true;
            }
            return OBJECT_OR_ANNOTATION_NODE_COMPARATOR.areEqual(this.value, otherValue);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class AnnotationNodeComparator
    implements Comparator<AnnotationNode> {
        @Override
        public boolean areEqual(AnnotationNode first, AnnotationNode second) {
            List secondEntries;
            if (first == null || second == null) {
                return first == second;
            }
            if (!STRING_COMPARATOR.areEqual(first.desc, second.desc)) {
                return false;
            }
            List firstEntries = InstantRunVerifier.splitToEntries(first.values);
            return InstantRunVerifier.diffList(firstEntries, secondEntries = InstantRunVerifier.splitToEntries(second.values), OBJECT_COMPARATOR) == Diff.NONE;
        }
    }

    private static class VerifierTextifier
    extends Textifier {
        protected VerifierTextifier() {
            super(327680);
        }

        public void visitLineNumber(int i, Label label) {
        }
    }

    private static class MethodNodeComparator
    implements Comparator<MethodNode> {
        private MethodNodeComparator() {
        }

        @Override
        public boolean areEqual(MethodNode first, MethodNode second) {
            if (first == null && second == null) {
                return true;
            }
            if (first == null || second == null) {
                return false;
            }
            if (!first.name.equals(second.name) || !first.desc.equals(second.desc)) {
                return false;
            }
            VerifierTextifier firstMethodTextifier = new VerifierTextifier();
            VerifierTextifier secondMethodTextifier = new VerifierTextifier();
            first.accept((MethodVisitor)new TraceMethodVisitor((Printer)firstMethodTextifier));
            second.accept((MethodVisitor)new TraceMethodVisitor((Printer)secondMethodTextifier));
            StringWriter firstText = new StringWriter();
            StringWriter secondText = new StringWriter();
            firstMethodTextifier.print(new PrintWriter(firstText));
            secondMethodTextifier.print(new PrintWriter(secondText));
            return firstText.toString().equals(secondText.toString());
        }
    }

    private static interface Comparator<T> {
        public boolean areEqual(T var1, T var2);
    }

    static enum Diff {
        NONE,
        ADDITION,
        REMOVAL,
        CHANGE;

    }

    public static class ClassBytesJarEntryProvider
    implements ClassBytesProvider {
        private final JarFile jarFile;
        private final JarEntry jarEntry;

        public ClassBytesJarEntryProvider(JarFile jarFile, JarEntry jarEntry) {
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
        }

        @Override
        public byte[] load() throws IOException {
            InputStream is = this.jarFile.getInputStream(this.jarEntry);
            try {
                ByteStreams.toByteArray((InputStream)is);
            }
            finally {
                Closeables.close((Closeable)is, (boolean)false);
            }
            return new byte[0];
        }
    }

    public static class ClassBytesFileProvider
    implements ClassBytesProvider {
        private final File file;

        public ClassBytesFileProvider(File file) {
            this.file = file;
        }

        @Override
        public byte[] load() throws IOException {
            return Files.toByteArray((File)this.file);
        }

        public File getFile() {
            return this.file;
        }
    }

    public static interface ClassBytesProvider {
        public byte[] load() throws IOException;
    }
}

