/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunAnalyticsHelper;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.builder.profile.ProcessRecorder;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;

public class InstantRunWrapperTask
extends BaseTask {
    File buildInfoFile;
    String buildId;
    File tmpBuildInfoFile;
    Logger logger;
    InstantRunBuildContext instantRunBuildContext;

    @TaskAction
    public void executeAction() {
        this.instantRunBuildContext.close();
        try {
            String xml = this.instantRunBuildContext.toXml();
            if (this.logger.isEnabled(LogLevel.DEBUG)) {
                this.logger.debug("build-id $1$l, build-info.xml : %2$s", (Object)this.instantRunBuildContext.getBuildId(), (Object)xml);
            }
            Files.createParentDirs((File)this.buildInfoFile);
            Files.write((CharSequence)xml, (File)this.buildInfoFile, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception while saving build-info.xml : %s", e.getMessage()));
        }
        if (this.tmpBuildInfoFile.exists() && !this.tmpBuildInfoFile.delete()) {
            this.logger.warn(String.format("Cannot delete %1$s", this.tmpBuildInfoFile));
        }
        ProcessRecorder.getGlobalProperties().setInstantRunStatus(InstantRunAnalyticsHelper.generateAnalyticsProto(this.instantRunBuildContext));
    }

    public static class ConfigAction
    implements TaskConfigAction<InstantRunWrapperTask> {
        private final String taskName;
        private final InstantRunVariantScope variantScope;
        private final Logger logger;

        public static File getBuildInfoFile(InstantRunVariantScope scope) {
            return new File(scope.getRestartDexOutputFolder(), "build-info.xml");
        }

        public static File getTmpBuildInfoFile(InstantRunVariantScope scope) {
            return new File(scope.getRestartDexOutputFolder(), "tmp-build-info.xml");
        }

        public ConfigAction(InstantRunVariantScope scope, Logger logger) {
            this.taskName = scope.getTransformVariantScope().getTaskName("buildInfoGenerator");
            this.variantScope = scope;
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<InstantRunWrapperTask> getType() {
            return InstantRunWrapperTask.class;
        }

        @Override
        public void execute(InstantRunWrapperTask task) {
            task.setDescription("InstantRun task to build incremental artifacts");
            task.setVariantName(this.variantScope.getFullVariantName());
            task.buildInfoFile = ConfigAction.getBuildInfoFile(this.variantScope);
            task.tmpBuildInfoFile = ConfigAction.getTmpBuildInfoFile(this.variantScope);
            task.instantRunBuildContext = this.variantScope.getInstantRunBuildContext();
            task.logger = this.logger;
            task.buildId = String.valueOf(task.instantRunBuildContext.getBuildId());
        }
    }
}

