/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.Toolchain;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkR11Info;
import com.android.build.gradle.internal.ndk.NdkR12Info;
import com.android.build.gradle.internal.ndk.NdkR13Info;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.ndk.StlNativeToolSpecification;
import com.android.repository.Revision;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Properties;

public class NdkHandler {
    private String platformVersion;
    private String compileSdkVersion;
    private final Toolchain toolchain;
    private final String toolchainVersion;
    private final File ndkDirectory;
    private final NdkInfo ndkInfo;
    private static final int LATEST_SUPPORTED_VERSION = 13;

    public NdkHandler(File projectDir, String platformVersion, String toolchainName, String toolchainVersion) {
        this.toolchain = Toolchain.getByName(toolchainName);
        this.toolchainVersion = toolchainVersion;
        this.platformVersion = platformVersion;
        this.ndkDirectory = NdkHandler.findNdkDirectory(projectDir);
        if (this.ndkDirectory == null) {
            this.ndkInfo = null;
        } else {
            Revision revision = NdkHandler.findRevision(this.ndkDirectory);
            if (revision == null) {
                this.ndkInfo = new DefaultNdkInfo(this.ndkDirectory);
            } else if (revision.getMajor() > 13) {
                this.ndkInfo = new NdkR13Info(this.ndkDirectory);
            } else {
                switch (revision.getMajor()) {
                    case 13: {
                        this.ndkInfo = new NdkR13Info(this.ndkDirectory);
                        break;
                    }
                    case 12: {
                        this.ndkInfo = new NdkR12Info(this.ndkDirectory);
                        break;
                    }
                    case 11: {
                        this.ndkInfo = new NdkR11Info(this.ndkDirectory);
                        break;
                    }
                    default: {
                        this.ndkInfo = new DefaultNdkInfo(this.ndkDirectory);
                    }
                }
            }
        }
    }

    private static Properties readProperties(File file) {
        Properties properties = new Properties();
        try (FileInputStream fis2 = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)fis2, Charsets.UTF_8);){
            properties.load(reader);
        }
        catch (FileNotFoundException fis2) {
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read %1$s.", file), e);
        }
        return properties;
    }

    public static Revision findRevision(File ndkDirectory) {
        if (ndkDirectory == null) {
            return null;
        }
        File sourceProperties = new File(ndkDirectory, "source.properties");
        if (!sourceProperties.exists()) {
            return null;
        }
        Properties properties = NdkHandler.readProperties(sourceProperties);
        String version = properties.getProperty("Pkg.Revision");
        if (version != null) {
            return Revision.parseRevision((String)version);
        }
        return null;
    }

    private String getPlatformVersion() {
        if (this.platformVersion == null && this.compileSdkVersion != null) {
            Preconditions.checkNotNull((Object)this.ndkInfo);
            this.platformVersion = this.ndkInfo.findLatestPlatformVersion(this.compileSdkVersion);
        }
        return this.platformVersion;
    }

    public void setCompileSdkVersion(String compileSdkVersion) {
        this.compileSdkVersion = compileSdkVersion;
    }

    public Toolchain getToolchain() {
        return this.toolchain;
    }

    public String getToolchainVersion() {
        return this.toolchainVersion;
    }

    private static File findNdkDirectory(File projectDir) {
        File localProperties = new File(projectDir, "local.properties");
        if (localProperties.isFile()) {
            Properties properties = NdkHandler.readProperties(localProperties);
            String ndkDirProp = properties.getProperty("ndk.dir");
            if (ndkDirProp != null) {
                return new File(ndkDirProp);
            }
        } else {
            String envVar = System.getenv("ANDROID_NDK_HOME");
            if (envVar != null) {
                return new File(envVar);
            }
        }
        return null;
    }

    public File getNdkDirectory() {
        return this.ndkDirectory;
    }

    public boolean isConfigured() {
        return this.ndkDirectory != null;
    }

    private File getToolchainPath(Toolchain toolchain, String toolchainVersion, Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getToolchainPath(toolchain, toolchainVersion, abi);
    }

    public String getSysroot(Abi abi) {
        if (this.getPlatformVersion() == null) {
            return "";
        }
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getSysrootPath(abi, this.getPlatformVersion());
    }

    public String getSysroot(Abi abi, String platformVersionOverride) {
        return this.ndkDirectory + "/platforms/" + platformVersionOverride + "/arch-" + abi.getArchitecture();
    }

    private boolean supports64Bits() {
        if (this.getPlatformVersion() == null) {
            return false;
        }
        String targetString = this.getPlatformVersion().replace("android-", "");
        try {
            return Integer.parseInt(targetString) >= 20;
        }
        catch (NumberFormatException ignored) {
            return true;
        }
    }

    private String getGccToolchainVersion(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.toolchain == Toolchain.GCC && !this.toolchainVersion.isEmpty() ? this.toolchainVersion : this.ndkInfo.getDefaultToolchainVersion(Toolchain.GCC, abi);
    }

    public File getDefaultGccToolchainPath(Abi abi) {
        return this.getToolchainPath(Toolchain.GCC, this.getGccToolchainVersion(abi), abi);
    }

    public static Collection<Abi> getAbiList() {
        return ImmutableList.copyOf((Object[])Abi.values());
    }

    private static Collection<Abi> getAbiList32() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Abi abi : Abi.values()) {
            if (abi.supports64Bits()) continue;
            builder.add((Object)abi);
        }
        return builder.build();
    }

    public Collection<Abi> getSupportedAbis() {
        return this.supports64Bits() ? NdkHandler.getAbiList() : NdkHandler.getAbiList32();
    }

    public File getCCompiler(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getCCompiler(this.toolchain, this.toolchainVersion, abi);
    }

    public File getCppCompiler(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getCppCompiler(this.toolchain, this.toolchainVersion, abi);
    }

    public File getAr(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getAr(this.toolchain, this.toolchainVersion, abi);
    }

    public File getStripExecutable(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getStripExecutable(this.toolchain, this.toolchainVersion, abi);
    }

    public StlNativeToolSpecification getStlNativeToolSpecification(Stl stl, String stlVersion, Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getStlNativeToolSpecification(stl, stlVersion, abi);
    }

    public int findSuitablePlatformVersion(String abi, int minSdkVersion) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.findSuitablePlatformVersion(abi, minSdkVersion);
    }
}

