/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;

public class StreamBasedTask
extends BaseTask {
    protected Collection<TransformStream> consumedInputStreams;
    protected Collection<TransformStream> referencedInputStreams;
    protected IntermediateStream outputStream;

    @InputFiles
    public List<File> getStreamInputs() {
        ArrayList inputs = Lists.newArrayList();
        for (TransformStream s : this.consumedInputStreams) {
            inputs.addAll(s.getInputFiles());
        }
        for (TransformStream s : this.referencedInputStreams) {
            inputs.addAll(s.getInputFiles());
        }
        return inputs;
    }

    @Optional
    @OutputDirectory
    public File getStreamOutputFolder() {
        if (this.outputStream != null) {
            return (File)this.outputStream.getRootLocation().get();
        }
        return null;
    }
}

