/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class UninstallTask
extends BaseTask {
    private BaseVariantData variant;
    private int mTimeOutInMs = 0;

    public UninstallTask() {
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                UninstallTask.this.getLogger().debug("Uninstall task is always run.");
                return false;
            }
        });
    }

    @TaskAction
    public void uninstall() throws DeviceException {
        Logger logger = this.getLogger();
        String applicationId = this.variant.getApplicationId();
        logger.info("Uninstalling app: {}", (Object)applicationId);
        LoggerWrapper lifecycleLogger = new LoggerWrapper(this.getLogger(), LogLevel.LIFECYCLE);
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.getAdbExe(), this.getTimeOutInMs(), (ILogger)lifecycleLogger);
        deviceProvider.init();
        List devices = deviceProvider.getDevices();
        for (DeviceConnector device : devices) {
            device.uninstallPackage(applicationId, this.getTimeOutInMs(), this.getILogger());
            logger.lifecycle("Uninstalling {} (from {}:{}) from device '{}' ({}).", new Object[]{applicationId, this.getProject().getName(), this.variant.getVariantConfiguration().getFullName(), device.getName(), device.getSerialNumber()});
        }
        int n = devices.size();
        logger.quiet("Uninstalled {} from {} device{}.", new Object[]{applicationId, n, n == 1 ? "" : "s"});
    }

    @InputFile
    public File getAdbExe() {
        SdkInfo sdkInfo = this.getBuilder().getSdkInfo();
        if (sdkInfo == null) {
            return null;
        }
        return sdkInfo.getAdb();
    }

    public BaseVariantData getVariant() {
        return this.variant;
    }

    public void setVariant(BaseVariantData variant) {
        this.variant = variant;
    }

    @Input
    public int getTimeOutInMs() {
        return this.mTimeOutInMs;
    }

    public void setTimeOutInMs(int timeoutInMs) {
        this.mTimeOutInMs = timeoutInMs;
    }

    public static class ConfigAction
    implements TaskConfigAction<UninstallTask> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            String prefix = "uninstall";
            return prefix + StringHelper.capitalize((String)this.scope.getVariantConfiguration().getFullName());
        }

        @Override
        public Class<UninstallTask> getType() {
            return UninstallTask.class;
        }

        @Override
        public void execute(UninstallTask uninstallTask) {
            uninstallTask.setDescription("Uninstalls the " + this.scope.getVariantData().getDescription() + ".");
            uninstallTask.setGroup("Install");
            uninstallTask.setVariant(this.scope.getVariantData());
            uninstallTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            uninstallTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            uninstallTask.setTimeOutInMs(this.scope.getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs());
            ConventionMappingHelper.map((Task)uninstallTask, "adbExe", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    SdkInfo info = scope.getGlobalScope().getSdkHandler().getSdkInfo();
                    return info == null ? null : info.getAdb();
                }
            });
            ((ApkVariantData)this.scope.getVariantData()).uninstallTask = uninstallTask;
        }
    }
}

