/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.transforms.InstantRunBuildType;
import com.android.builder.core.DexByteCodeConverter;
import com.android.builder.core.DexOptions;
import com.android.builder.model.OptionalCompilationStep;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.gradle.api.logging.Logger;

public class InstantRunDex
extends Transform {
    private final Supplier<DexByteCodeConverter> dexByteCodeConverter;
    private final DexOptions dexOptions;
    private final ILogger logger;
    private final InstantRunVariantScope variantScope;

    public InstantRunDex(InstantRunVariantScope transformVariantScope, Supplier<DexByteCodeConverter> dexByteCodeConverter, DexOptions dexOptions, Logger logger) {
        this.variantScope = transformVariantScope;
        this.dexByteCodeConverter = dexByteCodeConverter;
        this.dexOptions = dexOptions;
        this.logger = new LoggerWrapper(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        File outputFolder = InstantRunBuildType.RELOAD.getOutputFolder(this.variantScope);
        boolean changesAreCompatible = this.variantScope.getInstantRunBuildContext().hasPassedVerification();
        boolean restartDexRequested = this.variantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY);
        if (!changesAreCompatible || restartDexRequested) {
            FileUtils.cleanOutputDir((File)outputFolder);
            return;
        }
        File classesJar = new File(outputFolder, "classes.jar");
        if (classesJar.exists()) {
            FileUtils.delete((File)classesJar);
        }
        Files.createParentDirs((File)classesJar);
        try (JarClassesBuilder jarClassesBuilder = this.getJarClassBuilder(classesJar);){
            for (TransformInput input : invocation.getReferencedInputs()) {
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    if (!directoryInput.getContentTypes().contains((Object)ExtendedContentType.CLASSES_ENHANCED)) continue;
                    File folder = directoryInput.getFile();
                    if (invocation.isIncremental()) {
                        for (Map.Entry entry : directoryInput.getChangedFiles().entrySet()) {
                            File file;
                            if (entry.getValue() == Status.REMOVED || !(file = (File)entry.getKey()).isFile()) continue;
                            jarClassesBuilder.add(folder, file);
                        }
                        continue;
                    }
                    FluentIterable files = FileUtils.getAllFiles((File)folder);
                    for (File inputFile : files) {
                        jarClassesBuilder.add(folder, inputFile);
                    }
                }
            }
        }
        if (jarClassesBuilder.isEmpty()) {
            FileUtils.cleanOutputDir((File)outputFolder);
            return;
        }
        ImmutableList.Builder inputFiles = ImmutableList.builder();
        inputFiles.add((Object)classesJar);
        try {
            this.variantScope.getInstantRunBuildContext().startRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_DEX);
            this.convertByteCode((List<File>)inputFiles.build(), outputFolder);
            this.variantScope.getInstantRunBuildContext().addChangedFile(InstantRunBuildContext.FileType.RELOAD_DEX, new File(outputFolder, "classes.dex"));
        }
        catch (ProcessException e) {
            throw new TransformException((Throwable)e);
        }
        finally {
            this.variantScope.getInstantRunBuildContext().stopRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_DEX);
        }
    }

    protected void convertByteCode(List<File> inputFiles, File outputFolder) throws InterruptedException, ProcessException, IOException {
        this.dexByteCodeConverter.get().convertByteCode(inputFiles, outputFolder, false, null, this.dexOptions, ((Boolean)Objects.firstNonNull((Object)this.dexOptions.getOptimize(), (Object)false)).booleanValue(), (ProcessOutputHandler)new LoggedProcessOutputHandler(this.logger));
    }

    protected JarClassesBuilder getJarClassBuilder(File outputFile) {
        return new JarClassesBuilder(outputFile);
    }

    private static void copyFileInJar(File inputDir, File inputFile, JarOutputStream jarOutputStream) throws IOException {
        String entryName = inputFile.getPath().substring(inputDir.getPath().length() + 1);
        JarEntry jarEntry = new JarEntry(entryName);
        jarOutputStream.putNextEntry(jarEntry);
        Files.copy((File)inputFile, (OutputStream)jarOutputStream);
        jarOutputStream.closeEntry();
    }

    public String getName() {
        return "instantReloadDex";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.CLASSES_ENHANCED));
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[0]);
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of((Object)"changesAreCompatible", (Object)this.variantScope.getInstantRunBuildContext().hasPassedVerification(), (Object)"restartDexRequested", (Object)this.variantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY));
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)InstantRunBuildType.RELOAD.getOutputFolder(this.variantScope));
    }

    public boolean isIncremental() {
        return true;
    }

    static class JarClassesBuilder
    implements Closeable {
        final File outputFile;
        private JarOutputStream jarOutputStream;
        boolean empty = true;

        private JarClassesBuilder(File outputFile) {
            this.outputFile = outputFile;
        }

        void add(File inputDir, File file) throws IOException {
            if (this.jarOutputStream == null) {
                this.jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile)));
            }
            this.empty = false;
            InstantRunDex.copyFileInJar(inputDir, file, this.jarOutputStream);
        }

        @Override
        public void close() throws IOException {
            if (this.jarOutputStream != null) {
                this.jarOutputStream.close();
            }
        }

        boolean isEmpty() {
            return this.empty;
        }
    }
}

