/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreAnnotationProcessorOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.JackProcessOptions;
import com.android.ide.common.process.ProcessException;
import com.android.jack.api.ConfigNotSupportedException;
import com.android.jack.api.v01.CompilationException;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.UnrecoverableException;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.StringHelper;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;

public class JackTransform
extends Transform {
    private Project project;
    private AndroidBuilder androidBuilder;
    private JackProcessOptions options;
    private boolean jackInProcess;
    private final List<ConfigurableFileTree> sourceFileTrees = Lists.newArrayList();

    public String getName() {
        return "jack";
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(Iterables.transform((Iterable)this.options.getProguardFiles(), SecondaryFile::nonIncremental));
        builder.addAll(Iterables.transform((Iterable)this.options.getJarJarRuleFiles(), SecondaryFile::nonIncremental));
        builder.addAll(Iterables.transform((Iterable)this.options.getAnnotationProcessorClassPath(), SecondaryFile::nonIncremental));
        builder.addAll(Iterables.transform(this.getSourceFiles(), SecondaryFile::incremental));
        builder.add((Object)SecondaryFile.nonIncremental((File)new File(this.androidBuilder.getTargetInfo().getBuildTools().getPath(BuildToolInfo.PathId.JACK))));
        return builder.build();
    }

    public Collection<File> getSecondaryFileOutputs() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.options.getOutputFile() != null) {
            builder.add((Object)this.options.getOutputFile());
        }
        if (this.options.getMappingFile() != null) {
            builder.add((Object)this.options.getMappingFile());
        }
        return builder.build();
    }

    public Map<String, Object> getParameterInputs() {
        HashMap params = Maps.newHashMap();
        params.put("javaResourcesFolder", this.options.getResourceDirectories());
        params.put("isDebugLog", this.options.isDebugLog());
        params.put("multiDexEnabled", this.options.isMultiDex());
        params.put("minSdkVersion", this.options.getMinSdkVersion());
        params.put("javaMaxHeapSize", this.options.getJavaMaxHeapSize());
        params.put("sourceCompatibility", this.options.getSourceCompatibility());
        params.put("buildToolsRev", this.androidBuilder.getTargetInfo().getBuildTools().getRevision().toString());
        return params;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_JACK;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_DEX;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROVIDED_ONLY, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.TESTED_CODE});
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        try {
            this.runJack(transformInvocation);
        }
        catch (ProcessException | ConfigNotSupportedException | CompilationException | ConfigurationException | UnrecoverableException | ClassNotFoundException e) {
            throw new TransformException(e);
        }
    }

    private void runJack(TransformInvocation transformInvocation) throws ProcessException, IOException, ConfigNotSupportedException, ClassNotFoundException, CompilationException, ConfigurationException, UnrecoverableException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider);
        File outDirectory = outputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
        this.options.setDexOutputDirectory(outDirectory);
        this.options.setClasspaths(TransformInputUtil.getAllFiles(transformInvocation.getReferencedInputs()));
        this.options.setImportFiles(TransformInputUtil.getAllFiles(transformInvocation.getInputs()));
        this.options.setInputFiles(this.getSourceFiles());
        this.androidBuilder.convertByteCodeUsingJack(this.options, this.jackInProcess);
    }

    private Collection<File> getSourceFiles() {
        ArrayList sourceFiles = Lists.newArrayList();
        for (ConfigurableFileTree fileTree : this.sourceFileTrees) {
            sourceFiles.addAll(fileTree.getFiles());
        }
        return sourceFiles;
    }

    public File getMappingFile() {
        return this.options.getMappingFile();
    }

    public void addSource(File sourceFolder) {
        this.sourceFileTrees.add(this.project.fileTree((Object)sourceFolder));
    }

    public JackTransform(VariantScope scope, boolean isDebugLog, boolean compileJavaSources) {
        this.options = new JackProcessOptions();
        this.options.setDebugLog(isDebugLog);
        GlobalScope globalScope = scope.getGlobalScope();
        this.androidBuilder = globalScope.getAndroidBuilder();
        this.project = globalScope.getProject();
        if (compileJavaSources) {
            this.sourceFileTrees.addAll(scope.getVariantData().getJavaSources());
        }
        GradleVariantConfiguration config = scope.getVariantData().getVariantConfiguration();
        this.options.setJavaMaxHeapSize(globalScope.getExtension().getDexOptions().getJavaMaxHeapSize());
        this.options.setJumboMode(globalScope.getExtension().getDexOptions().getJumboMode());
        boolean isDebuggable = ((CoreBuildType)scope.getVariantConfiguration().getBuildType()).isDebuggable();
        this.options.setDebuggable(isDebuggable);
        this.options.setDexOptimize(((Boolean)Objects.firstNonNull((Object)globalScope.getExtension().getDexOptions().getOptimize(), (Object)(!isDebuggable ? 1 : 0))).booleanValue());
        this.options.setMultiDex(config.isMultiDexEnabled());
        this.options.setMinSdkVersion(config.getMinSdkVersion().getApiLevel());
        if (!Boolean.FALSE.equals(globalScope.getExtension().getCompileOptions().getIncremental()) && this.androidBuilder.getTargetInfo().getBuildTools().getRevision().compareTo(new Revision(24, 0, 3), Revision.PreviewComparison.IGNORE) >= 0) {
            String taskName = StringHelper.combineAsCamelCase((Iterable)ImmutableList.of((Object)"transformJackWith", (Object)this.getName(), (Object)"for", (Object)scope.getFullVariantName()));
            this.options.setIncrementalDir(scope.getIncrementalDir(taskName));
        }
        this.options.setOutputFile(scope.getJackClassesZip());
        this.options.setResourceDirectories((Collection)ImmutableList.of((Object)scope.getJavaResourcesDestinationDir()));
        CoreAnnotationProcessorOptions annotationProcessorOptions = config.getJavaCompileOptions().getAnnotationProcessorOptions();
        Preconditions.checkNotNull((Object)annotationProcessorOptions.getIncludeCompileClasspath());
        this.options.setAnnotationProcessorClassPath((List)Lists.newArrayList(scope.getVariantData().getVariantDependency().resolveAndGetAnnotationProcessorClassPath(annotationProcessorOptions.getIncludeCompileClasspath(), this.androidBuilder.getErrorReporter())));
        this.options.setAnnotationProcessorNames(annotationProcessorOptions.getClassNames());
        this.options.setAnnotationProcessorOptions(annotationProcessorOptions.getArguments());
        this.options.setAnnotationProcessorOutputDirectory(scope.getAnnotationProcessorOutputDir());
        this.options.setEcjOptionFile(scope.getJackEcjOptionsFile());
        this.options.setAdditionalParameters(config.getJackOptions().getAdditionalParameters());
        this.jackInProcess = config.getJackOptions().isJackInProcess();
        if (((CoreBuildType)config.getBuildType()).isTestCoverageEnabled()) {
            this.options.setCoverageMetadataFile(scope.getJackCoverageMetadataFile());
        }
        if (config.isMinifyEnabled()) {
            File sdkDir = scope.getGlobalScope().getSdkHandler().getAndCheckSdkFolder();
            Preconditions.checkNotNull((Object)sdkDir);
            File defaultProguardFile = ProguardFiles.getDefaultProguardFile("proguard-android.txt", this.project);
            Set proguardFiles = config.getProguardFiles(true, (List)ImmutableList.of((Object)defaultProguardFile));
            File proguardResFile = scope.getProcessAndroidResourcesProguardOutputFile();
            proguardFiles.add(proguardResFile);
            if (scope.getTestedVariantData() != null) {
                proguardResFile = scope.getTestedVariantData().getScope().getProcessAndroidResourcesProguardOutputFile();
                proguardFiles.add(proguardResFile);
            }
            this.options.setProguardFiles((Collection)proguardFiles);
            this.options.setMappingFile(new File(scope.getProguardOutputFolder(), "mapping.txt"));
        }
        ImmutableList.Builder jarJarRuleFiles = ImmutableList.builder();
        for (File file : config.getJarJarRuleFiles()) {
            jarJarRuleFiles.add((Object)this.project.file((Object)file));
        }
        this.options.setJarJarRuleFiles((Collection)jarJarRuleFiles.build());
        CompileOptions compileOptions = scope.getGlobalScope().getExtension().getCompileOptions();
        AbstractCompilesUtil.setDefaultJavaVersion(compileOptions, scope.getGlobalScope().getExtension().getCompileSdkVersion(), true);
        this.options.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
    }
}

