/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.build.gradle.shrinker.AbstractShrinker;
import com.android.build.gradle.shrinker.FullRunShrinker;
import com.android.build.gradle.shrinker.IncrementalShrinker;
import com.android.build.gradle.shrinker.JavaSerializationShrinkerGraph;
import com.android.build.gradle.shrinker.KeepRules;
import com.android.build.gradle.shrinker.ProguardConfig;
import com.android.build.gradle.shrinker.ProguardFlagsKeepRules;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.BuildException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewShrinkerTransform
extends ProguardConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(NewShrinkerTransform.class);
    private static final String NAME = "newClassShrinker";
    private final Set<File> platformJars;
    private final File incrementalDir;
    private final List<String> dontwarnLines;
    private final List<String> keepLines;

    public NewShrinkerTransform(VariantScope scope) {
        super(scope);
        this.platformJars = ImmutableSet.copyOf((Collection)scope.getGlobalScope().getAndroidBuilder().getBootClasspath(true));
        this.incrementalDir = scope.getIncrementalDir(scope.getTaskName(NAME));
        this.dontwarnLines = Lists.newArrayList();
        this.keepLines = Lists.newArrayList();
    }

    public String getName() {
        return NAME;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Collection<File> getSecondaryFileInputs() {
        return this.getAllConfigurationFiles();
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.incrementalDir);
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        TransformOutputProvider output = invocation.getOutputProvider();
        Collection referencedInputs = invocation.getReferencedInputs();
        Preconditions.checkNotNull((Object)output, (Object)("Missing output object for transform " + this.getName()));
        if (NewShrinkerTransform.isIncrementalRun(invocation.isIncremental(), referencedInputs)) {
            this.incrementalRun(invocation.getInputs(), referencedInputs, output);
        } else {
            this.fullRun(invocation.getInputs(), referencedInputs, output);
        }
    }

    private void fullRun(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider output) throws IOException {
        ProguardConfig config = this.getConfig();
        ShrinkerLogger shrinkerLogger = new ShrinkerLogger(config.getFlags().getDontWarnSpecs(), logger);
        FullRunShrinker<String> shrinker = new FullRunShrinker<String>((WaitableExecutor<Void>)WaitableExecutor.useGlobalSharedThreadPool(), JavaSerializationShrinkerGraph.empty(this.incrementalDir), this.platformJars, shrinkerLogger);
        boolean saveState = this.isIncremental();
        shrinker.run(inputs, referencedInputs, output, (ImmutableMap<AbstractShrinker.CounterSet, KeepRules>)ImmutableMap.of((Object)((Object)AbstractShrinker.CounterSet.SHRINK), (Object)new ProguardFlagsKeepRules(config.getFlags(), shrinkerLogger)), saveState);
        NewShrinkerTransform.checkForWarnings(config, shrinkerLogger);
    }

    private static void checkForWarnings(ProguardConfig config, ShrinkerLogger shrinkerLogger) {
        if (shrinkerLogger.getWarningsCount() > 0 && !config.getFlags().isIgnoreWarnings()) {
            throw new BuildException("Warnings found during shrinking, please use -dontwarn or -ignorewarnings to suppress them.", null);
        }
    }

    private ProguardConfig getConfig() throws IOException {
        ProguardConfig config = new ProguardConfig();
        for (File configFile : this.getAllConfigurationFiles()) {
            config.parse(configFile);
        }
        config.parse(this.getAdditionalConfigString());
        return config;
    }

    private String getAdditionalConfigString() {
        StringBuilder sb = new StringBuilder();
        for (String keepLine : this.keepLines) {
            sb.append("-keep ");
            sb.append(keepLine);
            sb.append("\n");
        }
        for (String dontWarn : this.dontwarnLines) {
            sb.append("-dontwarn ");
            sb.append(dontWarn);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void incrementalRun(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider output) throws IOException {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            JavaSerializationShrinkerGraph graph = JavaSerializationShrinkerGraph.readFromDir(this.incrementalDir, ((Object)((Object)this)).getClass().getClassLoader());
            AbstractShrinker.logTime("loading state", stopwatch);
            ProguardConfig config = this.getConfig();
            ShrinkerLogger shrinkerLogger = new ShrinkerLogger(config.getFlags().getDontWarnSpecs(), logger);
            IncrementalShrinker<String> shrinker = new IncrementalShrinker<String>((WaitableExecutor<Void>)WaitableExecutor.useGlobalSharedThreadPool(), graph, shrinkerLogger);
            shrinker.incrementalRun(inputs, output);
            NewShrinkerTransform.checkForWarnings(config, shrinkerLogger);
        }
        catch (IncrementalShrinker.IncrementalRunImpossibleException e) {
            logger.warn("Incremental shrinker run impossible: " + e.getMessage());
            logger.info("Incremental shrinker run impossible: " + e.getMessage(), (Throwable)e);
            this.fullRun(inputs, referencedInputs, output);
        }
    }

    private static boolean isIncrementalRun(boolean isIncremental, Collection<TransformInput> referencedInputs) {
        if (!isIncremental) {
            return false;
        }
        for (TransformInput referencedInput : referencedInputs) {
            for (JarInput jarInput : referencedInput.getJarInputs()) {
                if (jarInput.getStatus() == Status.NOTCHANGED) continue;
                return false;
            }
            for (DirectoryInput directoryInput : referencedInput.getDirectoryInputs()) {
                if (directoryInput.getChangedFiles().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void keep(String keep) {
        this.keepLines.add(keep);
    }

    @Override
    public void dontwarn(String dontwarn) {
        this.dontwarnLines.add(dontwarn);
    }
}

