/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.internal.incremental.ByteCodeUtils;
import com.android.build.gradle.shrinker.AbstractShrinker;
import com.android.build.gradle.shrinker.ClassLookupException;
import com.android.build.gradle.shrinker.Dependency;
import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.IncrementalShrinker;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public class JavaSerializationShrinkerGraph
implements ShrinkerGraph<String> {
    private final SetMultimap<String, String> mAnnotations;
    private final ConcurrentMap<String, ClassInfo> mClasses;
    private final SetMultimap<String, Dependency<String>> mDependencies;
    private final SetMultimap<String, String> mMembers;
    private final ConcurrentMap<String, Integer> mModifiers;
    private final Counters mMultidexCounters;
    private final Counters mShrinkCounters;
    private final File mStateDir;

    private JavaSerializationShrinkerGraph(File stateDir) {
        this.mStateDir = (File)Preconditions.checkNotNull((Object)stateDir);
        this.mShrinkCounters = new Counters(Maps.newConcurrentMap(), (Map<String, Counter>)ImmutableMap.of());
        this.mMultidexCounters = new Counters(Maps.newConcurrentMap(), (Map<String, Counter>)ImmutableMap.of());
        this.mMembers = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
        this.mAnnotations = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
        this.mClasses = Maps.newConcurrentMap();
        this.mModifiers = Maps.newConcurrentMap();
        this.mDependencies = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    private JavaSerializationShrinkerGraph(File stateDir, SetMultimap<String, String> annotations, ConcurrentMap<String, ClassInfo> classes, SetMultimap<String, Dependency<String>> dependencies, SetMultimap<String, String> members, ConcurrentMap<String, Integer> modifiers, ConcurrentMap<String, DependencyType> multidexRoots, Map<String, Counter> multidexCounters, ConcurrentMap<String, DependencyType> shrinkRoots, Map<String, Counter> shrinkCounters) {
        this.mStateDir = stateDir;
        this.mAnnotations = annotations;
        this.mClasses = classes;
        this.mDependencies = dependencies;
        this.mMembers = members;
        this.mModifiers = modifiers;
        this.mMultidexCounters = new Counters(multidexRoots, multidexCounters);
        this.mShrinkCounters = new Counters(shrinkRoots, shrinkCounters);
    }

    public static JavaSerializationShrinkerGraph empty(File stateDir) {
        return new JavaSerializationShrinkerGraph(stateDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JavaSerializationShrinkerGraph readFromDir(File dir, final ClassLoader classLoader) throws IOException {
        File stateFile = JavaSerializationShrinkerGraph.getStateFile(dir);
        try (ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(stateFile))){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return Class.forName(desc.getName(), false, classLoader);
            }
        };){
            JavaSerializationShrinkerGraph javaSerializationShrinkerGraph = new JavaSerializationShrinkerGraph(dir, (SetMultimap<String, String>)((SetMultimap)stream.readObject()), (ConcurrentMap)stream.readObject(), (SetMultimap<String, Dependency<String>>)((SetMultimap)stream.readObject()), (SetMultimap<String, String>)((SetMultimap)stream.readObject()), (ConcurrentMap)stream.readObject(), (ConcurrentMap)stream.readObject(), (Map)stream.readObject(), (ConcurrentMap)stream.readObject(), (Map)stream.readObject());
            return javaSerializationShrinkerGraph;
        }
        catch (ClassNotFoundException e) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException("Failed to load incremental state.", e);
        }
        catch (InvalidClassException e) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException("Failed to load incremental state.", e);
        }
    }

    @Override
    public String addMember(String owner, String name, String desc, int modifiers) {
        String fullName = JavaSerializationShrinkerGraph.getFullMethodName(owner, name, desc);
        this.mMembers.put((Object)owner, (Object)fullName);
        this.mModifiers.put(fullName, modifiers);
        return fullName;
    }

    @Override
    public String getMemberReference(String className, String memberName, String desc) {
        return JavaSerializationShrinkerGraph.getFullMethodName(className, memberName, desc);
    }

    @Override
    public void addDependency(String source, String target, DependencyType type) {
        Dependency<String> dep = new Dependency<String>(target, type);
        this.mDependencies.put((Object)source, dep);
    }

    @Override
    public Set<Dependency<String>> getDependencies(String node) {
        return Sets.newHashSet((Iterable)this.mDependencies.get((Object)node));
    }

    @Override
    public Set<String> getMethods(String klass) {
        HashSet members = Sets.newHashSet((Iterable)this.mMembers.get((Object)klass));
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            if (JavaSerializationShrinkerGraph.isMethod(member)) continue;
            iterator.remove();
        }
        return members;
    }

    @Override
    public Set<String> getFields(String klass) {
        HashSet members = Sets.newHashSet((Iterable)this.mMembers.get((Object)klass));
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            if (!JavaSerializationShrinkerGraph.isMethod(member)) continue;
            iterator.remove();
        }
        return members;
    }

    @Override
    public boolean incrementAndCheck(String node, DependencyType type, AbstractShrinker.CounterSet counterSet) {
        try {
            return ((Counter)this.getCounters(counterSet).mReferenceCounters.get((Object)node)).incrementAndCheck(type);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveState() throws IOException {
        File stateFile = JavaSerializationShrinkerGraph.getStateFile(this.mStateDir);
        FileUtils.deleteIfExists((File)stateFile);
        Files.createParentDirs((File)stateFile);
        try (ObjectOutputStream stream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(stateFile)));){
            stream.writeObject(this.mAnnotations);
            stream.writeObject(this.mClasses);
            stream.writeObject(this.mDependencies);
            stream.writeObject(this.mMembers);
            stream.writeObject(this.mModifiers);
            stream.writeObject(this.mMultidexCounters.mRoots);
            stream.writeObject(ImmutableMap.copyOf((Map)this.mMultidexCounters.mReferenceCounters.asMap()));
            stream.writeObject(this.mShrinkCounters.mRoots);
            stream.writeObject(ImmutableMap.copyOf((Map)this.mShrinkCounters.mReferenceCounters.asMap()));
        }
    }

    @Override
    public boolean isReachable(String node, AbstractShrinker.CounterSet counterSet) {
        try {
            return ((Counter)this.getCounters(counterSet).mReferenceCounters.get((Object)node)).isReachable();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeAllCodeDependencies(String node) {
        Set dependencies = this.mDependencies.get((Object)node);
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (dependency.type != DependencyType.REQUIRED_CODE_REFERENCE && dependency.type != DependencyType.REQUIRED_CODE_REFERENCE_REFLECTION) continue;
            iterator.remove();
        }
    }

    @Override
    public String getSuperclass(String klass) throws ClassLookupException {
        ClassInfo classInfo = (ClassInfo)this.mClasses.get(klass);
        if (classInfo == null) {
            throw new ClassLookupException(klass);
        }
        String superclass = classInfo.superclass;
        if (superclass != null && !this.mClasses.containsKey(superclass)) {
            throw new ClassLookupException(superclass);
        }
        return superclass;
    }

    @Override
    public String findMatchingMethod(String klass, String method) {
        if (this.mMembers.containsEntry((Object)klass, (Object)method)) {
            return method;
        }
        String methodToLookFor = klass + "." + JavaSerializationShrinkerGraph.getMemberId(method);
        if (this.mMembers.containsEntry((Object)klass, (Object)methodToLookFor)) {
            return methodToLookFor;
        }
        return null;
    }

    @Override
    public boolean isLibraryClass(String klass) {
        if (AbstractShrinker.isSdkPackage(klass)) {
            return true;
        }
        ClassInfo classInfo = (ClassInfo)this.mClasses.get(klass);
        return classInfo == null || classInfo.isLibraryClass();
    }

    public String[] getInterfaces(String klass) throws ClassLookupException {
        ClassInfo classInfo = (ClassInfo)this.mClasses.get(klass);
        if (classInfo == null) {
            throw new ClassLookupException(klass);
        }
        if (classInfo.interfaces == null) {
            return new String[0];
        }
        return classInfo.interfaces;
    }

    @Override
    public void checkDependencies(ShrinkerLogger shrinkerLogger) {
        HashMap invalidDeps = Maps.newHashMap();
        for (Map.Entry entry : this.mDependencies.entries()) {
            String source = (String)entry.getKey();
            Dependency dep = (Dependency)entry.getValue();
            String target = (String)dep.target;
            if (!target.contains(".")) {
                if (this.mClasses.containsKey(target) || dep.type == DependencyType.REQUIRED_CODE_REFERENCE_REFLECTION) continue;
                shrinkerLogger.invalidClassReference(source, target);
                invalidDeps.put(source, entry.getValue());
                continue;
            }
            if (this.mMembers.containsEntry((Object)this.getOwnerClass(target), (Object)target)) continue;
            shrinkerLogger.invalidMemberReference(source, target);
            invalidDeps.put(source, entry.getValue());
        }
        for (Map.Entry entry : invalidDeps.entrySet()) {
            this.mDependencies.remove(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<String> getReachableClasses(AbstractShrinker.CounterSet counterSet) {
        HashSet classesToKeep = Sets.newHashSet();
        for (Map.Entry entry : this.mClasses.entrySet()) {
            if (((ClassInfo)entry.getValue()).isLibraryClass() || !this.isReachable((String)entry.getKey(), counterSet)) continue;
            classesToKeep.add(entry.getKey());
        }
        return classesToKeep;
    }

    @Override
    public File getSourceFile(String klass) {
        return ((ClassInfo)this.mClasses.get((Object)klass)).classFile;
    }

    @Override
    public Set<String> getReachableMembersLocalNames(String klass, AbstractShrinker.CounterSet counterSet) {
        HashSet memberIds = Sets.newHashSet();
        for (String member : this.mMembers.get((Object)klass)) {
            if (!this.isReachable(member, counterSet)) continue;
            String memberId = JavaSerializationShrinkerGraph.getMemberId(member);
            memberIds.add(memberId);
        }
        return memberIds;
    }

    @Override
    public String getOwnerClass(String member) {
        return ByteCodeUtils.getClassName(member);
    }

    @Override
    public String getClassReference(String className) {
        Preconditions.checkNotNull((Object)className);
        return className;
    }

    @Override
    public String addClass(String name, String superName, String[] interfaces, int modifiers, File classFile) {
        ClassInfo classInfo = new ClassInfo(classFile, superName, interfaces);
        this.mClasses.put(name, classInfo);
        this.mModifiers.put(name, modifiers);
        return name;
    }

    @Override
    public Iterable<String> getAllProgramClasses() {
        ArrayList classes = Lists.newArrayList();
        for (Map.Entry entry : this.mClasses.entrySet()) {
            boolean isProgramClass = ((ClassInfo)entry.getValue()).classFile != null;
            if (!isProgramClass) continue;
            classes.add(entry.getKey());
        }
        return classes;
    }

    @Override
    public String getClassName(String klass) {
        return klass;
    }

    @Override
    public int getModifiers(String node) {
        return (Integer)this.mModifiers.get(node);
    }

    @Override
    public void addAnnotation(String node, String annotationName) {
        Preconditions.checkArgument((!annotationName.endsWith(";") ? 1 : 0) != 0);
        this.mAnnotations.put((Object)node, (Object)annotationName);
    }

    @Override
    public Iterable<String> getAnnotations(String node) {
        return this.mAnnotations.get((Object)node);
    }

    @Override
    public void addRoots(Map<String, DependencyType> symbolsToKeep, AbstractShrinker.CounterSet counterSet) {
        this.getCounters(counterSet).mRoots.putAll(symbolsToKeep);
    }

    @Override
    public Map<String, DependencyType> getRoots(AbstractShrinker.CounterSet counterSet) {
        return ImmutableMap.copyOf((Map)this.getCounters(counterSet).mRoots);
    }

    @Override
    public void clearCounters(WaitableExecutor<Void> executor) {
        this.getCounters(AbstractShrinker.CounterSet.SHRINK).mReferenceCounters.invalidateAll();
        this.getCounters(AbstractShrinker.CounterSet.LEGACY_MULTIDEX).mReferenceCounters.invalidateAll();
    }

    @Override
    public String getMemberName(String member) {
        return member.substring(member.indexOf(46) + 1, member.indexOf(58));
    }

    @Override
    public String getFullMemberName(String member) {
        return member;
    }

    @Override
    public String getMemberDescriptor(String member) {
        return member.substring(member.indexOf(58) + 1);
    }

    @Override
    public boolean isClassKnown(String klass) {
        return this.mClasses.containsKey(klass);
    }

    private Counters getCounters(AbstractShrinker.CounterSet counterSet) {
        if (counterSet == AbstractShrinker.CounterSet.SHRINK) {
            return this.mShrinkCounters;
        }
        return this.mMultidexCounters;
    }

    private static String getFullMethodName(String className, String methodName, String typeDesc) {
        return className + "." + methodName + ":" + typeDesc;
    }

    private static String getMemberId(String member) {
        return member.substring(member.indexOf(46) + 1);
    }

    private static File getStateFile(File dir) {
        return new File(dir, "shrinker.bin");
    }

    private static boolean isMethod(String member) {
        return member.contains("(");
    }

    private static final class Counter
    implements Serializable {
        int required = 0;
        int ifClassKept = 0;
        int classIsKept = 0;
        int superInterfaceKept = 0;
        int interfaceImplemented = 0;

        private Counter() {
        }

        synchronized boolean incrementAndCheck(DependencyType type) {
            boolean before = this.isReachable();
            switch (type) {
                case REQUIRED_CLASS_STRUCTURE: 
                case REQUIRED_CODE_REFERENCE: 
                case REQUIRED_CODE_REFERENCE_REFLECTION: {
                    ++this.required;
                    break;
                }
                case IF_CLASS_KEPT: {
                    ++this.ifClassKept;
                    break;
                }
                case CLASS_IS_KEPT: {
                    ++this.classIsKept;
                    break;
                }
                case SUPERINTERFACE_KEPT: {
                    ++this.superInterfaceKept;
                    break;
                }
                case INTERFACE_IMPLEMENTED: {
                    ++this.interfaceImplemented;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown dependency type.");
                }
            }
            boolean after = this.isReachable();
            return before != after;
        }

        synchronized boolean isReachable() {
            return this.required > 0 || this.ifClassKept > 0 && this.classIsKept > 0 || this.superInterfaceKept > 0 && this.interfaceImplemented > 0;
        }
    }

    private static final class Counters
    implements Serializable {
        private final LoadingCache<String, Counter> mReferenceCounters;
        private final ConcurrentMap<String, DependencyType> mRoots;

        public Counters(ConcurrentMap<String, DependencyType> roots, Map<String, Counter> counters) {
            this.mRoots = roots;
            this.mReferenceCounters = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Counter>(){

                public Counter load(String unused) throws Exception {
                    return new Counter();
                }
            });
            this.mReferenceCounters.putAll(counters);
        }
    }

    private static final class ClassInfo
    implements Serializable {
        final File classFile;
        final String superclass;
        final String[] interfaces;

        private ClassInfo(File classFile, String superclass, String[] interfaces) {
            this.classFile = classFile;
            this.superclass = superclass;
            this.interfaces = interfaces;
        }

        boolean isLibraryClass() {
            return this.classFile == null;
        }
    }
}

