/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.SupplierTask;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;

public class CheckManifestInInstantRunMode
extends DefaultAndroidTask {
    private static final Logger LOG = Logging.getLogger(CheckManifestInInstantRunMode.class);
    private InstantRunBuildContext instantRunBuildContext;
    private File instantRunSupportDir;
    private File packageOutputFile;
    private File instantRunManifestFile;

    public File getInstantRunManifestFile() {
        return this.instantRunManifestFile;
    }

    public void setInstantRunManifestFile(File instantRunManifestFile) {
        this.instantRunManifestFile = instantRunManifestFile;
    }

    public File getPackageOutputFile() {
        return this.packageOutputFile;
    }

    public void setPackageOutputFile(File packageOutputFile) {
        this.packageOutputFile = packageOutputFile;
    }

    @TaskAction
    public void checkManifestChanges() throws IOException {
        if (!this.instantRunBuildContext.isInInstantRunMode()) {
            LOG.warn("CheckManifestInInstantRunMode configured in non instant run build, please file a bug.");
            return;
        }
        File instantRunManifestFile = this.getInstantRunManifestFile();
        LOG.info("CheckManifestInInstantRunMode : Merged manifest %1$s", (Object)instantRunManifestFile);
        CheckManifestInInstantRunMode.runManifestChangeVerifier(this.instantRunBuildContext, this.instantRunSupportDir, instantRunManifestFile);
        File resourcesApk = this.getPackageOutputFile();
        LOG.info("CheckManifestInInstantRunMode : Resource APK %1$s", (Object)resourcesApk);
        if (resourcesApk != null && resourcesApk.exists()) {
            CheckManifestInInstantRunMode.runManifestBinaryChangeVerifier(this.instantRunBuildContext, this.instantRunSupportDir, this.getPackageOutputFile());
        }
    }

    static void runManifestChangeVerifier(InstantRunBuildContext instantRunBuildContext, File instantRunSupportDir, File manifestFileToPackage) throws IOException {
        File previousManifestFile = new File(instantRunSupportDir, "manifest.xml");
        if (previousManifestFile.exists()) {
            String previousManifest;
            String currentManifest = Files.asCharSource((File)manifestFileToPackage, (Charset)Charsets.UTF_8).read();
            if (!currentManifest.equals(previousManifest = Files.asCharSource((File)previousManifestFile, (Charset)Charsets.UTF_8).read())) {
                instantRunBuildContext.setVerifierResult(InstantRunVerifierStatus.MANIFEST_FILE_CHANGE);
                Files.copy((File)manifestFileToPackage, (File)previousManifestFile);
            }
        } else {
            Files.createParentDirs((File)previousManifestFile);
            Files.copy((File)manifestFileToPackage, (File)previousManifestFile);
            instantRunBuildContext.setVerifierResult(InstantRunVerifierStatus.INITIAL_BUILD);
        }
    }

    static void runManifestBinaryChangeVerifier(InstantRunBuildContext instantRunBuildContext, File instantRunSupportDir, File resOutBaseNameFile) throws IOException {
        String currentIterationCRC = null;
        try (JarFile jarFile = new JarFile(resOutBaseNameFile);){
            ZipEntry entry = jarFile.getEntry("AndroidManifest.xml");
            if (entry != null) {
                currentIterationCRC = String.valueOf(entry.getCrc());
            }
        }
        File crcFile = new File(instantRunSupportDir, "manifest.crc");
        if (crcFile.exists() && currentIterationCRC != null) {
            String previousIterationCRC = Files.readFirstLine((File)crcFile, (Charset)Charsets.UTF_8);
            if (!currentIterationCRC.equals(previousIterationCRC)) {
                instantRunBuildContext.setVerifierResult(InstantRunVerifierStatus.BINARY_MANIFEST_FILE_CHANGE);
            }
        } else {
            instantRunBuildContext.setVerifierResult(InstantRunVerifierStatus.INITIAL_BUILD);
        }
        if (currentIterationCRC != null) {
            Files.createParentDirs((File)crcFile);
            Files.write((CharSequence)currentIterationCRC, (File)crcFile, (Charset)Charsets.UTF_8);
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<CheckManifestInInstantRunMode> {
        protected final TransformVariantScope transformVariantScope;
        protected final InstantRunVariantScope instantRunVariantScope;
        protected final SupplierTask<File> instantRunMergedManifest;
        protected final SupplierTask<File> processedResourcesOutputFile;

        public ConfigAction(TransformVariantScope transformVariantScope, InstantRunVariantScope instantRunVariantScope, SupplierTask<File> instantRunMergedManifest, SupplierTask<File> processedResourcesOutputFile) {
            this.transformVariantScope = transformVariantScope;
            this.instantRunVariantScope = instantRunVariantScope;
            this.instantRunMergedManifest = instantRunMergedManifest;
            this.processedResourcesOutputFile = processedResourcesOutputFile;
        }

        @Override
        public String getName() {
            return this.transformVariantScope.getTaskName("checkManifestChanges");
        }

        @Override
        public Class<CheckManifestInInstantRunMode> getType() {
            return CheckManifestInInstantRunMode.class;
        }

        @Override
        public void execute(CheckManifestInInstantRunMode task) {
            ConventionMappingHelper.map((Task)task, "packageOutputFile", this.processedResourcesOutputFile::get);
            ConventionMappingHelper.map((Task)task, "instantRunManifestFile", this.instantRunMergedManifest::get);
            task.instantRunBuildContext = this.instantRunVariantScope.getInstantRunBuildContext();
            task.instantRunSupportDir = this.instantRunVariantScope.getInstantRunSupportDir();
            task.setVariantName(this.transformVariantScope.getFullVariantName());
        }
    }
}

