/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ResourceException;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.GeneratedResourceSet;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedResourceWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NoOpResourcePreprocessor;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.res2.ResourceSet;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class MergeResources
extends IncrementalTask {
    private File outputDir;
    private File generatedPngsOutputDir;
    private File publicFile;
    private boolean process9Patch;
    private boolean crunchPng;
    private boolean validateEnabled;
    private File blameLogFolder;
    private List<ResourceSet> inputResourceSets;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();
    private boolean disableVectorDrawables;
    private Collection<String> generatedDensities;
    private int minSdk;
    private VariantScope variantScope;

    @InputFiles
    public Iterable<File> getRawInputFolders() {
        return MergeResources.flattenSourceSets(this.getInputResourceSets());
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            for (ResourceSet resourceSet : resourceSets) {
                resourceSet.loadFromFiles(this.getILogger());
                merger.addDataSet(resourceSet);
            }
            Aapt aapt = AaptGradleFactory.make(this.getBuilder(), this.getCrunchPng(), this.getProcess9Patch(), this.variantScope, this.getAaptTempDir());
            MergedResourceWriter writer = new MergedResourceWriter(destinationDir, this.getPublicFile(), this.getBlameLogFolder(), preprocessor, (arg_0, arg_1) -> ((Aapt)aapt).compile(arg_0, arg_1), this.getIncrementalFolder());
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            System.out.println(e.getMessage());
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            for (Object resourceSet : merger.getDataSets()) {
                resourceSet.setPreprocessor(preprocessor);
            }
            List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry entry : changedInputs.entrySet()) {
                File changedFile = (File)entry.getKey();
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, (FileStatus)entry.getValue(), this.getILogger())) continue;
                this.getLogger().info(String.format("Failed to process %s event! Full task run", entry.getValue()));
                this.doFullTaskAction();
                return;
            }
            Aapt aapt = AaptGradleFactory.make(this.getBuilder(), this.getCrunchPng(), this.getProcess9Patch(), this.variantScope, this.getAaptTempDir());
            MergedResourceWriter mergedResourceWriter = new MergedResourceWriter(this.getOutputDir(), this.getPublicFile(), this.getBlameLogFolder(), preprocessor, (arg_0, arg_1) -> ((Aapt)aapt).compile(arg_0, arg_1), this.getIncrementalFolder());
            merger.mergeData((MergeConsumer)mergedResourceWriter, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)mergedResourceWriter, false);
        }
        catch (MergingException e) {
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.fileValidity.clear();
        }
    }

    private ResourcePreprocessor getPreprocessor() {
        if (this.isDisableVectorDrawables()) {
            return new NoOpResourcePreprocessor();
        }
        Collection densities = this.getGeneratedDensities().stream().map(Density::getEnum).collect(Collectors.toList());
        return new VectorDrawableRenderer(this.getMinSdk(), this.getGeneratedPngsOutputDir(), densities, this.getILogger());
    }

    private List<ResourceSet> getConfiguredResourceSets(ResourcePreprocessor preprocessor) {
        ArrayList resourceSets = Lists.newArrayList(this.getInputResourceSets());
        ArrayList generatedSets = Lists.newArrayListWithCapacity((int)resourceSets.size());
        for (ResourceSet resourceSet : resourceSets) {
            resourceSet.setPreprocessor(preprocessor);
            GeneratedResourceSet generatedSet = new GeneratedResourceSet(resourceSet);
            resourceSet.setGeneratedSet((ResourceSet)generatedSet);
            generatedSets.add(generatedSet);
        }
        resourceSets.addAll(0, generatedSets);
        return resourceSets;
    }

    public List<ResourceSet> getInputResourceSets() {
        return this.inputResourceSets;
    }

    public void setInputResourceSets(List<ResourceSet> inputResourceSets) {
        this.inputResourceSets = inputResourceSets;
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    public void setCrunchPng(boolean crunchPng) {
        this.crunchPng = crunchPng;
    }

    public boolean getProcess9Patch() {
        return this.process9Patch;
    }

    public void setProcess9Patch(boolean process9Patch) {
        this.process9Patch = process9Patch;
    }

    @Optional
    @OutputFile
    public File getPublicFile() {
        return this.publicFile;
    }

    public void setPublicFile(File publicFile) {
        this.publicFile = publicFile;
    }

    @Input
    public boolean isValidateEnabled() {
        return this.validateEnabled;
    }

    public void setValidateEnabled(boolean validateEnabled) {
        this.validateEnabled = validateEnabled;
    }

    @OutputDirectory
    @Optional
    public File getBlameLogFolder() {
        return this.blameLogFolder;
    }

    public void setBlameLogFolder(File blameLogFolder) {
        this.blameLogFolder = blameLogFolder;
    }

    public File getGeneratedPngsOutputDir() {
        return this.generatedPngsOutputDir;
    }

    public void setGeneratedPngsOutputDir(File generatedPngsOutputDir) {
        this.generatedPngsOutputDir = generatedPngsOutputDir;
    }

    @Input
    public Collection<String> getGeneratedDensities() {
        return this.generatedDensities;
    }

    @Input
    public int getMinSdk() {
        return this.minSdk;
    }

    public void setMinSdk(int minSdk) {
        this.minSdk = minSdk;
    }

    public void setGeneratedDensities(Collection<String> generatedDensities) {
        this.generatedDensities = generatedDensities;
    }

    @Input
    public boolean isDisableVectorDrawables() {
        return this.disableVectorDrawables;
    }

    public void setDisableVectorDrawables(boolean disableVectorDrawables) {
        this.disableVectorDrawables = disableVectorDrawables;
    }

    private File getAaptTempDir() {
        return FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp"));
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeResources> {
        private final VariantScope scope;
        private final String taskNamePrefix;
        private final File outputLocation;
        private final boolean includeDependencies;
        private final boolean process9Patch;

        public ConfigAction(VariantScope scope, String taskNamePrefix, File outputLocation, boolean includeDependencies, boolean process9Patch) {
            this.scope = scope;
            this.taskNamePrefix = taskNamePrefix;
            this.outputLocation = outputLocation;
            this.includeDependencies = includeDependencies;
            this.process9Patch = process9Patch;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(this.taskNamePrefix, "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        @Override
        public void execute(MergeResources mergeResourcesTask) {
            final BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            AndroidConfig extension = this.scope.getGlobalScope().getExtension();
            mergeResourcesTask.setMinSdk(variantData.getVariantConfiguration().getMinSdkVersion().getApiLevel());
            mergeResourcesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeResourcesTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            mergeResourcesTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
            mergeResourcesTask.variantScope = this.scope;
            if (this.includeDependencies) {
                mergeResourcesTask.setBlameLogFolder(this.scope.getResourceBlameLogDir());
            }
            mergeResourcesTask.setProcess9Patch(this.process9Patch);
            mergeResourcesTask.setCrunchPng(extension.getAaptOptions().getCruncherEnabled());
            VectorDrawablesOptions vectorDrawablesOptions = variantData.getVariantConfiguration().getMergedFlavor().getVectorDrawables();
            Set generatedDensities = vectorDrawablesOptions.getGeneratedDensities();
            mergeResourcesTask.setGeneratedDensities((Collection)Objects.firstNonNull((Object)generatedDensities, Collections.emptySet()));
            mergeResourcesTask.setDisableVectorDrawables(vectorDrawablesOptions.getUseSupportLibrary() != false || mergeResourcesTask.getGeneratedDensities().isEmpty());
            final boolean validateEnabled = AndroidGradleOptions.isResourceValidationEnabled(this.scope.getGlobalScope().getProject());
            mergeResourcesTask.setValidateEnabled(validateEnabled);
            ConventionMappingHelper.map((Task)mergeResourcesTask, "inputResourceSets", new Callable<List<ResourceSet>>(){

                @Override
                public List<ResourceSet> call() throws Exception {
                    ArrayList generatedResFolders = Lists.newArrayList((Object[])new File[]{scope.getRenderscriptResOutputDir(), scope.getGeneratedResOutputDir()});
                    if (variantData.getExtraGeneratedResFolders() != null) {
                        generatedResFolders.addAll(variantData.getExtraGeneratedResFolders());
                    }
                    if (scope.getMicroApkTask() != null && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
                        generatedResFolders.add(scope.getMicroApkResDirectory());
                    }
                    return variantData.getVariantConfiguration().getResourceSets(generatedResFolders, includeDependencies, validateEnabled);
                }
            });
            mergeResourcesTask.setOutputDir(this.outputLocation != null ? this.outputLocation : this.scope.getDefaultMergeResourcesOutputDir());
            mergeResourcesTask.setGeneratedPngsOutputDir(this.scope.getGeneratedPngsOutputDir());
            variantData.mergeResourcesTask = mergeResourcesTask;
        }
    }
}

