/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.model.FilterDataImpl;
import com.android.build.gradle.internal.publishing.FilterDataPersistence;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.SplitFileSupplier;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.gradle.api.Task;

public abstract class SplitRelatedTask
extends BaseTask {
    public abstract File getApkMetadataFile();

    public abstract List<ApkOutputFile> getOutputSplitFiles();

    public abstract List<FilterData> getSplitsData();

    public List<SplitFileSupplier> getOutputFileSuppliers() {
        ImmutableList.Builder suppliers = ImmutableList.builder();
        for (final FilterData filterData : this.getSplitsData()) {
            final Optional<ApkOutputFile> outputFile = this.getOutputSplitFiles().stream().filter(apkOutputFile -> filterData.getIdentifier().equals(apkOutputFile.getFilter(filterData.getFilterType()))).findFirst();
            if (!outputFile.isPresent()) continue;
            suppliers.add((Object)new SplitFileSupplier(){

                public File get() {
                    return ((ApkOutputFile)outputFile.get()).getOutputFile();
                }

                @Override
                public Task getTask() {
                    return SplitRelatedTask.this;
                }

                @Override
                public FilterData getFilterData() {
                    return filterData;
                }
            });
        }
        return suppliers.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveApkMetadataFile() throws IOException {
        File metadataFile = this.getApkMetadataFile();
        if (metadataFile == null) {
            return;
        }
        try (OutputStreamWriter fileWriter = null;){
            metadataFile.getParentFile().mkdirs();
            fileWriter = new FileWriter(metadataFile);
            FilterDataPersistence persistence = new FilterDataPersistence();
            persistence.persist(this.getOutputFileSuppliers(), fileWriter);
        }
    }

    protected static void addAllFilterData(ImmutableList.Builder<FilterData> to, Collection<String> identifiers, OutputFile.FilterType filterType) {
        for (String identifier : identifiers) {
            to.add((Object)FilterDataImpl.build(filterType.toString(), identifier));
        }
    }
}

