/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.builder.testing.api.TestServer;
import com.android.utils.StringHelper;
import org.gradle.api.Task;

public class TestServerTaskConfigAction
implements TaskConfigAction<TestServerTask> {
    private final VariantScope scope;
    private final TestServer testServer;

    public TestServerTaskConfigAction(VariantScope scope, TestServer testServer) {
        this.scope = scope;
        this.testServer = testServer;
    }

    @Override
    public String getName() {
        return this.scope.getVariantConfiguration().hasFlavors() ? this.scope.getTaskName(this.testServer.getName() + "Upload") : this.testServer.getName() + "Upload";
    }

    @Override
    public Class<TestServerTask> getType() {
        return TestServerTask.class;
    }

    @Override
    public void execute(TestServerTask serverTask) {
        BaseVariantData baseVariantData = this.scope.getTestedVariantData();
        TestVariantData testVariantData = (TestVariantData)this.scope.getVariantData();
        BaseVariantOutputData variantOutputData = (BaseVariantOutputData)baseVariantData.getOutputs().get(0);
        BaseVariantOutputData testVariantOutputData = (BaseVariantOutputData)testVariantData.getOutputs().get(0);
        String variantName = this.scope.getVariantConfiguration().getFullName();
        serverTask.setDescription("Uploads APKs for Build '" + variantName + "' to Test Server '" + StringHelper.capitalize((String)this.testServer.getName()) + "'.");
        serverTask.setGroup("verification");
        serverTask.setVariantName(variantName);
        serverTask.setTestServer(this.testServer);
        ConventionMappingHelper.map((Task)serverTask, "testApk", testVariantOutputData::getOutputFile);
        if (!(baseVariantData instanceof LibraryVariantData)) {
            ConventionMappingHelper.map((Task)serverTask, "testedApk", variantOutputData::getOutputFile);
        }
        if (!this.testServer.isConfigured()) {
            serverTask.setEnabled(false);
        }
    }
}

