/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.NettyServerTransport;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.Utils;
import io.nettyjarjar.bootstrap.ServerBootstrap;
import io.nettyjarjar.channel.Channel;
import io.nettyjarjar.channel.ChannelFuture;
import io.nettyjarjar.channel.ChannelFutureListener;
import io.nettyjarjar.channel.ChannelInitializer;
import io.nettyjarjar.channel.ChannelOption;
import io.nettyjarjar.channel.EventLoopGroup;
import io.nettyjarjar.channel.ServerChannel;
import io.nettyjarjar.channel.socket.nio.NioServerSocketChannel;
import io.nettyjarjar.util.AbstractReferenceCounted;
import io.nettyjarjar.util.ReferenceCounted;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class NettyServer
implements InternalServer {
    private static final Logger log = Logger.getLogger(InternalServer.class.getName());
    private final SocketAddress address;
    private final Class<? extends ServerChannel> channelType;
    private final ProtocolNegotiator protocolNegotiator;
    private final int maxStreamsPerConnection;
    private final boolean usingSharedBossGroup;
    private final boolean usingSharedWorkerGroup;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerListener listener;
    private Channel channel;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private final ReferenceCounted eventLoopReferenceCounter = new EventLoopReferenceCounter();

    NettyServer(SocketAddress address, Class<? extends ServerChannel> channelType, @Nullable EventLoopGroup bossGroup, @Nullable EventLoopGroup workerGroup, ProtocolNegotiator protocolNegotiator, int maxStreamsPerConnection, int flowControlWindow, int maxMessageSize, int maxHeaderListSize) {
        this.address = address;
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.protocolNegotiator = (ProtocolNegotiator)Preconditions.checkNotNull((Object)protocolNegotiator, (Object)"protocolNegotiator");
        this.usingSharedBossGroup = bossGroup == null;
        this.usingSharedWorkerGroup = workerGroup == null;
        this.maxStreamsPerConnection = maxStreamsPerConnection;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
    }

    @Override
    public int getPort() {
        if (this.channel == null) {
            return -1;
        }
        SocketAddress localAddr = this.channel.localAddress();
        if (!(localAddr instanceof InetSocketAddress)) {
            return -1;
        }
        return ((InetSocketAddress)localAddr).getPort();
    }

    @Override
    public void start(ServerListener serverListener) throws IOException {
        this.listener = (ServerListener)Preconditions.checkNotNull((Object)serverListener, (Object)"serverListener");
        this.allocateSharedGroups();
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.bossGroup, this.workerGroup);
        b.channel(this.channelType);
        if (NioServerSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_BACKLOG, 128);
            b.childOption(ChannelOption.SO_KEEPALIVE, true);
        }
        b.childHandler(new ChannelInitializer<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initChannel(Channel ch) throws Exception {
                ServerTransportListener transportListener;
                NettyServer.this.eventLoopReferenceCounter.retain();
                ch.closeFuture().addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        NettyServer.this.eventLoopReferenceCounter.release();
                    }
                });
                NettyServerTransport transport = new NettyServerTransport(ch, NettyServer.this.protocolNegotiator, NettyServer.this.maxStreamsPerConnection, NettyServer.this.flowControlWindow, NettyServer.this.maxMessageSize, NettyServer.this.maxHeaderListSize);
                NettyServer nettyServer = NettyServer.this;
                synchronized (nettyServer) {
                    if (NettyServer.this.channel != null && !NettyServer.this.channel.isOpen()) {
                        ch.close();
                        return;
                    }
                    transportListener = NettyServer.this.listener.transportCreated(transport);
                }
                transport.start(transportListener);
            }
        });
        ChannelFuture future = b.bind(this.address);
        try {
            future.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted waiting for bind");
        }
        if (!future.isSuccess()) {
            throw new IOException("Failed to bind", future.cause());
        }
        this.channel = future.channel();
    }

    @Override
    public void shutdown() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        this.channel.close().addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    log.log(Level.WARNING, "Error shutting down server", future.cause());
                }
                NettyServer nettyServer = NettyServer.this;
                synchronized (nettyServer) {
                    NettyServer.this.listener.serverShutdown();
                }
                NettyServer.this.eventLoopReferenceCounter.release();
            }
        });
    }

    private void allocateSharedGroups() {
        if (this.bossGroup == null) {
            this.bossGroup = SharedResourceHolder.get(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP);
        }
        if (this.workerGroup == null) {
            this.workerGroup = SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
        }
    }

    class EventLoopReferenceCounter
    extends AbstractReferenceCounted {
        EventLoopReferenceCounter() {
        }

        @Override
        protected void deallocate() {
            try {
                if (NettyServer.this.usingSharedBossGroup && NettyServer.this.bossGroup != null) {
                    SharedResourceHolder.release(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP, NettyServer.this.bossGroup);
                }
            }
            finally {
                NettyServer.this.bossGroup = null;
                try {
                    if (NettyServer.this.usingSharedWorkerGroup && NettyServer.this.workerGroup != null) {
                        SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, NettyServer.this.workerGroup);
                    }
                }
                finally {
                    NettyServer.this.workerGroup = null;
                }
            }
        }

        @Override
        public ReferenceCounted touch(Object hint) {
            return this;
        }
    }
}

