/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class CommonBundle
extends BundleBase {
    @NonNls
    private static final String BUNDLE = "messages.CommonBundle";
    private static Reference<ResourceBundle> ourBundle;

    public static String message(@NotNull @PropertyKey(resourceBundle="messages.CommonBundle") String key, Object ... params) {
        return CommonBundle.message(CommonBundle.getCommonBundle(), key, params);
    }

    private CommonBundle() {
    }

    @NotNull
    private static ResourceBundle getCommonBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        return BundleBase.messageOrDefault(bundle, key, defaultValue, params);
    }

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return BundleBase.message(bundle, key, params);
    }

    @Nullable
    public static String messageOfNull(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        String value = CommonBundle.messageOrDefault(bundle, key, key, params);
        if (key.equals(value)) {
            return null;
        }
        return value;
    }

    @NotNull
    public static String getCancelButtonText() {
        return CommonBundle.message("button.cancel", new Object[0]);
    }

    public static String getBackgroundButtonText() {
        return CommonBundle.message("button.background", new Object[0]);
    }

    public static String getHelpButtonText() {
        return CommonBundle.message("button.help", new Object[0]);
    }

    public static String getErrorTitle() {
        return CommonBundle.message("title.error", new Object[0]);
    }

    public static String getWarningTitle() {
        return CommonBundle.message("title.warning", new Object[0]);
    }

    public static String getLoadingTreeNodeText() {
        return CommonBundle.message("tree.node.loading", new Object[0]);
    }

    public static String getOkButtonText() {
        return CommonBundle.message("button.ok", new Object[0]);
    }

    public static String getYesButtonText() {
        return CommonBundle.message("button.yes", new Object[0]);
    }

    public static String getNoButtonText() {
        return CommonBundle.message("button.no", new Object[0]);
    }

    public static String getContinueButtonText() {
        return CommonBundle.message("button.continue", new Object[0]);
    }

    public static String getYesForAllButtonText() {
        return CommonBundle.message("button.yes.for.all", new Object[0]);
    }

    public static String getCloseButtonText() {
        return CommonBundle.message("button.close", new Object[0]);
    }

    public static String getNoForAllButtonText() {
        return CommonBundle.message("button.no.for.all", new Object[0]);
    }

    public static String getApplyButtonText() {
        return CommonBundle.message("button.apply", new Object[0]);
    }

    public static String settingsTitle() {
        return SystemInfo.isMac ? CommonBundle.message("title.settings.mac", new Object[0]) : CommonBundle.message("title.settings", new Object[0]);
    }

    public static String settingsAction() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.mac", new Object[0]) : CommonBundle.message("action.settings", new Object[0]);
    }

    public static String settingsActionDescription() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.description.mac", new Object[0]) : CommonBundle.message("action.settings.description", new Object[0]);
    }

    public static String settingsActionPath() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.path.mac", new Object[0]) : CommonBundle.message("action.settings.path", new Object[0]);
    }
}

