/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Platform;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CommandLineUtil {
    private static final char SPECIAL_QUOTE = '\uefef';
    private static final String WIN_SHELL_SPECIALS = "&<>()@^|";
    public static boolean VERBOSE_COMMAND_LINE_MODE;

    @NotNull
    public static String specialQuote(@NotNull String parameter) {
        return CommandLineUtil.quote(parameter, '\uefef');
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull List<String> command) {
        assert (!command.isEmpty());
        return CommandLineUtil.toCommandLine(command.get(0), command.subList(1, command.size()));
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command, @NotNull List<String> parameters) {
        return CommandLineUtil.toCommandLine(command, parameters, Platform.current());
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command, @NotNull List<String> parameters, @NotNull Platform platform) {
        ArrayList<String> commandLine = ContainerUtil.newArrayListWithCapacity(parameters.size() + 1);
        commandLine.add(FileUtilRt.toSystemDependentName(command, platform.fileSeparator));
        boolean isWindows = platform == Platform.WINDOWS;
        boolean winShell = isWindows && CommandLineUtil.isWinShell(command);
        for (String parameter : parameters) {
            if (isWindows) {
                if (parameter.contains("\"")) {
                    parameter = StringUtil.replace(parameter, "\"", "\\\"");
                } else if (parameter.isEmpty()) {
                    parameter = "\"\"";
                }
            }
            if (winShell && CommandLineUtil.hasWinShellSpecialChars(parameter)) {
                parameter = CommandLineUtil.quote(parameter, '\uefef');
            }
            if (CommandLineUtil.isQuoted(parameter, '\uefef')) {
                parameter = CommandLineUtil.quote(parameter.substring(1, parameter.length() - 1), '\"');
            }
            commandLine.add(parameter);
        }
        return commandLine;
    }

    private static boolean isWinShell(@NotNull String command) {
        return CommandLineUtil.endsWithIgnoreCase(command, ".cmd") || CommandLineUtil.endsWithIgnoreCase(command, ".bat") || "cmd".equalsIgnoreCase(command) || "cmd.exe".equalsIgnoreCase(command);
    }

    private static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        return str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static String quote(String s, char ch) {
        return !CommandLineUtil.isQuoted(s, ch) ? ch + s + ch : s;
    }

    private static boolean isQuoted(String s, char ch) {
        return s.length() >= 2 && s.charAt(0) == ch && s.charAt(s.length() - 1) == ch;
    }

    @NotNull
    public static String extractPresentableName(@NotNull String commandLine) {
        List<String> args;
        String execName;
        String executable = commandLine.trim();
        List<String> words = StringUtil.splitHonorQuotes(executable, ' ');
        if (words.isEmpty()) {
            execName = executable;
            args = Collections.emptyList();
        } else {
            execName = words.get(0);
            args = words.subList(1, words.size());
        }
        if (VERBOSE_COMMAND_LINE_MODE) {
            return StringUtil.shortenPathWithEllipsis(execName + " " + StringUtil.join(args, " "), 250);
        }
        return new File(StringUtil.unquoteString(execName)).getName();
    }

    public static boolean hasWinShellSpecialChars(String parameter) {
        return StringUtil.containsAnyChar(parameter, WIN_SHELL_SPECIALS);
    }
}

