/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ProcessIOExecutorService
extends ThreadPoolExecutor {
    public static final String POOLED_THREAD_PREFIX = "Process I/O pool ";
    public static final ExecutorService INSTANCE = new ProcessIOExecutorService();
    private final AtomicInteger counter = new AtomicInteger();

    private ProcessIOExecutorService() {
        super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
        this.setThreadFactory(new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, ProcessIOExecutorService.POOLED_THREAD_PREFIX + ProcessIOExecutorService.this.counter.incrementAndGet());
                thread.setPriority(4);
                return thread;
            }
        });
    }

    public int getThreadCounter() {
        return this.counter.get();
    }
}

