/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Base64;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtilRt;
import org.jetbrains.annotations.NotNull;

public class Attachment {
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final byte[] myBytes;
    private boolean myIncluded;
    private final String myDisplayText;

    public Attachment(@NotNull String path, @NotNull String content) {
        this.myPath = path;
        this.myDisplayText = content;
        this.myBytes = Attachment.getBytes(content);
    }

    public Attachment(@NotNull String path, @NotNull byte[] bytes, @NotNull String displayText) {
        this.myPath = path;
        this.myBytes = bytes;
        this.myDisplayText = displayText;
    }

    public Attachment(@NotNull String name, @NotNull Throwable throwable) {
        this(name + ".trace", ExceptionUtil.getThrowableText(throwable));
        this.myIncluded = true;
    }

    @NotNull
    public static byte[] getBytes(@NotNull String content) {
        return content.getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    @NotNull
    public String getDisplayText() {
        return this.myDisplayText;
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @NotNull
    public String getName() {
        return PathUtilRt.getFileName(this.myPath);
    }

    @NotNull
    public String getEncodedBytes() {
        return Base64.encode(this.myBytes);
    }

    @NotNull
    public byte[] getBytes() {
        return this.myBytes;
    }

    public boolean isIncluded() {
        return this.myIncluded;
    }

    public void setIncluded(boolean included) {
        this.myIncluded = included;
    }
}

