/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import org.apache.log4j.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Logger {
    private static Factory ourFactory = new DefaultFactory();
    static final Function<Attachment, String> ATTACHMENT_TO_STRING = new Function<Attachment, String>(){

        @Override
        public String fun(Attachment attachment) {
            return attachment.getPath() + "\n" + attachment.getDisplayText();
        }
    };

    public static void setFactory(@NotNull Class<? extends Factory> factory) {
        if (Logger.isInitialized()) {
            if (factory.isInstance(ourFactory)) {
                return;
            }
            System.out.println("Changing log factory\n" + ExceptionUtil.getThrowableText(new Throwable()));
        }
        try {
            Constructor<? extends Factory> constructor = factory.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            ourFactory = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    @NotNull
    public static Logger getInstance(@NotNull @NonNls String category) {
        return ourFactory.getLoggerInstance(category);
    }

    @NotNull
    public static Logger getInstance(@NotNull Class cl) {
        return Logger.getInstance("#" + cl.getName());
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(@NonNls String var1);

    public abstract void debug(@Nullable Throwable var1);

    public abstract void debug(@NonNls String var1, @Nullable Throwable var2);

    public void debug(@NotNull String message, Object ... details) {
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            for (Object detail : details) {
                sb.append(detail);
            }
            this.debug(sb.toString());
        }
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(String message) {
        this.debug(message);
    }

    public void info(@NotNull Throwable t) {
        this.info(t.getMessage(), t);
    }

    public abstract void info(@NonNls String var1);

    public abstract void info(@NonNls String var1, @Nullable Throwable var2);

    public void warn(@NonNls String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(@NonNls String var1, @Nullable Throwable var2);

    public void error(@NonNls String message) {
        this.error(message, new EmptyThrowable(), ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(Object message) {
        this.error(String.valueOf(message));
    }

    public void error(@NonNls String message, Attachment ... attachments) {
        this.error(message, (Throwable)null, ContainerUtil.map2Array(attachments, String.class, ATTACHMENT_TO_STRING));
    }

    public void error(@NonNls String message, String ... details) {
        this.error(message, new EmptyThrowable(), details);
    }

    public void error(@NonNls String message, @Nullable Throwable e) {
        this.error(message, e, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t) {
        this.error(t.getMessage(), t, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public abstract void error(@NonNls String var1, @Nullable Throwable var2, String ... var3);

    @Contract(value="false,_->fail")
    public boolean assertTrue(boolean value, @Nullable @NonNls Object message) {
        if (!value) {
            String resultMessage = "Assertion failed";
            if (message != null) {
                resultMessage = resultMessage + ": " + message;
            }
            this.error(resultMessage, new Throwable());
        }
        return value;
    }

    @Contract(value="false->fail")
    public boolean assertTrue(boolean value) {
        return value || this.assertTrue(false, null);
    }

    public abstract void setLevel(Level var1);

    protected static Throwable checkException(@Nullable Throwable t) {
        return t instanceof ControlFlowException ? new Throwable("Control-flow exceptions should never be logged", t) : t;
    }

    public static class EmptyThrowable
    extends Throwable {
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        @NotNull
        public Logger getLoggerInstance(@NotNull String category) {
            return new DefaultLogger(category);
        }
    }

    public static interface Factory {
        @NotNull
        public Logger getLoggerInstance(@NotNull String var1);
    }
}

