/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.string;

import com.intellij.openapi.diff.LineTokenizerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffString
extends CharArrayCharSequence {
    @NotNull
    public static final DiffString EMPTY = new DiffString(new char[0], 0, 0);

    @Nullable
    public static DiffString createNullable(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return DiffString.create(string);
    }

    @NotNull
    public static DiffString create(@NotNull String string) {
        if (string.isEmpty()) {
            return EMPTY;
        }
        return DiffString.create(string.toCharArray());
    }

    @NotNull
    static DiffString create(@NotNull char[] data) {
        return DiffString.create(data, 0, data.length);
    }

    @NotNull
    static DiffString create(@NotNull char[] data, int start, int length) {
        if (length == 0) {
            return EMPTY;
        }
        DiffString.checkBounds(start, length, data.length);
        return new DiffString(data, start, length);
    }

    private DiffString(@NotNull char[] data, int start, int length) {
        super(data, start, start + length);
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    private char data(int index) {
        return this.charAt(index);
    }

    @NotNull
    public DiffString substring(int start) {
        return this.substring(start, this.length());
    }

    @NotNull
    public DiffString substring(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        DiffString.checkBounds(start, end - start, this.length());
        return DiffString.create(this.myChars, this.myStart + start, end - start);
    }

    @Override
    @NotNull
    public DiffString subSequence(int start, int end) {
        return this.substring(start, end);
    }

    @NotNull
    public DiffString copy() {
        return DiffString.create(Arrays.copyOfRange(this.myChars, this.myStart, this.myStart + this.length()));
    }

    public void copyData(@NotNull char[] dst, int start) {
        DiffString.checkBounds(start, this.length(), dst.length);
        System.arraycopy(this.myChars, this.myStart, dst, start, this.length());
    }

    @Nullable
    public static DiffString concatenateNullable(@Nullable DiffString s1, @Nullable DiffString s2) {
        if (s1 == null || s2 == null) {
            if (s1 != null) {
                return s1;
            }
            if (s2 != null) {
                return s2;
            }
            return null;
        }
        return DiffString.concatenate(s1, s2);
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString s1, @NotNull DiffString s2) {
        if (s1.isEmpty()) {
            return s2;
        }
        if (s2.isEmpty()) {
            return s1;
        }
        if (s1.myChars == s2.myChars && s1.myStart + s1.length() == s2.myStart) {
            return DiffString.create(s1.myChars, s1.myStart, s1.length() + s2.length());
        }
        char[] data = new char[s1.length() + s2.length()];
        System.arraycopy(s1.myChars, s1.myStart, data, 0, s1.length());
        System.arraycopy(s2.myChars, s2.myStart, data, s1.length(), s2.length());
        return DiffString.create(data);
    }

    public static boolean canInplaceConcatenate(@NotNull DiffString s1, @NotNull DiffString s2) {
        if (s1.isEmpty()) {
            return true;
        }
        if (s2.isEmpty()) {
            return true;
        }
        return s1.myChars == s2.myChars && s1.myStart + s1.length() == s2.myStart;
    }

    @NotNull
    public static DiffString concatenateCopying(@NotNull DiffString[] strings) {
        return DiffString.concatenateCopying(strings, 0, strings.length);
    }

    @NotNull
    public static DiffString concatenateCopying(@NotNull DiffString[] strings, int start, int length) {
        DiffString.checkBounds(start, length, strings.length);
        int len = 0;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            len += string == null ? 0 : string.length();
        }
        if (len == 0) {
            return EMPTY;
        }
        char[] data = new char[len];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            if (string == null || string.isEmpty()) continue;
            System.arraycopy(string.myChars, string.myStart, data, index, string.length());
            index += string.length();
        }
        return DiffString.create(data);
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString s, char c) {
        if (s.myStart + s.length() < s.myChars.length && s.data(s.length()) == c) {
            return DiffString.create(s.myChars, s.myStart, s.length() + 1);
        }
        char[] data = new char[s.length() + 1];
        System.arraycopy(s.myChars, s.myStart, data, 0, s.length());
        data[s.length()] = c;
        return DiffString.create(data);
    }

    @NotNull
    public static DiffString concatenate(char c, @NotNull DiffString s) {
        if (s.myStart > 0 && s.data(-1) == c) {
            return DiffString.create(s.myChars, s.myStart - 1, s.length() + 1);
        }
        char[] data = new char[s.length() + 1];
        System.arraycopy(s.myChars, s.myStart, data, 1, s.length());
        data[0] = c;
        return DiffString.create(data);
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString[] strings) {
        return DiffString.concatenate(strings, 0, strings.length);
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString[] strings, int start, int length) {
        DiffString.checkBounds(start, length, strings.length);
        char[] data = null;
        int startIndex = 0;
        int endIndex = 0;
        boolean linearized = true;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            if (string == null || string.isEmpty()) continue;
            if (data == null) {
                data = string.myChars;
                startIndex = string.myStart;
                endIndex = string.myStart + string.length();
                continue;
            }
            if (data != string.myChars || string.myStart != endIndex) {
                linearized = false;
                break;
            }
            endIndex += string.length();
        }
        if (linearized) {
            if (data == null) {
                return EMPTY;
            }
            return DiffString.create(data, startIndex, endIndex - startIndex);
        }
        return DiffString.concatenateCopying(strings, start, length);
    }

    @NotNull
    public DiffString append(char c) {
        return DiffString.concatenate(this, c);
    }

    @NotNull
    public DiffString preappend(char c) {
        return DiffString.concatenate(c, this);
    }

    public static boolean isWhiteSpace(char c) {
        return StringUtil.isWhiteSpace(c);
    }

    public boolean isEmptyOrSpaces() {
        if (this.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (DiffString.isWhiteSpace(this.data(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public DiffString trim() {
        int start;
        int end = this.length();
        for (start = 0; start < end && DiffString.isWhiteSpace(this.data(start)); ++start) {
        }
        while (end > start && DiffString.isWhiteSpace(this.data(end - 1))) {
            --end;
        }
        return this.substring(start, end);
    }

    @NotNull
    public DiffString trimLeading() {
        int i;
        for (i = 0; i < this.length() && DiffString.isWhiteSpace(this.data(i)); ++i) {
        }
        return this.substring(i, this.length());
    }

    @NotNull
    public DiffString trimTrailing() {
        int end;
        for (end = this.length(); end > 0 && DiffString.isWhiteSpace(this.data(end - 1)); --end) {
        }
        return this.substring(0, end);
    }

    @NotNull
    public DiffString getLeadingSpaces() {
        int i;
        for (i = 0; i < this.length() && this.data(i) == ' '; ++i) {
        }
        return this.substring(0, i);
    }

    @NotNull
    public DiffString skipSpaces() {
        DiffString s = this.trim();
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!DiffString.isWhiteSpace(s.data(i))) continue;
            ++count;
        }
        if (count == 0) {
            return s;
        }
        char[] data = new char[s.length() - count];
        int index = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (DiffString.isWhiteSpace(s.data(i))) continue;
            data[index] = s.data(i);
            ++index;
        }
        return DiffString.create(data);
    }

    public int indexOf(char c) {
        return StringUtil.indexOf((CharSequence)this, c);
    }

    public boolean endsWith(char c) {
        if (this.isEmpty()) {
            return false;
        }
        return this.data(this.length() - 1) == c;
    }

    public static void checkBounds(int start, int length, int maxLength) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (start + length > maxLength) {
            throw new StringIndexOutOfBoundsException(start + length);
        }
    }

    @NotNull
    public DiffString[] tokenize() {
        return new LineTokenizer(this).execute();
    }

    public static class LineTokenizer
    extends LineTokenizerBase<DiffString> {
        @NotNull
        private final DiffString myText;

        public LineTokenizer(@NotNull DiffString text) {
            this.myText = text;
        }

        @NotNull
        public DiffString[] execute() {
            ArrayList lines = new ArrayList();
            this.doExecute(lines);
            return ContainerUtil.toArray(lines, new DiffString[lines.size()]);
        }

        @Override
        protected void addLine(List<DiffString> lines, int start, int end, boolean appendNewLine) {
            if (appendNewLine) {
                lines.add(this.myText.substring(start, end).append('\n'));
            } else {
                lines.add(this.myText.substring(start, end));
            }
        }

        @Override
        protected char charAt(int index) {
            return this.myText.data(index);
        }

        @Override
        protected int length() {
            return this.myText.length();
        }

        @Override
        @NotNull
        protected String substring(int start, int end) {
            return this.myText.substring(start, end).toString();
        }
    }
}

