/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.StringFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class JDOMUtil {
    private static final ThreadLocal<java.lang.ref.SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    public static final Condition<Attribute> NOT_EMPTY_VALUE_CONDITION = new Condition<Attribute>(){

        @Override
        public boolean value(Attribute attribute) {
            return !StringUtil.isEmpty(attribute.getValue());
        }
    };
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        return parent.getChildren();
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (parent != null) {
            return parent.getChildren(name);
        }
        return Collections.emptyList();
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal(e1.getName(), e2.getName()) && JDOMUtil.attListsEqual(e1.getAttributes(), e2.getAttributes(), ignoreEmptyAttrValues) && JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    public static int getTreeHash(@NotNull Element root) {
        return JDOMUtil.addToHash(0, root, true);
    }

    private static int addToHash(int i, @NotNull Element element, boolean skipEmptyText) {
        i = JDOMUtil.addToHash(i, element.getName());
        for (Attribute attribute : element.getAttributes()) {
            i = JDOMUtil.addToHash(i, attribute.getName());
            i = JDOMUtil.addToHash(i, attribute.getValue());
        }
        for (Content child : element.getContent()) {
            if (child instanceof Element) {
                i = JDOMUtil.addToHash(i, (Element)child, skipEmptyText);
                continue;
            }
            if (!(child instanceof Text)) continue;
            String text = ((Text)child).getText();
            if (skipEmptyText && StringUtil.isEmptyOrSpaces(text)) continue;
            i = JDOMUtil.addToHash(i, text);
        }
        return i;
    }

    private static int addToHash(int i, @NotNull String s) {
        return i * 31 + s.hashCode();
    }

    @Deprecated
    @NotNull
    public static Element[] getElements(@NotNull Element m) {
        List list = m.getChildren();
        return list.toArray(new Element[list.size()]);
    }

    public static void internElement(@NotNull Element element, @NotNull StringInterner interner) {
        element.setName(interner.intern(element.getName()));
        for (Attribute attr : element.getAttributes()) {
            attr.setName(interner.intern(attr.getName()));
            attr.setValue(interner.intern(attr.getValue()));
        }
        for (Content o : element.getContent()) {
            if (o instanceof Element) {
                JDOMUtil.internElement((Element)o, interner);
                continue;
            }
            if (!(o instanceof Text)) continue;
            ((Text)o).setText(interner.intern(o.getValue()));
        }
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        return JDOMUtil.legalizeChars(str).toString();
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        StringBuilder result = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result, str.charAt(i));
        }
        return result;
    }

    private static void appendLegalized(@NotNull StringBuilder sb, char each) {
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter((int)each)) {
            sb.append("0x").append(StringUtil.toUpperCase(Long.toHexString(each)));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(List c1, List c2, boolean ignoreEmptyAttrValues) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean attListsEqual(@NotNull List<Attribute> l1, @NotNull List<Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (ignoreEmptyAttrValues) {
            l1 = ContainerUtil.filter(l1, NOT_EMPTY_VALUE_CONDITION);
            l2 = ContainerUtil.filter(l2, NOT_EMPTY_VALUE_CONDITION);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    private static SAXBuilder getSaxBuilder() {
        java.lang.ref.SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder saxBuilder = SoftReference.dereference(reference);
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder(){

                protected void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
                    super.configureParser(parser, contentHandler);
                    try {
                        parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                @NotNull
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                }
            });
            ourSaxBuilder.set(new java.lang.ref.SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull CharSequence seq) throws IOException, JDOMException {
        return JDOMUtil.loadDocument(new CharSequenceReader(seq));
    }

    @NotNull
    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        return JDOMUtil.load(new CharSequenceReader(seq));
    }

    @NotNull
    private static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        try {
            Document document = JDOMUtil.getSaxBuilder().build(reader);
            return document;
        }
        finally {
            reader.close();
        }
    }

    @NotNull
    public static Document loadDocument(File file) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(new BufferedInputStream(new FileInputStream(file)));
    }

    @NotNull
    public static Element load(@NotNull File file) throws JDOMException, IOException {
        return JDOMUtil.load(new BufferedInputStream(new FileInputStream(file)));
    }

    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(Reader reader) throws JDOMException, IOException {
        return reader == null ? null : JDOMUtil.loadDocument(reader).detachRootElement();
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.loadDocument(stream).detachRootElement();
    }

    @NotNull
    public static Document loadDocument(@NotNull Class clazz, String resource) throws JDOMException, IOException {
        InputStream stream = clazz.getResourceAsStream(resource);
        if (stream == null) {
            throw new FileNotFoundException(resource);
        }
        return JDOMUtil.loadDocument(stream);
    }

    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(URLUtil.openStream(url));
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(@NotNull Document document, @NotNull String filePath, String lineSeparator) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file, String lineSeparator) throws IOException {
        JDOMUtil.write((Parent)document, file, lineSeparator);
    }

    public static void write(@NotNull Parent element, @NotNull File file) throws IOException {
        JDOMUtil.write(element, file, "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(@NotNull Parent element, @NotNull File file, @NotNull String lineSeparator) throws IOException {
        FileUtil.createParentDirs(file);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JDOMUtil.write(element, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        JDOMUtil.write((Parent)document, stream, lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream, CharsetToolkit.UTF8_CHARSET);
        try {
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element, writer, lineSeparator);
            }
        }
        finally {
            writer.close();
        }
    }

    @NotNull
    public static byte[] printDocument(@NotNull Document document, String lineSeparator) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        JDOMUtil.writeDocument(document, writer, lineSeparator);
        return StringFactory.createShared(writer.toCharArray()).getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    @NotNull
    public static String write(Parent element, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof Element) {
            JDOMUtil.writeElement((Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        return JDOMUtil.writeElement(element, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String writeChildren(@NotNull Element element, @NotNull String lineSeparator) throws IOException {
        StringWriter writer = new StringWriter();
        for (Element child : element.getChildren()) {
            JDOMUtil.writeElement(child, writer, lineSeparator);
            writer.append(lineSeparator);
        }
        return writer.toString();
    }

    public static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        MyXMLOutputter xmlOutputter = new MyXMLOutputter();
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        xmlOutputter.setFormat(format);
        return xmlOutputter;
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text) {
        return JDOMUtil.escapeText(text, false, false);
    }

    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeSpaces, boolean escapeLineEnds) {
        return JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
    }

    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        StringBuilder buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            if (buffer == null) {
                if (quotation == null) continue;
                buffer = new StringBuilder(text.length() + 20);
                buffer.append(text, 0, i);
                buffer.append(quotation);
                continue;
            }
            if (quotation == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(quotation);
        }
        return buffer == null ? text : buffer.toString();
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        int length;
        ElementInfo info = new ElementInfo();
        StringBuilder buf = new StringBuilder(element.getName());
        List attributes = element.getAttributes();
        if (attributes != null && (length = attributes.size()) > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = (Attribute)attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                info.hasNullAttributes = true;
            }
            buf.append("]");
        }
        info.name = buf.toString();
        return info;
    }

    public static void updateFileSet(@NotNull File[] oldFiles, @NotNull String[] newFilePaths, @NotNull Document[] newFileDocuments, String lineSeparator) throws IOException {
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || element.getAttributes().isEmpty() && element.getContent().isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element, int attributeCount) {
        return element == null || element.getAttributes().size() == attributeCount && element.getContent().isEmpty();
    }

    private static class ElementInfo {
        @NotNull
        public String name = "";
        public boolean hasNullAttributes = false;

        private ElementInfo() {
        }
    }

    public static class MyXMLOutputter
    extends XMLOutputter {
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            return JDOMUtil.escapeText(str, false, true);
        }

        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            return JDOMUtil.escapeText(str, false, false);
        }
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");

        private LoggerHolder() {
        }
    }
}

