/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.WeakList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LowMemoryWatcher {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcher");
    private static final WeakList<Runnable> ourListeners = new WeakList();
    private final Runnable myRunnable;

    static void onLowMemorySignalReceived() {
        LOG.info("Low memory signal received.");
        for (Runnable watcher : ourListeners.toStrongList()) {
            try {
                watcher.run();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    @Contract(pure=true)
    public static LowMemoryWatcher register(@NotNull Runnable runnable) {
        return new LowMemoryWatcher(runnable);
    }

    public static void register(@NotNull Runnable runnable, @NotNull Disposable parentDisposable) {
        final LowMemoryWatcher watcher = new LowMemoryWatcher(runnable);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                watcher.stop();
            }
        });
    }

    private LowMemoryWatcher(@NotNull Runnable runnable) {
        this.myRunnable = runnable;
        ourListeners.add(runnable);
    }

    public void stop() {
        ourListeners.remove(this.myRunnable);
    }

    static void stopAll() {
        ourListeners.clear();
    }
}

