/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<A, B> {
    public final A first;
    public final B second;
    private static final Pair EMPTY = Pair.create(null, null);

    @NotNull
    public static <A, B> Pair<A, B> create(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    @NotNull
    public static <A, B> NonNull<A, B> createNonNull(@NotNull A first, @NotNull B second) {
        return new NonNull<A, B>(first, second);
    }

    @NotNull
    public static <A, B> Pair<A, B> pair(A first, B second) {
        return Pair.create(first, second);
    }

    @NotNull
    public static <A, B> Function<A, Pair<A, B>> createFunction(final B value) {
        return new Function<A, Pair<A, B>>(){

            @Override
            public Pair<A, B> fun(A a) {
                return Pair.create(a, value);
            }
        };
    }

    public static <T> T getFirst(@Nullable Pair<T, ?> pair) {
        return pair != null ? (T)pair.first : null;
    }

    public static <T> T getSecond(@Nullable Pair<?, T> pair) {
        return pair != null ? (T)pair.second : null;
    }

    public static <A, B> Pair<A, B> empty() {
        return EMPTY;
    }

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    public final boolean equals(Object o) {
        return o instanceof Pair && Comparing.equal(this.first, ((Pair)o).first) && Comparing.equal(this.second, ((Pair)o).second);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "<" + this.first + "," + this.second + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonNull<A, B>
    extends Pair<A, B> {
        public NonNull(@NotNull A first, @NotNull B second) {
            super(first, second);
        }
    }
}

