/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version {
    public final int major;
    public final int minor;
    public final int bugfix;

    public Version(int major, int minor, int bugfix) {
        this.bugfix = bugfix;
        this.minor = minor;
        this.major = major;
    }

    @Nullable
    public static Version parseVersion(@NotNull String versionString) {
        int patch;
        int minor;
        String[] versions = versionString.split("\\.");
        String version = versions[0];
        int major = Version.parseNumber(version, -1);
        if (major < 0) {
            return null;
        }
        int n = minor = versions.length > 1 ? Version.parseNumber(versions[1], -1) : 0;
        if (minor < 0) {
            return new Version(major, 0, 0);
        }
        int n2 = patch = versions.length > 2 ? Version.parseNumber(versions[2], -1) : 0;
        if (patch < 0) {
            return new Version(major, minor, 0);
        }
        return new Version(major, minor, patch);
    }

    private static int parseNumber(String num, int def) {
        return StringUtil.parseInt(num.replaceFirst("(\\d+).*", "$1"), def);
    }

    public boolean is(@Nullable Integer major) {
        return this.is(major, null);
    }

    public boolean is(@Nullable Integer major, @Nullable Integer minor) {
        return this.is(major, minor, null);
    }

    public boolean is(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) == 0;
    }

    public boolean isOrGreaterThan(@Nullable Integer major) {
        return this.isOrGreaterThan(major, null);
    }

    public boolean isOrGreaterThan(@Nullable Integer major, @Nullable Integer minor) {
        return this.isOrGreaterThan(major, minor, null);
    }

    public boolean isOrGreaterThan(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) >= 0;
    }

    public boolean lessThan(@Nullable Integer major) {
        return this.lessThan(major, null);
    }

    public boolean lessThan(@Nullable Integer major, @Nullable Integer minor) {
        return this.lessThan(major, minor, null);
    }

    public boolean lessThan(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) < 0;
    }

    public int compareTo(@NotNull Version version) {
        return this.compareTo(version.major, version.minor, version.bugfix);
    }

    public int compareTo(@Nullable Integer major) {
        return this.compareTo(major, null);
    }

    public int compareTo(@Nullable Integer major, @Nullable Integer minor) {
        return this.compareTo(major, minor, null);
    }

    public int compareTo(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        int result = Version.doCompare(this.major, major);
        if (result != 0) {
            return result;
        }
        result = Version.doCompare(this.minor, minor);
        if (result != 0) {
            return result;
        }
        return Version.doCompare(this.bugfix, bugfix);
    }

    private static int doCompare(Integer l, Integer r) {
        if (l == null || r == null) {
            return 0;
        }
        return l - r;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }

    public String toCompactString() {
        return Version.toCompactString(this.major, this.minor, this.bugfix);
    }

    public static String toCompactString(int major, int minor, int bugfix) {
        String res = major + "." + minor;
        if (bugfix > 0) {
            res = res + "." + bugfix;
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.bugfix != version.bugfix) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        return this.minor == version.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.bugfix;
        return result;
    }
}

