/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import org.jetbrains.annotations.NotNull;

public class ByteSequence {
    private final byte[] myBytes;
    private final int myOffset;
    private final int myLen;

    public ByteSequence(@NotNull byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ByteSequence(@NotNull byte[] bytes, int offset, int len) {
        this.myBytes = bytes;
        this.myOffset = offset;
        this.myLen = len;
    }

    @NotNull
    public byte[] getBytes() {
        return this.myBytes;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteSequence sequence = (ByteSequence)o;
        int len = this.myLen;
        if (len != sequence.myLen) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = sequence.myBytes;
        int i = 0;
        int j = this.myOffset;
        int k = sequence.myOffset;
        while (i < len) {
            if (thisBytes[j] != thatBytes[k]) {
                return false;
            }
            ++i;
            ++j;
            ++k;
        }
        return true;
    }

    public int hashCode() {
        int len = this.myLen;
        byte[] thisBytes = this.myBytes;
        int result = 1;
        int i = 0;
        int j = this.myOffset;
        while (i < len) {
            result = result * 31 + thisBytes[j];
            ++i;
            ++j;
        }
        return result;
    }
}

