/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtilRt {
    private static final int KILOBYTE = 1024;
    private static final int DEFAULT_INTELLISENSE_LIMIT = 2560000;
    public static final int MEGABYTE = 0x100000;
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, Math.max(FileUtilRt.getUserFileSizeLimit(), FileUtilRt.getUserContentLoadLimit()));
    public static final int LARGE_FILE_PREVIEW_SIZE = Math.min(FileUtilRt.getLargeFilePreviewSize(), LARGE_FOR_CONTENT_LOADING);
    private static final int MAX_FILE_IO_ATTEMPTS = 10;
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    public static final FileFilter ALL_FILES = new FileFilter(){

        public boolean accept(File file) {
            return true;
        }
    };
    public static final FileFilter ALL_DIRECTORIES = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    protected static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static String ourCanonicalTempPathCache = null;
    private static final Random RANDOM = new Random();

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    @NotNull
    public static CharSequence getExtension(@NotNull CharSequence fileName) {
        return FileUtilRt.getExtension(fileName, "");
    }

    public static CharSequence getExtension(@NotNull CharSequence fileName, @Nullable String defaultValue) {
        int index = StringUtilRt.lastIndexOf(fileName, '.', 0, fileName.length());
        if (index < 0) {
            return defaultValue;
        }
        return fileName.subSequence(index + 1, fileName.length());
    }

    public static boolean extensionEquals(@NotNull String filePath, @NotNull String extension) {
        int extLen = extension.length();
        if (extLen == 0) {
            int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            return filePath.indexOf(46, lastSlash + 1) == -1;
        }
        int extStart = filePath.length() - extLen;
        return extStart >= 1 && filePath.charAt(extStart - 1) == '.' && filePath.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName) {
        return FileUtilRt.toSystemDependentName(fileName, File.separatorChar);
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName, char separatorChar) {
        return fileName.replace('/', separatorChar).replace('\\', separatorChar);
    }

    @NotNull
    public static String toSystemIndependentName(@NonNls @NotNull String fileName) {
        return fileName.replace('\\', '/');
    }

    @Nullable
    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath, filePath, File.separatorChar);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        return FileUtilRt.getRelativePath(basePath, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        CharComparingStrategy strategy;
        basePath = FileUtilRt.ensureEnds(basePath, separator);
        if (caseSensitive ? basePath.equals(FileUtilRt.ensureEnds(filePath, separator)) : basePath.equalsIgnoreCase(FileUtilRt.ensureEnds(filePath, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        CharComparingStrategy charComparingStrategy = strategy = caseSensitive ? CharComparingStrategy.IDENTITY : CharComparingStrategy.CASE_INSENSITIVE;
        for (len = 0; len < filePath.length() && len < basePath.length() && strategy.charsEqual(filePath.charAt(len), basePath.charAt(len)); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    private static String ensureEnds(@NotNull String s, char endsWith) {
        return StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    @NotNull
    public static CharSequence getNameWithoutExtension(@NotNull CharSequence name) {
        int i = StringUtilRt.lastIndexOf(name, '.', 0, name.length());
        return i < 0 ? name : name.subSequence(0, i);
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        return FileUtilRt.getNameWithoutExtension((CharSequence)name).toString();
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempDirectory(prefix, suffix, true);
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        File dir = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, true);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, true);
        if (deleteOnExit) {
            FilesToDeleteHolder.ourFilesToDelete.add(file.getPath());
        }
        if (!file.isDirectory()) {
            throw new IOException("Cannot create directory: " + file);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempFile(prefix, suffix, false);
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        File dir = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempFile(dir, prefix, suffix, true, deleteOnExit);
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix, true, true);
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix, create, true);
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create, boolean deleteOnExit) throws IOException {
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, false);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        if (!create && !file.delete() && file.exists()) {
            throw new IOException("Cannot delete file: " + file);
        }
        return file;
    }

    @NotNull
    private static File doCreateTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean isDirectory) throws IOException {
        dir.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = new File(prefix).getName();
        int exceptionsCount = 0;
        int i = 0;
        int maxFileNumber = 10;
        while (true) {
            try {
                boolean success;
                File f = FileUtilRt.calcName(dir, prefix, suffix, i);
                boolean bl = success = isDirectory ? f.mkdir() : f.createNewFile();
                if (!success) {
                    String[] children = f.getParentFile().list();
                    List<Object> list = children == null ? Collections.emptyList() : Arrays.asList(children);
                    maxFileNumber = Math.max(10, list.size() * 10);
                    throw new IOException("Unable to create temporary file " + f + "\nDirectory '" + f.getParentFile() + "' list (" + list.size() + " children): " + list);
                }
                return FileUtilRt.normalizeFile(f);
            }
            catch (IOException e) {
                if (++exceptionsCount >= 100) {
                    throw e;
                }
                if (++i <= 2) continue;
                i = 2 + RANDOM.nextInt(maxFileNumber);
                continue;
            }
            break;
        }
    }

    @NotNull
    private static File calcName(@NotNull File dir, @NotNull String prefix, @NotNull String suffix, int i) throws IOException {
        File f;
        String name;
        if ((prefix = prefix + (i == 0 ? "" : Integer.valueOf(i))).endsWith(".") && suffix.startsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!(name = prefix + suffix).equals((f = new File(dir, name)).getName())) {
            throw new IOException("Unable to create temporary file " + f + " for name " + name);
        }
        return f;
    }

    @NotNull
    private static File normalizeFile(@NotNull File temp) throws IOException {
        File canonical = temp.getCanonicalFile();
        return SystemInfoRt.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
    }

    @NotNull
    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        return ourCanonicalTempPathCache;
    }

    @NotNull
    private static String calcCanonicalTempPath() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        try {
            String canonical = file.getCanonicalPath();
            if (!SystemInfoRt.isWindows || !canonical.contains(" ")) {
                return canonical;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.getAbsolutePath();
    }

    public static void resetCanonicalTempPathCache(String tempPath) {
        ourCanonicalTempPathCache = tempPath;
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        for (int i = 0; file.exists() && i < 5; ++i) {
            file = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        }
        if (file.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        return FileUtilRt.normalizeFile(file);
    }

    public static void setExecutableAttribute(@NotNull String path, boolean executableFlag) throws IOException {
        try {
            File file = new File(path);
            if (!file.setExecutable(executableFlag) && file.canExecute() != executableFlag) {
                FileUtilRt.logger().warn("Can't set executable attribute of '" + path + "' to " + executableFlag);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        return FileUtilRt.loadFile(file, null, false);
    }

    @NotNull
    public static String loadFile(@NotNull File file, boolean convertLineSeparators) throws IOException {
        return FileUtilRt.loadFile(file, null, convertLineSeparators);
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        return FileUtilRt.loadFile(file, encoding, false);
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable @NonNls String encoding, boolean convertLineSeparators) throws IOException {
        String s = new String(FileUtilRt.loadFileText(file, encoding));
        return convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file) throws IOException {
        return FileUtilRt.loadFileText(file, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
        try {
            char[] cArray = FileUtilRt.loadText(reader, (int)file.length());
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @NotNull @NonNls Charset encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        try {
            char[] cArray = FileUtilRt.loadText(reader, (int)file.length());
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        int count;
        int n;
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            return chars;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        return newChars;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file) throws IOException {
        return FileUtilRt.loadLines(file.getPath());
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        return FileUtilRt.loadLines(file.getPath(), encoding);
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        return FileUtilRt.loadLines(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable @NonNls String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(path);
        try {
            List<String> list;
            InputStreamReader in = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
            BufferedReader reader = new BufferedReader(in);
            try {
                list = FileUtilRt.loadLines(reader);
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return list;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileUtilRt.copy(stream, buffer);
        return buffer.toByteArray();
    }

    public static boolean isTooLarge(long len) {
        return len > (long)LARGE_FOR_CONTENT_LOADING;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (length == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        return bytes;
    }

    @Nullable
    public static File getParentFile(@NotNull File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean delete(@NotNull File file) {
        if (NIOReflect.IS_AVAILABLE) {
            return FileUtilRt.deleteRecursivelyNIO(file);
        }
        return FileUtilRt.deleteRecursively(file);
    }

    protected static boolean deleteRecursivelyNIO(File file) {
        try {
            Object pathObject = NIOReflect.ourFileToPathMethod.invoke((Object)file, new Object[0]);
            NIOReflect.ourFilesWalkMethod.invoke(null, pathObject, NIOReflect.ourDeletionVisitor);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null || !NIOReflect.ourNoSuchFileExceptionClass.isInstance(cause)) {
                FileUtilRt.logger().info(e);
                return false;
            }
        }
        catch (Exception e) {
            FileUtilRt.logger().info(e);
            return false;
        }
        return true;
    }

    private static boolean deleteRecursively(@NotNull File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (FileUtilRt.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtilRt.deleteFile(file);
    }

    @Nullable
    public static <T, E extends Throwable> T doIOOperation(@NotNull RepeatableIOOperation<T, E> ioTask) throws E {
        for (int i = 10; i > 0; --i) {
            T result = ioTask.execute(i == 1);
            if (result != null) {
                return result;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean deleteFile(final @NotNull File file) {
        Boolean result = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

            @Override
            public Boolean execute(boolean lastAttempt) {
                if (file.delete() || !file.exists()) {
                    return Boolean.TRUE;
                }
                if (lastAttempt) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        return Boolean.TRUE.equals(result);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file)) {
            return false;
        }
        return FileUtilRt.delete(file);
    }

    public static boolean createIfNotExists(@NotNull File file) {
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static boolean createParentDirs(@NotNull File file) {
        File parentFile;
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            return FileUtilRt.createDirectory(parentFile);
        }
        return true;
    }

    public static boolean createDirectory(@NotNull File path) {
        return path.isDirectory() || path.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (!FileUtilRt.ensureCanCreateFile(toFile)) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtilRt.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        long timeStamp = fromFile.lastModified();
        if (timeStamp < 0L) {
            FileUtilRt.logger().warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
        } else if (!toFile.setLastModified(timeStamp)) {
            FileUtilRt.logger().warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        block8: {
            int read;
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel = ((FileOutputStream)outputStream).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                        break block8;
                    }
                    finally {
                        toChannel.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = FileUtilRt.getThreadLocalBuffer();
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
            }
        }
    }

    @NotNull
    public static byte[] getThreadLocalBuffer() {
        return BUFFER.get();
    }

    public static int getUserFileSizeLimit() {
        try {
            return Integer.parseInt(System.getProperty("idea.max.intellisense.filesize")) * 1024;
        }
        catch (NumberFormatException e) {
            return 2560000;
        }
    }

    public static int getUserContentLoadLimit() {
        try {
            return Integer.parseInt(System.getProperty("idea.max.content.load.filesize")) * 1024;
        }
        catch (NumberFormatException e) {
            return 0x1400000;
        }
    }

    private static int getLargeFilePreviewSize() {
        try {
            return Integer.parseInt(System.getProperty("idea.max.content.load.large.preview.size")) * 1024;
        }
        catch (NumberFormatException e) {
            return 2560000;
        }
    }

    private static LoggerRt logger() {
        return LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilRt");
    }

    private static interface CharComparingStrategy {
        public static final CharComparingStrategy IDENTITY = new CharComparingStrategy(){

            public boolean charsEqual(char ch1, char ch2) {
                return ch1 == ch2;
            }
        };
        public static final CharComparingStrategy CASE_INSENSITIVE = new CharComparingStrategy(){

            public boolean charsEqual(char ch1, char ch2) {
                return StringUtilRt.charsEqualIgnoreCase(ch1, ch2);
            }
        };

        public boolean charsEqual(char var1, char var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RepeatableIOOperation<T, E extends Throwable> {
        @Nullable
        public T execute(boolean var1) throws E;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilesToDeleteHolder {
        private static final Queue<String> ourFilesToDelete = FilesToDeleteHolder.createFilesToDelete();

        private FilesToDeleteHolder() {
        }

        private static Queue<String> createFilesToDelete() {
            final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>();
            Runtime.getRuntime().addShutdownHook(new Thread("FileUtil deleteOnExit"){

                public void run() {
                    String name = (String)queue.poll();
                    while (name != null) {
                        FileUtilRt.delete(new File(name));
                        name = (String)queue.poll();
                    }
                }
            });
            return queue;
        }
    }

    protected static final class NIOReflect {
        static final boolean IS_AVAILABLE;
        private static Method ourFilesDeleteIfExistsMethod;
        private static Method ourFilesWalkMethod;
        private static Method ourFileToPathMethod;
        private static Method ourPathToFileMethod;
        private static Method ourAttributesIsOtherMethod;
        private static Object ourDeletionVisitor;
        private static Class ourNoSuchFileExceptionClass;
        private static Class ourAccessDeniedExceptionClass;

        protected NIOReflect() {
        }

        static {
            boolean initSuccess = false;
            try {
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Class<?> visitorClass = Class.forName("java.nio.file.FileVisitor");
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                ourNoSuchFileExceptionClass = Class.forName("java.nio.file.NoSuchFileException");
                ourAccessDeniedExceptionClass = Class.forName("java.nio.file.AccessDeniedException");
                ourFileToPathMethod = Class.forName("java.io.File").getMethod("toPath", new Class[0]);
                ourPathToFileMethod = pathClass.getMethod("toFile", new Class[0]);
                ourFilesWalkMethod = filesClass.getMethod("walkFileTree", pathClass, visitorClass);
                ourAttributesIsOtherMethod = Class.forName("java.nio.file.attribute.BasicFileAttributes").getDeclaredMethod("isOther", new Class[0]);
                ourFilesDeleteIfExistsMethod = filesClass.getMethod("deleteIfExists", pathClass);
                final Object Result_Continue = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("CONTINUE").get(null);
                final Object Result_Skip = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("SKIP_SUBTREE").get(null);
                ourDeletionVisitor = Proxy.newProxyInstance(FileUtilRt.class.getClassLoader(), new Class[]{visitorClass}, new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (args.length == 2) {
                            Object second = args[1];
                            if (second instanceof Throwable) {
                                throw (Throwable)second;
                            }
                            String methodName = method.getName();
                            if ("visitFile".equals(methodName) || "postVisitDirectory".equals(methodName)) {
                                this.performDelete(args[0]);
                            } else if (SystemInfoRt.isWindows && "preVisitDirectory".equals(methodName)) {
                                boolean notDirectory = false;
                                try {
                                    notDirectory = Boolean.TRUE.equals(ourAttributesIsOtherMethod.invoke(second, new Object[0]));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (notDirectory) {
                                    this.performDelete(args[0]);
                                    return Result_Skip;
                                }
                            }
                        }
                        return Result_Continue;
                    }

                    private void performDelete(final Object fileObject) throws IOException {
                        Boolean result = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

                            @Override
                            public Boolean execute(boolean lastAttempt) {
                                block8: {
                                    try {
                                        ourFilesDeleteIfExistsMethod.invoke(null, fileObject);
                                        return Boolean.TRUE;
                                    }
                                    catch (InvocationTargetException e) {
                                        Throwable cause = e.getCause();
                                        if (!(cause instanceof IOException)) {
                                            return Boolean.FALSE;
                                        }
                                        if (!ourAccessDeniedExceptionClass.isInstance(cause)) break block8;
                                        try {
                                            File file = (File)ourPathToFileMethod.invoke(fileObject, new Object[0]);
                                            if (file == null) {
                                                return Boolean.FALSE;
                                            }
                                            if (file.delete() || !file.exists()) {
                                                return Boolean.TRUE;
                                            }
                                        }
                                        catch (Throwable ignored) {
                                            return Boolean.FALSE;
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                        return Boolean.FALSE;
                                    }
                                }
                                return lastAttempt ? Boolean.FALSE : null;
                            }
                        });
                        if (!Boolean.TRUE.equals(result)) {
                            throw new IOException("Failed to delete " + fileObject){

                                public synchronized Throwable fillInStackTrace() {
                                    return this;
                                }
                            };
                        }
                    }
                });
                initSuccess = true;
            }
            catch (Throwable ignored) {
                FileUtilRt.logger().info("Was not able to detect NIO API");
                ourFileToPathMethod = null;
                ourFilesWalkMethod = null;
                ourFilesDeleteIfExistsMethod = null;
                ourDeletionVisitor = null;
                ourNoSuchFileExceptionClass = null;
            }
            IS_AVAILABLE = initSuccess;
        }
    }
}

