/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    private final List<RegistryValueListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private Double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;

    RegistryValue(@NotNull Registry registry, @NotNull String key) {
        this.myRegistry = registry;
        this.myKey = key;
    }

    @NotNull
    public String getKey() {
        return this.myKey;
    }

    @NotNull
    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        return value;
    }

    public boolean asBoolean() {
        if (this.myBooleanCachedValue == null) {
            this.myBooleanCachedValue = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return this.myBooleanCachedValue;
    }

    public int asInteger() {
        if (this.myIntCachedValue == null) {
            try {
                this.myIntCachedValue = Integer.valueOf(this.get(this.myKey, "0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = RegistryValue.getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myIntCachedValue = Integer.valueOf(bundleValue);
            }
        }
        return this.myIntCachedValue;
    }

    public double asDouble() {
        if (this.myDoubleCachedValue == null) {
            try {
                this.myDoubleCachedValue = Double.valueOf(this.get(this.myKey, "0.0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = RegistryValue.getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myDoubleCachedValue = Double.valueOf(bundleValue);
            }
        }
        return this.myDoubleCachedValue;
    }

    Color asColor(Color defaultValue) {
        String s = this.get(this.myKey, null, true);
        if (s != null) {
            Color color = ColorUtil.fromHex(s, null);
            if (color != null && this.myKey.contains("color")) {
                return color;
            }
            String[] rgb = s.split(",");
            if (rgb.length == 3) {
                try {
                    return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @NotNull
    public String getDescription() {
        return this.get(this.myKey + ".description", "", false);
    }

    boolean isRestartRequired() {
        return Boolean.valueOf(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return this.isChangedFromDefault(this.asString());
    }

    boolean isChangedFromDefault(@NotNull String newValue) {
        return !newValue.equals(RegistryValue.getBundleValue(this.myKey, false));
    }

    private String get(@NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (isValue) {
            String stringCachedValue = this.myStringCachedValue;
            if (stringCachedValue == null) {
                stringCachedValue = this._get(key, defaultValue, true);
                if (RegistryValue.isBoolean(stringCachedValue)) {
                    stringCachedValue = Boolean.valueOf(stringCachedValue).toString();
                }
                this.myStringCachedValue = stringCachedValue;
            }
            return stringCachedValue;
        }
        return this._get(key, defaultValue, false);
    }

    private String _get(@NotNull String key, String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        String userValue = this.myRegistry.getUserProperties().get(key);
        if (userValue != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        String bundleValue = RegistryValue.getBundleValue(key, mustExistInBundle);
        if (bundleValue != null) {
            return bundleValue;
        }
        return defaultValue;
    }

    private static String getBundleValue(@NotNull String key, boolean mustExist) throws MissingResourceException {
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    public void setValue(boolean value) {
        this.setValue(Boolean.valueOf(value).toString());
    }

    public void setValue(int value) {
        this.setValue(Integer.valueOf(value).toString());
    }

    public void setValue(String value) {
        this.resetCache();
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.myRegistry.getUserProperties().put(this.myKey, value);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
    }

    boolean isChangedSinceAppStart() {
        return this.myChangedSinceStart;
    }

    public void resetToDefault() {
        this.setValue(RegistryValue.getBundleValue(this.myKey, true));
    }

    public void addListener(final @NotNull RegistryValueListener listener, @NotNull Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                RegistryValue.this.myListeners.remove(listener);
            }
        });
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myBooleanCachedValue = null;
    }

    public boolean isBoolean() {
        return RegistryValue.isBoolean(this.asString());
    }

    private static boolean isBoolean(String s) {
        return "true".equals(s) || "false".equals(s);
    }
}

