/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectorMatchingEndFinder {
    public static int findMatchingEnd(@NotNull String startSymbol, @NotNull String endSymbol, @NotNull String text, int afterStartIdx) {
        if (afterStartIdx < 0) {
            return -1;
        }
        Character shortStartSymbol = InjectorMatchingEndFinder.defineShortSymbol(startSymbol);
        Character shortEndSymbol = InjectorMatchingEndFinder.defineShortSymbol(endSymbol);
        if (shortStartSymbol != null || shortEndSymbol != null) {
            return InjectorMatchingEndFinder.findForShortSymbols(InjectorMatchingEndFinder.nonNullifyShortSymbol(shortStartSymbol, startSymbol), InjectorMatchingEndFinder.nonNullifyShortSymbol(shortEndSymbol, endSymbol), text, afterStartIdx, endSymbol);
        }
        return InjectorMatchingEndFinder.findForLongSymbols(text, afterStartIdx, startSymbol, endSymbol);
    }

    private static char nonNullifyShortSymbol(@Nullable Character shortStartSymbol, @NotNull String startSymbol) {
        return shortStartSymbol == null ? startSymbol.charAt(0) : shortStartSymbol.charValue();
    }

    private static Character defineShortSymbol(String s) {
        if (s.length() == 2 && s.charAt(0) == s.charAt(1)) {
            return Character.valueOf(s.charAt(0));
        }
        return null;
    }

    private static int findForShortSymbols(char shortStartSymbol, char shortEndSymbol, @NotNull String text, int afterStartIdx, @NotNull String endSymbol) {
        int lookFrom = afterStartIdx;
        for (int totalNumStarts = 1; totalNumStarts > 0; --totalNumStarts) {
            int nextEndIdx = text.indexOf(endSymbol, lookFrom);
            if (nextEndIdx == -1) {
                return -1;
            }
            int numStarts = InjectorMatchingEndFinder.getOccurrenceCount(text, lookFrom, nextEndIdx, shortStartSymbol);
            int numEnds = InjectorMatchingEndFinder.getOccurrenceCount(text, lookFrom, nextEndIdx, shortEndSymbol);
            lookFrom = nextEndIdx + 1;
            if ((totalNumStarts += numStarts - numEnds) > 0) continue;
            return nextEndIdx;
        }
        return -1;
    }

    private static int findForLongSymbols(@NotNull String text, int afterStartIdx, @NotNull String startSymbol, @NotNull String endSymbol) {
        int totalNumStarts = 1;
        int lookFrom = afterStartIdx;
        while (totalNumStarts > 0) {
            --totalNumStarts;
            int nextEndIdx = text.indexOf(endSymbol, lookFrom);
            if (nextEndIdx == -1) {
                return -1;
            }
            int numStarts = InjectorMatchingEndFinder.getOccurrenceCount(text, lookFrom, nextEndIdx, startSymbol);
            if (numStarts > 0) {
                totalNumStarts += numStarts;
            }
            lookFrom = nextEndIdx + endSymbol.length();
            if (totalNumStarts != 0) continue;
            return nextEndIdx;
        }
        return -1;
    }

    @Contract(pure=true)
    private static int getOccurrenceCount(@NotNull String text, int from, int toExcluding, char c) {
        int res = 0;
        int i = from;
        int limit = Math.min(text.length(), toExcluding);
        while (i < limit && (i = text.indexOf(c, i)) >= 0 && i < limit) {
            ++res;
            ++i;
        }
        return res;
    }

    @Contract(pure=true)
    private static int getOccurrenceCount(@NotNull String text, int from, int toExcluding, String s) {
        int res = 0;
        int i = from;
        int limit = Math.min(text.length(), toExcluding);
        while (i < limit && (i = text.indexOf(s, i)) >= 0 && i < limit) {
            ++res;
            i += s.length();
        }
        return res;
    }
}

