/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    @NonNls
    private static final String VOWELS = "aeiouy";
    @NonNls
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    @NonNls
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    private static final MyHtml2Text html2TextParser = new MyHtml2Text();
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            return "\"" + s + "\"";
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            return "'" + s + "'";
        }
    };
    @NotNull
    public static final Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        @Nullable
        public String fun(@Nullable String s) {
            return StringUtil.trim(s);
        }
    };
    @NonNls
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    @NonNls
    private static final String[] REPLACES_REFS = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;"};
    @NonNls
    private static final String[] REPLACES_DISP = new String[]{"<", ">", "&", "'", "\""};
    @NonNls
    private static final String[] MN_QUOTED = new String[]{"&&", "__"};
    @NonNls
    private static final String[] MN_CHARS = new String[]{"&", "_"};
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-eA-E]{4}");

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        List<String> words = StringUtil.getWordsIn(find);
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                return o2.length() - o1.length();
            }
        });
        return words;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapePattern(@NotNull String text) {
        return StringUtil.replace(StringUtil.replace(text, "'", "''"), "{", "'{'");
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        return new Function<T, String>(){

            @Override
            public String fun(@NotNull T o) {
                return o.toString();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        return StringUtil.replace(text, oldS, newS, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceIgnoreCase(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        return StringUtil.replace(text, oldS, newS, true);
    }

    public static void replaceChar(@NotNull char[] buffer, char oldChar, char newChar, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = buffer[i];
            if (c != oldChar) continue;
            buffer[i] = newChar;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        StringBuilder newBuffer = null;
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == oldChar) {
                if (newBuffer == null) {
                    newBuffer = new StringBuilder(buffer.length());
                    newBuffer.append(buffer, 0, i);
                }
                newBuffer.append(newChar);
                continue;
            }
            if (newBuffer == null) continue;
            newBuffer.append(c);
        }
        return newBuffer == null ? buffer : newBuffer.toString();
    }

    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @NotNull String newS, boolean ignoreCase) {
        if (text.length() < oldS.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text, oldS, i) : text.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newText == null) {
                if (text.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text.length() - i);
            }
            newText.append(text, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        int sourceCount = where.length();
        for (int i = Math.max(fromIndex, 0); i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String suffix) {
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        if (convertBreaks) {
            html = html.replaceAll("<br/?>", "\n\n");
        }
        return html.replaceAll("<(.|\n)*?>", "");
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase();
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName) {
        return StringUtil.getPackageName(fqName, '.');
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName, char separator) {
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx >= 0) {
            return fqName.substring(0, lastPointIdx);
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeLineBreak(@NotNull String text) {
        StringBuilder buffer = new StringBuilder(text.length());
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text) {
        int len = text.length();
        return len > 0 && StringUtil.isLineBreak(text.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text, int line, int col) {
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text, int offset) {
        int curLine = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text.length()) {
                return -1;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset >= text.length() - 1 || text.charAt(curOffset + 1) != '\n') continue;
            ++curOffset;
        }
        return curLine;
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        return StringUtil.fixCapitalization(s, ourPrepositions, true);
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        return StringUtil.fixCapitalization(s, ourPrepositions, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String toTitleCase(@NotNull String s) {
        return StringUtil.fixCapitalization(s, ArrayUtil.EMPTY_STRING_ARRAY, true);
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, @NotNull String[] prepositions, boolean title) {
        StringBuilder buffer = null;
        for (int i = 0; i < s.length(); ++i) {
            int j;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
            }
            if (!title && j > i + 1 && !Character.isLowerCase(s.charAt(i + 1)) || StringUtil.isPreposition(s, i, j - 1, prepositions)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(i, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        return buffer == null ? s : buffer.toString();
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar) {
        return StringUtil.isPreposition(s, firstChar, lastChar, ourPrepositions);
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, @NotNull String[] prepositions) {
        for (String preposition : prepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == preposition.charAt(j)) continue;
                    found = false;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static NotNullFunction<String, String> escaper(final boolean escapeSlash, final @Nullable String additionalChars) {
        return new NotNullFunction<String, String>(){

            @Override
            @NotNull
            public String fun(@NotNull String dom) {
                StringBuilder builder = new StringBuilder(dom.length());
                StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
                return builder.toString();
            }
        };
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull @NonNls StringBuilder buffer) {
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull @NonNls StringBuilder buffer) {
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull @NonNls StringBuilder buffer) {
        return StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull @NonNls StringBuilder buffer) {
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        CharSequence hexCode = StringUtilRt.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        return buffer;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeStringCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        return buffer.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeCharCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        return buffer.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        return buffer.toString();
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch = s.charAt(ind);
        return ch == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        return s.length() > 1 && StringUtil.isQuoteAt(s, 0) && s.charAt(0) == s.charAt(s.length() - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (StringUtil.isQuotedString(s)) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s.length() > 1 && quotationChar == s.charAt(0) && quotationChar == s.charAt(s.length() - 1)) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    @NotNull
    @Contract(pure=true)
    public static String quoteReplacement(@NotNull String s) {
        boolean needReplacements = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '$') continue;
            needReplacements = true;
            break;
        }
        if (!needReplacements) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() * 6 / 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String word) {
        String plural = Pluralizer.PLURALIZER.plural(word);
        if (plural != null) {
            return plural;
        }
        if (word.endsWith("s")) {
            return Pluralizer.restoreCase(word, word + "es");
        }
        return Pluralizer.restoreCase(word, word + "s");
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text, boolean allWords) {
        return StringUtil.capitalizeWords(text, " \t\n\r\f", allWords, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text, @NotNull String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(text, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder(text.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        return out.toString();
    }

    @Contract(pure=true)
    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return VOWELS.indexOf(c) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalize(@NotNull String s) {
        if (s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return StringUtilRt.toUpperCase(s).toString();
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return StringUtil.capitalize(s);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars[off];
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars.charAt(off);
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        return StringUtil.stringHashCodeIgnoreWhitespaces(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        return StringUtil.trimEnd(s, suffix, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        boolean bl = endsWith = ignoreCase ? StringUtil.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, char suffix) {
        if (StringUtil.endsWithChar(s, suffix)) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLog(@NotNull String text, int limit) {
        if (limit > 5 && text.length() > limit) {
            return text.substring(0, limit - 5) + " ...\n";
        }
        return text;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string) {
        return StringUtil.trimLeading((CharSequence)string).toString();
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimLeading(@NotNull CharSequence string) {
        int index;
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        return string.subSequence(index, string.length());
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string, char symbol) {
        int index;
        for (index = 0; index < string.length() && string.charAt(index) == symbol; ++index) {
        }
        return string.substring(index);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string) {
        return StringUtil.trimTrailing((CharSequence)string).toString();
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimTrailing(@NotNull CharSequence string) {
        int index;
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        return string.subSequence(0, index + 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string, char symbol) {
        int index;
        for (index = string.length() - 1; index >= 0 && string.charAt(index) == symbol; --index) {
        }
        return string.substring(0, index + 1);
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimExtensions(@NotNull String name) {
        int index = name.indexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String base, int n) {
        if (n == 1) {
            return base;
        }
        return StringUtil.pluralize(base);
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return s != null && !s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        return StringUtil.notNullize(s, "");
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        return s == null ? defaultValue : s;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        if (nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s)) {
            return null;
        }
        return s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        return ExceptionUtil.getThrowableText(aThrowable);
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable, @NonNls @NotNull String stackFrameSkipPattern) {
        return ExceptionUtil.getThrowableText(aThrowable, stackFrameSkipPattern);
    }

    @Nullable
    @Contract(pure=true)
    public static String getMessage(@NotNull Throwable e) {
        return ExceptionUtil.getMessage(e);
    }

    @NotNull
    @Contract(pure=true)
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        return StringFactory.createShared(buffer);
    }

    @NotNull
    @Contract(pure=true)
    public static String repeat(@NotNull String s, int count) {
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(s.length());
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && !inQuotes) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        return StringUtil.split(s, separator, true);
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        return StringUtil.split(s, separator, true, true);
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (separator.length() == 0) {
            return Collections.singletonList(s);
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        return new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(final @NotNull java.util.StringTokenizer tokenizer) {
        return new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsIn(@NotNull String text) {
        SmartList<String> result = null;
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                if (result == null) {
                    result = new SmartList();
                }
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result == null) {
                result = new SmartList<String>();
            }
            result.add(text.substring(start, i));
            start = -1;
        }
        if (result == null) {
            return ContainerUtil.emptyList();
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text) {
        SmartList<TextRange> result = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                result.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(new TextRange(start, i));
            start = -1;
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, @NotNull String separator) {
        return StringUtil.join(strings, 0, strings.length, separator);
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, int startIndex, int endIndex, @NotNull String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        return result.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String[] zip(@NotNull String[] strings1, @NotNull String[] strings2, String separator) {
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] surround(@NotNull String[] strings1, String prefix, String suffix) {
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings1[i] + suffix;
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull T[] items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        return StringUtil.join(Arrays.asList(items), f, separator);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items.isEmpty()) {
            return "";
        }
        return StringUtil.join(items, f, separator);
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull @NonNls String separator) {
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(item).append(separator);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - separator.length());
        }
        return result.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        StringBuilder result = new StringBuilder();
        StringUtil.join(items, f, separator, result);
        return result.toString();
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator, @NotNull StringBuilder result) {
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.isEmpty()) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings.size() <= 1) {
            return StringUtil.notNullize(ContainerUtil.getFirstItem(strings));
        }
        StringBuilder result = new StringBuilder();
        StringUtil.join(strings, separator, result);
        return result.toString();
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result) {
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(separator);
            }
            result.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull int[] strings, @NotNull String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        return result.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        return builder.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String stripQuotesAroundValue(@NotNull String text) {
        int len = text.length();
        if (len > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                return text.substring(from, to);
            }
        }
        return text;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize) {
        return StringUtil.formatValue(fileSize, null, new String[]{"B", "K", "M", "G", "T", "P", "E"}, new long[]{1000L, 1000L, 1000L, 1000L, 1000L, 1000L});
    }

    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration) {
        return StringUtil.formatValue(duration, " ", new String[]{"ms", "s", "m", "h", "d", "w", "mo", "yr", "c", "ml", "ep"}, new long[]{1000L, 60L, 60L, 24L, 7L, 4L, 12L, 100L, 10L, 10000L});
    }

    @NotNull
    private static String formatValue(long value, String partSeparator, String[] units, long[] multipliers) {
        int i;
        StringBuilder sb = new StringBuilder();
        long count = value;
        long remainder = 0L;
        for (i = 0; i < units.length; ++i) {
            long multiplier;
            long l = multiplier = i < multipliers.length ? multipliers[i] : -1L;
            if (multiplier == -1L || count < multiplier) break;
            remainder = count % multiplier;
            count /= multiplier;
            if (partSeparator == null || remainder == 0L && sb.length() <= 0) continue;
            sb.insert(0, units[i]).insert(0, remainder).insert(0, partSeparator);
        }
        if (partSeparator != null || remainder == 0L) {
            sb.insert(0, units[i]).insert(0, count);
        } else if (remainder > 0L) {
            sb.append(String.format(Locale.US, "%.2f", (double)count + (double)remainder / (double)multipliers[i - 1])).append(units[i]);
        }
        return sb.toString();
    }

    @Nullable
    @Contract(pure=true)
    public static String unpluralize(@NotNull String word) {
        String singular = Pluralizer.PLURALIZER.singular(word);
        if (singular != null) {
            return singular;
        }
        if (word.endsWith("es")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "es", true));
        }
        if (word.endsWith("s")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "s", true));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (chars.length() > value.length()) {
            return StringUtil.containsAnyChar(value, chars, 0, value.length());
        }
        return StringUtil.containsAnyChar(chars, value, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        return value.indexOf(ch) >= 0;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String firstLetterToUpperCase(@Nullable String displayString) {
        if (displayString == null || displayString.isEmpty()) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return StringFactory.createShared(buffer);
    }

    @NotNull
    @Contract(pure=true)
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        return result.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        return StringUtil.findMatches(s, pattern, 1);
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        SmartList<String> result = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result.add(group);
        }
        return result;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        return range.replace(string, replacement);
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text) {
        return !text.isEmpty() && Character.isWhitespace(text.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        int l2;
        int l1 = text.length();
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        int l2;
        int l1 = text.length() - startIndex;
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        return s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        return s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        return StringUtil.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        return StringUtil.indexOf(sequence, infix) >= 0;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        return StringUtil.indexOf(sequence, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        for (int i = start; i <= sequence.length() - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull char[] s, char c, int start, int end, boolean caseSensitive) {
        end = Math.min(end, s.length);
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s[i], c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text, @NotNull String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        return StringUtil.indexOfAny((CharSequence)s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringBefore(@NotNull String text, @NotNull String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(0, i);
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfter(@NotNull String text, @NotNull String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @NotNull
    @Contract(pure=true)
    public static String first(@NotNull String text, int maxLength, boolean appendEllipsis) {
        return text.length() > maxLength ? text.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence first(@NotNull CharSequence text, int length, boolean appendEllipsis) {
        return text.length() > length ? text.subSequence(0, length) + (appendEllipsis ? "..." : "") : text;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence last(@NotNull CharSequence text, int length, boolean prependEllipsis) {
        return text.length() > length ? (prependEllipsis ? "..." : "") + text.subSequence(text.length() - length, text.length()) : text;
    }

    @NotNull
    @Contract(pure=true)
    public static String firstLast(@NotNull String text, int length) {
        return text.length() > length ? text.subSequence(0, length / 2) + "\u2026" + text.subSequence(text.length() - length / 2 - 1, text.length()) : text;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChar(@NotNull String str, char character) {
        return StringUtil.escapeChars(str, character);
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChars(@NotNull String str, char ... character) {
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        return buf.toString();
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeQuotes(@NotNull String str) {
        return StringUtil.escapeChar(str, '\"');
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        StringUtil.escapeChar(buf, '\"');
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeSlashes(@NotNull String str) {
        return StringUtil.escapeChar(str, '/');
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeBackSlashes(@NotNull String str) {
        return StringUtil.escapeChar(str, '\\');
    }

    public static void escapeSlashes(@NotNull StringBuilder buf) {
        StringUtil.escapeChar(buf, '/');
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeSlashes(@NotNull String str) {
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '/');
        return buf.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeBackSlashes(@NotNull String str) {
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        return buf.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        return buf.toString();
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder) {
        StringUtil.quote(builder, '\"');
    }

    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @NotNull
    @Contract(pure=true)
    public static String wrapWithDoubleQuote(@NotNull String str) {
        return '\"' + str + "\"";
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_REFS, REPLACES_DISP);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_DISP, REPLACES_REFS);
    }

    public static String removeHtmlTags(@Nullable String htmlString) {
        if (StringUtil.isEmpty(htmlString)) {
            return htmlString;
        }
        try {
            html2TextParser.parse(new StringReader(htmlString));
        }
        catch (IOException e) {
            LOG.error(e);
        }
        return html2TextParser.getText();
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeMnemonics(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, MN_CHARS, MN_QUOTED);
    }

    @NotNull
    @Contract(pure=true)
    public static String htmlEmphasize(@NotNull String text) {
        return "<b><code>" + StringUtil.escapeXml(text) + "</code></b>";
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeToRegexp(@NotNull String text) {
        StringBuilder result = new StringBuilder(text.length());
        return StringUtil.escapeToRegexp(text, result).toString();
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text, @NotNull StringBuilder builder) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            builder.append('\\').append(c);
        }
        return builder;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull char[] chars, int startOffset, int backslashOffset) {
        if (chars[backslashOffset] != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = chars[i] == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text, int startOffset, int backslashOffset) {
        if (text.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text.charAt(i) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull String[] from, @NotNull String[] to) {
        return StringUtil.replace(text, Arrays.asList(from), Arrays.asList(to));
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull List<String> from, @NotNull List<String> to) {
        assert (from.size() == to.size());
        StringBuilder result = new StringBuilder(text.length());
        block0: for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (!text.regionMatches(i, toReplace, 0, len)) continue;
                result.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            result.append(text.charAt(i));
        }
        return result.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String[] filterEmptyStrings(@NotNull String[] strings) {
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            return strings;
        }
        String[] result = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result[count++] = string;
        }
        return result;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text) {
        return StringUtil.countChars(text, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c) {
        return StringUtil.countChars(text, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int offset, boolean stopAtOtherChar) {
        return StringUtil.countChars(text, c, offset, text.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int start, int end, boolean stopAtOtherChar) {
        int count = 0;
        int len = Math.min(text.length(), end);
        for (int i = start; i < len; ++i) {
            if (text.charAt(i) == c) {
                ++count;
                continue;
            }
            if (stopAtOtherChar) break;
        }
        return count;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalsOnly(@NotNull String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    @Nullable
    @Contract(pure=true)
    public static String joinOrNull(String ... args) {
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Nullable
    @Contract(pure=true)
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text) {
        int len = text.length();
        if (len == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        return escaped.toString();
    }

    @Contract(pure=true)
    public static String getQualifiedName(@Nullable String packageName, String className) {
        if (packageName == null || packageName.isEmpty()) {
            return className;
        }
        return packageName + '.' + className;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        String[] parts;
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        boolean left = part1.length > idx;
        String[] stringArray = parts = left ? part1 : part2;
        while (idx < parts.length) {
            String p = parts[idx];
            int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
            if (cmp != 0) {
                return left ? cmp : -cmp;
            }
            ++idx;
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, char c) {
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, @NotNull String s) {
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (StringUtil.isEmptyOrSpaces(name)) {
            return name;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            return "an" + Character.toUpperCase(c) + name.substring(1);
        }
        return "a" + Character.toUpperCase(c) + name.substring(1);
    }

    @NotNull
    @Contract(pure=true)
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result.append("_");
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String tail(@NotNull String s, int idx) {
        return idx >= s.length() ? "" : s.substring(idx, s.length());
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string) {
        return StringUtil.splitByLines(string, true);
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string, boolean excludeEmptyStrings) {
        return (excludeEmptyStrings ? EOL_SPLIT_PATTERN : EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesDontTrim(@NotNull String string) {
        return EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesKeepSeparators(@NotNull String string) {
        return EOL_SPLIT_KEEP_SEPARATORS.split(string);
    }

    @NotNull
    @Contract(pure=true)
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        ArrayList<Pair<String, Integer>> res = ContainerUtil.newArrayList();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        return res;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return StringUtil.naturalCompare(string1, string2, false);
    }

    @Contract(pure=true)
    private static int naturalCompare(@Nullable String string1, @Nullable String string2, boolean caseSensitive) {
        int j;
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            int diff2;
            int diff1;
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDecimalDigit(ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit(ch2) || ch2 == ' ')) {
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDecimalDigit(string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDecimalDigit(string2.charAt(j))) {
                    ++j;
                }
                int lengthDiff = i - startNum1 - (j - startNum2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                --i;
                --j;
                continue;
            }
            if (caseSensitive) {
                return ch1 - ch2;
            }
            if (ch1 == ch2 || (diff1 = StringUtilRt.toUpperCase(ch1) - StringUtilRt.toUpperCase(ch2)) == 0 || (diff2 = StringUtilRt.toLowerCase(ch1) - StringUtilRt.toLowerCase(ch2)) == 0) continue;
            return diff2;
        }
        if (i < string1Length) {
            return 1;
        }
        if (j < string2Length) {
            return -1;
        }
        if (!caseSensitive && string1Length == string2Length) {
            return StringUtil.naturalCompare(string1, string2, true);
        }
        return string1Length - string2Length;
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static int hashCode(@NotNull CharSequence s) {
        return StringUtil.stringHashCode(s);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (StringUtil.charsMatch(s1.charAt(i), s2.charAt(i), true)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        char c;
        int start2;
        char c2;
        int start1;
        int end1 = s1.length();
        int end2 = s2.length();
        for (start1 = 0; start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(start1)); ++start1) {
        }
        while (start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(end1 - 1))) {
            --end1;
        }
        for (start2 = 0; start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(start2)); ++start2) {
        }
        while (start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(end2 - 1))) {
            --end2;
        }
        CharSequenceSubSequence ts1 = new CharSequenceSubSequence(s1, start1, end1);
        CharSequenceSubSequence ts2 = new CharSequenceSubSequence(s2, start2, end2);
        return StringUtil.equals(ts1, ts2);
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where) {
        for (String string : where) {
            if (!StringUtil.equalsIgnoreCase(toFind, string)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatLinks(@NotNull String message) {
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9\\./\\-\\+]+");
        StringBuffer result = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result);
        return result.toString();
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength) {
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimMiddle(@NotNull String text, int maxLength) {
        return StringUtil.shortenTextWithEllipsis(text, maxLength, maxLength >> 1, true);
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, @NotNull String symbol) {
        int textLength = text.length();
        if (textLength > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength > 0);
            return text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength);
        }
        return text;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        String symbol = useEllipsisSymbol ? "\u2026" : "...";
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, symbol);
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength, boolean useEllipsisSymbol) {
        return StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength) {
        return StringUtil.shortenPathWithEllipsis(path, maxLength, false);
    }

    @Contract(pure=true)
    public static boolean charsEqual(char a, char b, boolean ignoreCase) {
        return ignoreCase ? StringUtil.charsEqualIgnoreCase(a, b) : a == b;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtilRt.charsEqualIgnoreCase(a, b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String a) {
        return a == null ? null : StringUtilRt.toUpperCase(a).toString();
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text) {
        int index = StringUtil.indexOfAny(text, "\n\r");
        if (index == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text, index);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text, int index) {
        if (index < 0 || index >= text.length()) {
            return null;
        }
        char ch = text.charAt(index);
        if (ch == '\r') {
            return index + 1 < text.length() && text.charAt(index + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text) {
        return StringUtilRt.convertLineSeparators(text);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        return StringUtilRt.convertLineSeparators(text, keepCarriageReturn);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        return StringUtilRt.convertLineSeparators(text, newSeparator);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        return StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        return StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep, keepCarriageReturn);
    }

    @Contract(pure=true)
    public static int parseInt(String string, int defaultValue) {
        return StringUtilRt.parseInt(string, defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        return StringUtilRt.parseLong(string, defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(String string, double defaultValue) {
        return StringUtilRt.parseDouble(string, defaultValue);
    }

    @Contract(pure=true)
    public static boolean parseBoolean(String string, boolean defaultValue) {
        return StringUtilRt.parseBoolean(string, defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        return StringUtilRt.parseEnum(string, defaultValue, clazz);
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class aClass) {
        return StringUtilRt.getShortName(aClass);
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName) {
        return StringUtilRt.getShortName(fqName);
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName, char separator) {
        return StringUtilRt.getShortName(fqName, separator);
    }

    @Contract(value="null->null;!null->!null")
    static String toShortString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return o.toString();
        }
        String className = o.getClass().getName();
        String s = o.toString();
        if (!s.startsWith(className)) {
            return s;
        }
        return s.length() > className.length() && !Character.isLetter(s.charAt(className.length())) ? StringUtil.trimStart(s, className) : s;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence, long delay) {
        final long myTime = System.currentTimeMillis() + delay;
        return new BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string, @NotNull String smallPart, @NotNull String bigPart) {
        String s = string.toLowerCase();
        return s.startsWith(smallPart.toLowerCase()) && bigPart.toLowerCase().startsWith(s);
    }

    public static boolean hasUpperCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text.length());
        while (matcher.find()) {
            sb.append(text.substring(lastEnd, matcher.start()));
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text.substring(lastEnd, text.length()));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(@NotNull byte[] bytes) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static boolean startsWithConcatenationOf(@NotNull String string, @NotNull String firstPrefix, @NotNull String secondPrefix) {
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix);
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;

        public BombedCharSequence(@NotNull CharSequence sequence) {
            this.delegate = sequence;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            return this.delegate.toString();
        }

        protected abstract void checkCanceled();

        @Override
        @NotNull
        public CharSequence subSequence(int i, int i1) {
            this.check();
            return this.delegate.subSequence(i, i1);
        }
    }

    private static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();

        private MyHtml2Text() {
        }

        public void parse(Reader in) throws IOException {
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char[] text, int pos) {
            this.myBuffer.append(text);
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(HTML.Tag tag) {
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }

        public String getText() {
            return this.myBuffer.toString();
        }
    }
}

