/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.KeyboardLayoutUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixingLayoutMatcher
extends MinusculeMatcher {
    @Nullable
    private final MinusculeMatcher myFixedMatcher;

    FixingLayoutMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        super(pattern, options, hardSeparators);
        String s = FixingLayoutMatcher.fixPattern(pattern);
        this.myFixedMatcher = s == null ? null : new MinusculeMatcher(s, options, hardSeparators);
    }

    @Nullable
    private static String fixPattern(String pattern) {
        boolean hasLetters = false;
        boolean onlyWrongLetters = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (!Character.isLetter(c)) continue;
            hasLetters = true;
            if (c > '\u007f') continue;
            onlyWrongLetters = false;
            break;
        }
        if (hasLetters && onlyWrongLetters) {
            char[] alternatePattern = new char[pattern.length()];
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                Character newC = KeyboardLayoutUtil.getAsciiForChar(c);
                alternatePattern[i] = newC == null ? c : newC.charValue();
            }
            return new String(alternatePattern);
        }
        return null;
    }

    @Override
    public boolean matches(@NotNull String name) {
        return super.matches(name) || this.myFixedMatcher != null && this.myFixedMatcher.matches(name);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        FList<TextRange> ranges = super.matchingFragments(name);
        if (this.myFixedMatcher == null || ranges != null && !ranges.isEmpty()) {
            return ranges;
        }
        return this.myFixedMatcher.matchingFragments(name);
    }
}

