/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProcessors {
    private static final Processor FALSE = new Processor<Object>(){

        @Override
        public boolean process(Object t) {
            return false;
        }
    };
    private static final Processor TRUE = new Processor<Object>(){

        @Override
        public boolean process(Object t) {
            return true;
        }
    };

    @NotNull
    public static <T> Processor<T> notNullProcessor(final @NotNull Processor<T> processor) {
        return new Processor<T>(){

            @Override
            public boolean process(@NotNull T t) {
                return processor.process(t);
            }
        };
    }

    @NotNull
    public static <T> Processor<T> alwaysFalse() {
        return FALSE;
    }

    @NotNull
    public static <T> Processor<T> alwaysTrue() {
        return TRUE;
    }

    public static class FindFirstAndOnlyProcessor<T>
    extends FindFirstProcessor<T> {
        @Override
        public boolean process(T t) {
            boolean firstFound = this.getFoundValue() != null;
            boolean result = super.process(t);
            if (!result) {
                if (firstFound) {
                    this.reset();
                }
                return !firstFound;
            }
            return true;
        }
    }

    public static class FindFirstProcessor<T>
    extends FindProcessor<T> {
        @Override
        protected boolean accept(T t) {
            return true;
        }
    }

    public static abstract class FindProcessor<T>
    implements Processor<T> {
        private T myValue;

        public boolean isFound() {
            return this.myValue != null;
        }

        @Nullable
        public T getFoundValue() {
            return this.myValue;
        }

        @Nullable
        public T reset() {
            T prev = this.myValue;
            this.myValue = null;
            return prev;
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myValue = t;
                return false;
            }
            return true;
        }

        protected abstract boolean accept(T var1);
    }

    public static class UniqueProcessor<T>
    implements Processor<T> {
        private final Set<T> processed;
        private final Processor<T> myDelegate;

        public UniqueProcessor(@NotNull Processor<T> delegate) {
            this(delegate, ContainerUtil.canonicalStrategy());
        }

        public UniqueProcessor(@NotNull Processor<T> delegate, @NotNull TObjectHashingStrategy<T> strategy) {
            this.myDelegate = delegate;
            this.processed = new THashSet(strategy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean process(T t) {
            Set<T> set = this.processed;
            synchronized (set) {
                if (!this.processed.add(t)) {
                    return true;
                }
            }
            return this.myDelegate.process(t);
        }
    }

    public static class CollectUniquesProcessor<T>
    implements Processor<T> {
        private final Set<T> myCollection = new HashSet<T>();

        @Override
        public boolean process(T t) {
            this.myCollection.add(t);
            return true;
        }

        @NotNull
        public T[] toArray(@NotNull T[] a) {
            return this.myCollection.toArray(a);
        }

        @NotNull
        public Collection<T> getResults() {
            return this.myCollection;
        }
    }

    public static class CollectProcessor<T>
    implements Processor<T> {
        private final Collection<T> myCollection;

        public CollectProcessor(@NotNull Collection<T> collection) {
            this.myCollection = collection;
        }

        public CollectProcessor() {
            this.myCollection = new ArrayList<T>();
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myCollection.add(t);
            }
            return true;
        }

        protected boolean accept(T t) {
            return true;
        }

        @NotNull
        public T[] toArray(@NotNull T[] a) {
            return this.myCollection.toArray(a);
        }

        @NotNull
        public Collection<T> getResults() {
            return this.myCollection;
        }
    }
}

