/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EventDispatcher");
    private final T myMulticaster;
    private final List<T> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        return new EventDispatcher<T>(listenerClass);
    }

    private EventDispatcher(@NotNull Class<T> listenerClass) {
        this.myMulticaster = (EventListener)EventDispatcher.createMulticaster(listenerClass, new Getter<Iterable<T>>(){

            @Override
            public Iterable<T> get() {
                return EventDispatcher.this.myListeners;
            }
        });
    }

    @NotNull
    static <T> T createMulticaster(@NotNull Class<T> listenerClass, final Getter<Iterable<T>> listeners) {
        LOG.assertTrue(listenerClass.isInterface(), "listenerClass must be an interface");
        InvocationHandler handler = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                    String methodName = method.getName();
                    if (methodName.equals("toString")) {
                        return "Multicaster";
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy);
                    }
                    if (methodName.equals("equals")) {
                        return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                    }
                    LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
                    return null;
                }
                EventDispatcher.dispatch((Iterable)listeners.get(), method, args);
                return null;
            }
        };
        return (T)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
    }

    @NotNull
    public T getMulticaster() {
        return this.myMulticaster;
    }

    private static <T> void dispatch(Iterable<T> listeners, @NotNull Method method, Object[] args) {
        method.setAccessible(true);
        for (T listener : listeners) {
            try {
                method.invoke(listener, args);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof AbstractMethodError) continue;
                LOG.error(cause);
            }
        }
    }

    public void addListener(@NotNull T listener) {
        this.myListeners.add(listener);
    }

    public void addListener(@NotNull T listener, @NotNull Disposable parentDisposable) {
        this.addListener(listener);
        Disposer.register(parentDisposable, new Disposable((EventListener)listener){
            final /* synthetic */ EventListener val$listener;
            {
                this.val$listener = eventListener;
            }

            @Override
            public void dispose() {
                EventDispatcher.this.removeListener(this.val$listener);
            }
        });
    }

    public void removeListener(@NotNull T listener) {
        this.myListeners.remove(listener);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    @NotNull
    public List<T> getListeners() {
        return this.myListeners;
    }
}

